/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.internal.ui.editor.ModelElementHyperlinkDetector;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.text.HTMLAnnotationHover;
import org.eclipse.dltk.internal.ui.text.HTMLTextPresenter;
import org.eclipse.dltk.internal.ui.text.ScriptCompositeReconcilingStrategy;
import org.eclipse.dltk.internal.ui.text.ScriptElementProvider;
import org.eclipse.dltk.internal.ui.text.ScriptReconciler;
import org.eclipse.dltk.internal.ui.text.hover.EditorTextHoverDescriptor;
import org.eclipse.dltk.internal.ui.text.hover.EditorTextHoverProxy;
import org.eclipse.dltk.internal.ui.text.hover.ScriptInformationProvider;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.formatter.ScriptFormatterManager;
import org.eclipse.dltk.ui.formatter.ScriptFormattingStrategy;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptCommentScanner;
import org.eclipse.dltk.ui.text.ScriptOutlineInformationControl;
import org.eclipse.dltk.ui.text.TodoTaskPreferencesOnPreferenceStore;
import org.eclipse.dltk.ui.text.completion.ContentAssistPreference;
import org.eclipse.dltk.ui.text.util.AutoEditUtils;
import org.eclipse.dltk.ui.text.util.TabStyle;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class ScriptSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private IColorManager fColorManager;
    private ITextEditor fTextEditor;
    private String fDocumentPartitioning;

    public ScriptSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(preferenceStore);
        this.fColorManager = colorManager;
        this.fTextEditor = editor;
        this.fDocumentPartitioning = partitioning;
        this.initializeScanners();
    }

    protected void initializeScanners() {
    }

    protected final AbstractScriptScanner createCommentScanner(String commentColor, String tagColor) {
        return this.createCommentScanner(commentColor, tagColor, (ITodoTaskPreferences)new TodoTaskPreferencesOnPreferenceStore(this.fPreferenceStore));
    }

    protected AbstractScriptScanner createCommentScanner(String commentColor, String tagColor, ITodoTaskPreferences taskPrefs) {
        return new ScriptCommentScanner(this.getColorManager(), this.fPreferenceStore, commentColor, tagColor, taskPrefs);
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(sourceViewer);
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    public ITextEditor getEditor() {
        return this.fTextEditor;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        ITextEditor editor = this.getEditor();
        if (editor != null && editor.isEditable()) {
            ScriptCompositeReconcilingStrategy strategy = new ScriptCompositeReconcilingStrategy(editor, this.getConfiguredDocumentPartitioning(sourceViewer));
            ScriptReconciler reconciler = new ScriptReconciler(editor, strategy, false);
            reconciler.setIsAllowedToModifyDocument(false);
            reconciler.setIsIncrementalReconciler(false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return false;
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{this.getCommentPrefix(), ""};
    }

    protected String getCommentPrefix() {
        return "#";
    }

    protected IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new ScriptOutlineInformationControl(parent, shellStyle, treeStyle, commandId, ScriptSourceViewerConfiguration.this.fPreferenceStore);
            }
        };
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
        InformationPresenter presenter = doCodeResolve ? new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, "org.eclipse.dltk.ui.navigate.script.open.structure")) : new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, "org.eclipse.dltk.ui.edit.text.script.show.outline"));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        ScriptElementProvider provider = new ScriptElementProvider((IEditorPart)this.getEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        this.initializeQuickOutlineContexts(presenter, provider);
        String[] stringArray = this.getOutlinePresenterContentTypes(sourceViewer, doCodeResolve);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentType = stringArray[n2];
            if (!"__dftl_partition_content_type".equals(contentType) && presenter.getInformationProvider(contentType) == null) {
                presenter.setInformationProvider((IInformationProvider)provider, contentType);
            }
            ++n2;
        }
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    protected String[] getOutlinePresenterContentTypes(ISourceViewer sourceViewer, boolean doCodeResolve) {
        return this.getConfiguredContentTypes(sourceViewer);
    }

    @Deprecated
    protected void initializeQuickOutlineContexts(InformationPresenter presenter, IInformationProvider provider) {
    }

    public IInformationPresenter getHierarchyPresenter(ScriptSourceViewer viewer, boolean b) {
        return null;
    }

    protected IDialogSettings getSettings(String sectionName) {
        IDialogSettings settings = DLTKUIPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = DLTKUIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (this.fTextEditor == null) {
            return inheritedDetectors;
        }
        int inheritedDetectorsLength = inheritedDetectors != null ? inheritedDetectors.length : 0;
        IHyperlinkDetector[] detectors = new IHyperlinkDetector[inheritedDetectorsLength + 1];
        int i = 0;
        while (i < inheritedDetectorsLength) {
            detectors[i] = inheritedDetectors[i];
            ++i;
        }
        detectors[inheritedDetectorsLength] = new ModelElementHyperlinkDetector(this.fTextEditor);
        return detectors;
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        String natureId = this.getNatureId();
        if (natureId == null) {
            return null;
        }
        EditorTextHoverDescriptor[] hoverDescs = DLTKUIPlugin.getDefault().getEditorTextHoverDescriptors(this.fPreferenceStore, natureId);
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = hoverDescs[i].getStateMask();
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        String natureId = this.getNatureId();
        if (natureId == null) {
            return null;
        }
        EditorTextHoverDescriptor[] hoverDescs = DLTKUIPlugin.getDefault().getEditorTextHoverDescriptors(this.fPreferenceStore, natureId);
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled() && hoverDescs[i].getStateMask() == stateMask) {
                return new EditorTextHoverProxy(hoverDescs[i], (IEditorPart)this.getEditor(), this.fPreferenceStore);
            }
            ++i;
        }
        return null;
    }

    private String getNatureId() {
        ITextEditor editor = this.getEditor();
        if (editor == null || !(editor instanceof ScriptEditor)) {
            return null;
        }
        return ((ScriptEditor)editor).getLanguageToolkit().getNatureId();
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    private IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 20;
                int style = 768;
                return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        ScriptInformationProvider provider = new ScriptInformationProvider((IEditorPart)this.getEditor());
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setSizeConstraints(60, 10, true, true);
        return presenter;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.getEditor() != null) {
            ContentAssistant assistant = new ContentAssistant();
            assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            assistant.setRestoreCompletionProposalSize(this.getSettings("completion_proposal_size"));
            assistant.setContextInformationPopupOrientation(20);
            assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            this.alterContentAssistant(assistant);
            this.getContentAssistPreference().configure(assistant, this.fPreferenceStore);
            return assistant;
        }
        return null;
    }

    protected abstract ContentAssistPreference getContentAssistPreference();

    protected void alterContentAssistant(ContentAssistant assistant) {
    }

    public String getFontPropertyPreferenceKey() {
        return "org.eclipse.jface.textfont";
    }

    public void changeContentAssistantConfiguration(ContentAssistant c, PropertyChangeEvent event) {
        this.getContentAssistPreference().changeConfiguration(c, this.fPreferenceStore, event);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        String natureId = this.getNatureId();
        if (ScriptFormatterManager.hasFormatterFor(natureId)) {
            MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
            formatter.setMasterStrategy((IFormattingStrategy)new ScriptFormattingStrategy(natureId));
            return formatter;
        }
        return super.getContentFormatter(sourceViewer);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        if (this.fPreferenceStore == null) {
            return super.getIndentPrefixes(sourceViewer, contentType);
        }
        TabStyle tabStyle = this.getTabStyle();
        int tabWidth = this.getTabWidth(sourceViewer);
        int indentWidth = this.getIndentationSize(sourceViewer);
        if (tabStyle != TabStyle.TAB && indentWidth < tabWidth) {
            return new String[]{AutoEditUtils.getNSpaces(indentWidth), "\t", ""};
        }
        if (tabStyle == TabStyle.TAB) {
            return this.getIndentPrefixesForTab(tabWidth);
        }
        return this.getIndentPrefixesForSpaces(tabWidth);
    }

    protected TabStyle getTabStyle() {
        TabStyle tabStyle;
        if (this.fPreferenceStore != null && (tabStyle = TabStyle.forName(this.fPreferenceStore.getString("formatter.tabulation.char"))) != null) {
            return tabStyle;
        }
        return TabStyle.TAB;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getTabWidth(sourceViewer);
        }
        return this.fPreferenceStore.getInt("formatter.tabulation.size");
    }

    protected int getIndentationSize(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getTabWidth(sourceViewer);
        }
        return this.fPreferenceStore.getInt("formatter.indentation.size");
    }

    protected String[] getIndentPrefixesForSpaces(int tabWidth) {
        String[] indentPrefixes = new String[tabWidth + 2];
        indentPrefixes[0] = AutoEditUtils.getNSpaces(tabWidth);
        int i = 0;
        while (i < tabWidth) {
            indentPrefixes[i + 1] = String.valueOf(AutoEditUtils.getNSpaces(i)) + '\t';
            ++i;
        }
        indentPrefixes[tabWidth + 1] = "";
        return indentPrefixes;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, false);
            }
        };
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(false){

            protected boolean isIncluded(Annotation annotation) {
                return ScriptSourceViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(true){

            protected boolean isIncluded(Annotation annotation) {
                return ScriptSourceViewerConfiguration.this.isShowInOverviewRuler(annotation);
            }
        };
    }
}

