/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ResourceProcessors {
    public static String[] computeAffectedNatures(IResource resource) throws CoreException {
        IProject project = resource.getProject();
        HashSet result = new HashSet();
        HashSet visitedProjects = new HashSet();
        ResourceProcessors.computeNatures(result, visitedProjects, project);
        return result.toArray(new String[result.size()]);
    }

    public static String[] computeAffectedNatures(IResource[] resources) throws CoreException {
        HashSet result = new HashSet();
        HashSet visitedProjects = new HashSet();
        int i = 0;
        while (i < resources.length) {
            ResourceProcessors.computeNatures(result, visitedProjects, resources[i].getProject());
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private static void computeNatures(Set result, Set visitedProjects, IProject focus) throws CoreException {
        if (visitedProjects.contains(focus)) {
            return;
        }
        String[] pns = focus.getDescription().getNatureIds();
        int p = 0;
        while (p < pns.length) {
            result.add(pns[p]);
            ++p;
        }
        visitedProjects.add(focus);
        IProject[] referencing = focus.getReferencingProjects();
        int i = 0;
        while (i < referencing.length) {
            ResourceProcessors.computeNatures(result, visitedProjects, referencing[i]);
            ++i;
        }
    }

    public static IPath handleToResourcePath(String project, String handle) {
        IPath path = Path.fromPortableString((String)handle);
        if (project != null && project.length() > 0 && !path.isAbsolute()) {
            return new Path(project).append(path).makeAbsolute();
        }
        return path;
    }

    public static String resourcePathToHandle(String project, IPath resourcePath) {
        if (project != null && project.length() > 0 && resourcePath.segmentCount() != 1 && resourcePath.segment(0).equals(project)) {
            return resourcePath.removeFirstSegments(1).toPortableString();
        }
        return resourcePath.toPortableString();
    }
}

