/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.code;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.core.manipulation.Messages;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.dltk.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class ScriptableRefactoring
extends Refactoring
implements IScriptableRefactoring,
ICommentProvider {
    private String fComment;

    public static RefactoringStatus createInputFatalStatus(Object element, String name, String id) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)id);
        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_inputs_do_not_exist, new String[]{name, id}));
    }

    public static RefactoringStatus createInputWarningStatus(Object element, String name, String id) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)id);
        if (element != null) {
            return RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_input_not_exists, new String[]{name, id}));
        }
        return RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_inputs_do_not_exist, new String[]{name, id}));
    }

    public boolean canEnableComment() {
        return true;
    }

    public final RefactoringStatus createInputFatalStatus(Object element, String id) {
        return ScriptableRefactoring.createInputFatalStatus(element, this.getName(), id);
    }

    public final RefactoringStatus createInputWarningStatus(Object element, String id) {
        return ScriptableRefactoring.createInputWarningStatus(element, this.getName(), id);
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }
}

