/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.editor;

import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.editor.BracketInserter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.koneki.ldt.core.LuaLanguageToolkit;
import org.eclipse.koneki.ldt.core.LuaUtils;
import org.eclipse.koneki.ldt.editor.Activator;
import org.eclipse.koneki.ldt.editor.LuaBracketInserter;
import org.eclipse.koneki.ldt.editor.internal.text.LuaASTFoldingStructureProvider;
import org.eclipse.koneki.ldt.editor.internal.text.LuaTextTools;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class LuaEditor
extends ScriptEditor {
    public static final String EDITOR_CONTEXT = "#LuaEditorContext";
    public static final String EDITOR_ID = "org.eclipse.koneki.ldt.editor";
    private IFoldingStructureProvider foldingStructureProvider = null;
    private BracketInserter bracketInserter = new LuaBracketInserter(this, this.getPreferenceStore());

    protected void connectPartitioningToElement(IEditorInput input, IDocument document) {
        IDocumentExtension3 extension;
        if (document instanceof IDocumentExtension3 && (extension = (IDocumentExtension3)document).getDocumentPartitioner("__lua_partitioning") == null) {
            LuaTextTools tools = Activator.getDefault().getTextTools();
            tools.setupDocumentPartitioner(document, "__lua_partitioning");
        }
    }

    public String getEditorId() {
        return EDITOR_ID;
    }

    protected IFoldingStructureProvider getFoldingStructureProvider() {
        if (this.foldingStructureProvider == null) {
            this.foldingStructureProvider = new LuaASTFoldingStructureProvider();
        }
        return this.foldingStructureProvider;
    }

    public IDLTKLanguageToolkit getLanguageToolkit() {
        return LuaLanguageToolkit.getDefault();
    }

    public IPreferenceStore getScriptPreferenceStore() {
        IPreferenceStore uiLanguageToolkitStore = super.getScriptPreferenceStore();
        IPreferenceStore dltkUIStore = DLTKUIPlugin.getDefault().getPreferenceStore();
        if (uiLanguageToolkitStore != null) {
            return new ChainedPreferenceStore(new IPreferenceStore[]{uiLanguageToolkitStore, dltkUIStore});
        }
        return dltkUIStore;
    }

    protected void doSelectionChanged(SelectionChangedEvent event) {
        if (this.getPreferenceStore().getBoolean("syncOutlineOnCursorMove")) {
            super.doSelectionChanged(event);
        }
    }

    public ScriptTextTools getTextTools() {
        return Activator.getDefault().getTextTools();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId(EDITOR_CONTEXT);
    }

    protected void setPartName(String partName) {
        String moduleFullName = null;
        IModelElement input = this.getInputModelElement();
        if (input instanceof ISourceModule) {
            moduleFullName = LuaUtils.getModuleFullName((ISourceModule)((ISourceModule)input));
        }
        if (moduleFullName != null) {
            super.setPartName(moduleFullName);
        } else {
            super.setPartName(partName);
        }
    }

    protected ICharacterPairMatcher createBracketMatcher() {
        return new DefaultCharacterPairMatcher("()[]{}".toCharArray(), "__lua_partitioning");
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.bracketInserter);
        }
    }
}

