/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.editor.formatter;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.formatter.AbstractScriptFormatterFactory;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialogOwner;
import org.eclipse.dltk.ui.formatter.IScriptFormatter;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.koneki.ldt.editor.Activator;
import org.eclipse.koneki.ldt.editor.formatter.LuaFormatter;
import org.eclipse.koneki.ldt.editor.formatter.Messages;
import org.eclipse.koneki.ldt.editor.formatter.ui.LuaFormatterModifyDialog;

public class LuaFormatterFactory
extends AbstractScriptFormatterFactory {
    private static final String SAMPLE_FILE_PATH = "/sample/formatter.lua";
    private final String[] preferenceKeys = new String[]{"formatter.indentation.size", "formatter.tabulation.char", "formatter.tabulation.size"};

    public PreferenceKey[] getPreferenceKeys() {
        PreferenceKey[] preferences = new PreferenceKey[this.preferenceKeys.length];
        int p = 0;
        while (p < preferences.length) {
            preferences[p] = new PreferenceKey("org.eclipse.koneki.ldt.editor", this.preferenceKeys[p]);
            ++p;
        }
        return preferences;
    }

    protected PreferenceKey getProfilesKey() {
        return new PreferenceKey("org.eclipse.koneki.ldt.editor", "formatter.profiles");
    }

    public PreferenceKey getActiveProfileKey() {
        return new PreferenceKey("org.eclipse.koneki.ldt.editor", "formatter.profiles.active");
    }

    public IScriptFormatter createFormatter(String lineDelimiter, Map<String, String> preferences) {
        return new LuaFormatter(lineDelimiter, preferences);
    }

    public IFormatterModifyDialog createDialog(IFormatterModifyDialogOwner dialogOwner) {
        return new LuaFormatterModifyDialog(dialogOwner, (IScriptFormatterFactory)this);
    }

    public URL getPreviewContent() {
        return LuaFormatterFactory.getPreviewSample();
    }

    public static URL getPreviewSample() {
        URL sample = Platform.getBundle((String)"org.eclipse.koneki.ldt.editor").getEntry(SAMPLE_FILE_PATH);
        try {
            return FileLocator.toFileURL((URL)sample);
        }
        catch (IOException e) {
            Activator.logError(Messages.LuaFormatterFactoryPreviewNotFound, e);
            return sample;
        }
    }
}

