/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TagBits;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public class MethodVerifier
implements TagBits,
TypeConstants {
    SourceTypeBinding type = null;
    HashtableOfObject inheritedMethods = null;
    HashtableOfObject currentMethods = null;
    ReferenceBinding runtimeException = null;
    ReferenceBinding errorException = null;
    LookupEnvironment environment;

    MethodVerifier(LookupEnvironment environment) {
        this.environment = environment;
    }

    boolean areMethodsEqual(MethodBinding one, MethodBinding two) {
        return this.doesMethodOverride(one, two) && this.areReturnTypesEqual(one, two);
    }

    boolean areParametersEqual(MethodBinding one, MethodBinding two) {
        TypeBinding[] oneArgs = one.parameters;
        TypeBinding[] twoArgs = two.parameters;
        if (oneArgs == twoArgs) {
            return true;
        }
        int length = oneArgs.length;
        if (length != twoArgs.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!this.areTypesEqual(oneArgs[i], twoArgs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean areReturnTypesEqual(MethodBinding one, MethodBinding two) {
        return this.areTypesEqual(one.returnType, two.returnType);
    }

    boolean areTypesEqual(TypeBinding one, TypeBinding two) {
        if (one == two) {
            return true;
        }
        if (one instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)one).resolvedType == two;
        }
        if (two instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)two).resolvedType == one;
        }
        return false;
    }

    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && this.type.superclass().isAbstract()) {
            return false;
        }
        return this.type.superInterfaces() == NoSuperInterfaces;
    }

    boolean canSkipInheritedMethods(MethodBinding one, MethodBinding two) {
        return two == null || one.declaringClass == two.declaringClass;
    }

    void checkAbstractMethod(MethodBinding abstractMethod) {
        if (this.mustImplementAbstractMethod(abstractMethod.declaringClass)) {
            TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
            if (typeDeclaration != null) {
                MethodDeclaration missingAbstractMethod = typeDeclaration.addMissingAbstractMethodFor(abstractMethod);
                missingAbstractMethod.scope.problemReporter().abstractMethodMustBeImplemented(this.type, abstractMethod);
            } else {
                this.problemReporter().abstractMethodMustBeImplemented(this.type, abstractMethod);
            }
        }
    }

    void checkAgainstInheritedMethods(MethodBinding currentMethod, MethodBinding[] methods, int length, MethodBinding[] allInheritedMethods) {
        if (this.type.isAnnotationType()) {
            this.problemReporter().annotationCannotOverrideMethod(currentMethod, methods[length - 1]);
            return;
        }
        CompilerOptions options = this.type.scope.compilerOptions();
        int i = length;
        block0: while (--i >= 0) {
            MethodBinding inheritedMethod = methods[i];
            if (currentMethod.isStatic() != inheritedMethod.isStatic()) {
                this.problemReporter(currentMethod).staticAndInstanceConflict(currentMethod, inheritedMethod);
                continue;
            }
            currentMethod.modifiers = inheritedMethod.isAbstract() ? (inheritedMethod.declaringClass.isInterface() ? (currentMethod.modifiers |= 0x20000000) : (currentMethod.modifiers |= 0x30000000)) : (currentMethod.modifiers |= 0x10000000);
            if (!this.areReturnTypesEqual(currentMethod, inheritedMethod)) {
                this.problemReporter(currentMethod).incompatibleReturnType(currentMethod, inheritedMethod);
                continue;
            }
            if (currentMethod.thrownExceptions != NoExceptions) {
                this.checkExceptions(currentMethod, inheritedMethod);
            }
            if (inheritedMethod.isFinal()) {
                this.problemReporter(currentMethod).finalMethodCannotBeOverridden(currentMethod, inheritedMethod);
            }
            if (!this.isAsVisible(currentMethod, inheritedMethod)) {
                this.problemReporter(currentMethod).visibilityConflict(currentMethod, inheritedMethod);
            }
            if (options.reportDeprecationWhenOverridingDeprecatedMethod && inheritedMethod.isViewedAsDeprecated() && (!currentMethod.isViewedAsDeprecated() || options.reportDeprecationInsideDeprecatedCode)) {
                ReferenceBinding declaringClass = inheritedMethod.declaringClass;
                if (declaringClass.isInterface()) {
                    int j = length;
                    while (--j >= 0) {
                        if (i != j && methods[j].declaringClass.implementsInterface(declaringClass, false)) continue block0;
                    }
                }
                this.problemReporter(currentMethod).overridesDeprecatedMethod(currentMethod, inheritedMethod);
            }
            this.checkForBridgeMethod(currentMethod, inheritedMethod, allInheritedMethods);
        }
    }

    void checkConcreteInheritedMethod(MethodBinding concreteMethod, MethodBinding[] abstractMethods) {
        if (concreteMethod.isStatic()) {
            this.problemReporter().staticInheritedMethodConflicts(this.type, concreteMethod, abstractMethods);
        }
        if (!concreteMethod.isPublic()) {
            this.problemReporter().inheritedMethodReducesVisibility(this.type, concreteMethod, abstractMethods);
        }
        if (concreteMethod.thrownExceptions != NoExceptions) {
            int i = abstractMethods.length;
            while (--i >= 0) {
                this.checkExceptions(concreteMethod, abstractMethods[i]);
            }
        }
    }

    void checkExceptions(MethodBinding newMethod, MethodBinding inheritedMethod) {
        ReferenceBinding[] newExceptions = this.resolvedExceptionTypesFor(newMethod);
        ReferenceBinding[] inheritedExceptions = this.resolvedExceptionTypesFor(inheritedMethod);
        int i = newExceptions.length;
        while (--i >= 0) {
            ReferenceBinding newException = newExceptions[i];
            int j = inheritedExceptions.length;
            while (--j > -1 && !this.isSameClassOrSubclassOf(newException, inheritedExceptions[j])) {
            }
            if (j != -1 || newException.isUncheckedException(false)) continue;
            this.problemReporter(newMethod).incompatibleExceptionInThrowsClause(this.type, newMethod, inheritedMethod, newException);
        }
    }

    void checkForBridgeMethod(MethodBinding currentMethod, MethodBinding inheritedMethod, MethodBinding[] allInheritedMethods) {
    }

    void checkInheritedMethods(MethodBinding[] methods, int length) {
        int i;
        MethodBinding first = methods[0];
        int index = length;
        while (--index > 0 && this.areReturnTypesEqual(first, methods[index])) {
        }
        if (index > 0) {
            if (this.type.isInterface()) {
                int i2 = length;
                while (--i2 >= 0) {
                    if (methods[i2].declaringClass.id != 1) continue;
                    return;
                }
            }
            this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, methods, length);
            return;
        }
        MethodBinding concreteMethod = null;
        if (!this.type.isInterface()) {
            i = length;
            while (--i >= 0) {
                if (methods[i].isAbstract()) continue;
                concreteMethod = methods[i];
                break;
            }
        }
        if (concreteMethod == null) {
            if (!this.type.isAbstract()) {
                i = length;
                while (--i >= 0) {
                    if (!this.mustImplementAbstractMethod(methods[i].declaringClass)) continue;
                    TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
                    if (typeDeclaration != null) {
                        MethodDeclaration missingAbstractMethod = typeDeclaration.addMissingAbstractMethodFor(methods[0]);
                        missingAbstractMethod.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methods[0]);
                    } else {
                        this.problemReporter().abstractMethodMustBeImplemented(this.type, methods[0]);
                    }
                    return;
                }
            }
            return;
        }
        MethodBinding[] abstractMethods = new MethodBinding[length - 1];
        index = 0;
        int i3 = length;
        while (--i3 >= 0) {
            if (methods[i3] == concreteMethod) continue;
            abstractMethods[index++] = methods[i3];
        }
        this.checkConcreteInheritedMethod(concreteMethod, abstractMethods);
    }

    void checkMethods() {
        boolean mustImplementAbstractMethods = this.mustImplementAbstractMethods();
        boolean skipInheritedMethods = mustImplementAbstractMethods && this.canSkipInheritedMethods();
        char[][] methodSelectors = this.inheritedMethods.keyTable;
        int s = methodSelectors.length;
        while (--s >= 0) {
            int j;
            int i;
            MethodBinding[] current;
            if (methodSelectors[s] == null || (current = (MethodBinding[])this.currentMethods.get(methodSelectors[s])) == null && skipInheritedMethods) continue;
            MethodBinding[] inherited = (MethodBinding[])this.inheritedMethods.valueTable[s];
            if (inherited.length == 1 && current == null) {
                if (!mustImplementAbstractMethods || !inherited[0].isAbstract()) continue;
                this.checkAbstractMethod(inherited[0]);
                continue;
            }
            int index = -1;
            MethodBinding[] matchingInherited = new MethodBinding[inherited.length];
            if (current != null) {
                i = 0;
                int length1 = current.length;
                while (i < length1) {
                    MethodBinding currentMethod = current[i];
                    j = 0;
                    int length2 = inherited.length;
                    while (j < length2) {
                        MethodBinding inheritedMethod = this.computeSubstituteMethod(inherited[j], currentMethod);
                        if (inheritedMethod != null && this.doesMethodOverride(currentMethod, inheritedMethod)) {
                            matchingInherited[++index] = inheritedMethod;
                            inherited[j] = null;
                        }
                        ++j;
                    }
                    if (index >= 0) {
                        this.checkAgainstInheritedMethods(currentMethod, matchingInherited, index + 1, inherited);
                        while (index >= 0) {
                            matchingInherited[index--] = null;
                        }
                    }
                    ++i;
                }
            }
            i = 0;
            int length = inherited.length;
            while (i < length) {
                MethodBinding inheritedMethod = inherited[i];
                if (inheritedMethod != null) {
                    matchingInherited[++index] = inheritedMethod;
                    j = i + 1;
                    while (j < length) {
                        MethodBinding otherInheritedMethod = inherited[j];
                        if (!this.canSkipInheritedMethods(inheritedMethod, otherInheritedMethod) && (otherInheritedMethod = this.computeSubstituteMethod(otherInheritedMethod, inheritedMethod)) != null && this.doesMethodOverride(inheritedMethod, otherInheritedMethod)) {
                            matchingInherited[++index] = otherInheritedMethod;
                            inherited[j] = null;
                        }
                        ++j;
                    }
                    if (index != -1) {
                        if (index > 0) {
                            this.checkInheritedMethods(matchingInherited, index + 1);
                        } else if (mustImplementAbstractMethods && matchingInherited[0].isAbstract()) {
                            this.checkAbstractMethod(matchingInherited[0]);
                        }
                        while (index >= 0) {
                            matchingInherited[index--] = null;
                        }
                    }
                }
                ++i;
            }
        }
    }

    void checkPackagePrivateAbstractMethod(MethodBinding abstractMethod) {
        PackageBinding necessaryPackage = abstractMethod.declaringClass.fPackage;
        if (necessaryPackage == this.type.fPackage) {
            return;
        }
        ReferenceBinding superType = this.type.superclass();
        char[] selector = abstractMethod.selector;
        do {
            if (!superType.isValidBinding()) {
                return;
            }
            if (!superType.isAbstract()) {
                return;
            }
            if (necessaryPackage != superType.fPackage) continue;
            MethodBinding[] methods = superType.getMethods(selector);
            int m = methods.length;
            while (--m >= 0) {
                MethodBinding method = methods[m];
                if (method.isPrivate() || method.isConstructor() || method.isDefaultAbstract() || !this.areMethodsEqual(method, abstractMethod)) continue;
                return;
            }
        } while ((superType = superType.superclass()) != abstractMethod.declaringClass);
        this.problemReporter().abstractMethodCannotBeOverridden(this.type, abstractMethod);
    }

    void computeInheritedMethods() {
        ReferenceBinding superclass = this.type.isInterface() ? this.type.scope.getJavaLangObject() : this.type.superclass();
        this.computeInheritedMethods(superclass, this.type.superInterfaces());
    }

    void computeInheritedMethods(ReferenceBinding superclass, ReferenceBinding[] superInterfaces) {
        this.inheritedMethods = new HashtableOfObject(51);
        ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[3][];
        int lastPosition = -1;
        ReferenceBinding[] itsInterfaces = superInterfaces;
        if (itsInterfaces != NoSuperInterfaces) {
            interfacesToVisit[++lastPosition] = itsInterfaces;
        }
        ReferenceBinding superType = superclass;
        HashtableOfObject nonVisibleDefaultMethods = new HashtableOfObject(3);
        boolean allSuperclassesAreAbstract = true;
        while (superType != null && superType.isValidBinding()) {
            if (allSuperclassesAreAbstract) {
                if (superType.isAbstract()) {
                    itsInterfaces = superType.superInterfaces();
                    if (itsInterfaces != NoSuperInterfaces) {
                        if (++lastPosition == interfacesToVisit.length) {
                            ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                            interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                            System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                        }
                        interfacesToVisit[lastPosition] = itsInterfaces;
                    }
                } else {
                    allSuperclassesAreAbstract = false;
                }
            }
            MethodBinding[] methods = superType.unResolvedMethods();
            int m = methods.length;
            block1: while (--m >= 0) {
                MethodBinding[] current;
                MethodBinding[] nonVisible;
                int length;
                MethodBinding inheritedMethod = methods[m];
                if (inheritedMethod.isPrivate() || inheritedMethod.isConstructor() || inheritedMethod.isDefaultAbstract()) continue;
                MethodBinding[] existingMethods = (MethodBinding[])this.inheritedMethods.get(inheritedMethod.selector);
                if (existingMethods != null) {
                    int i = 0;
                    length = existingMethods.length;
                    while (i < length) {
                        if (existingMethods[i].declaringClass != inheritedMethod.declaringClass && this.areMethodsEqual(existingMethods[i], inheritedMethod)) {
                            if (!inheritedMethod.isDefault() || !inheritedMethod.isAbstract()) continue block1;
                            this.checkPackagePrivateAbstractMethod(inheritedMethod);
                            continue block1;
                        }
                        ++i;
                    }
                }
                if ((nonVisible = (MethodBinding[])nonVisibleDefaultMethods.get(inheritedMethod.selector)) != null) {
                    int i = 0;
                    int l = nonVisible.length;
                    while (i < l) {
                        if (this.areMethodsEqual(nonVisible[i], inheritedMethod)) continue block1;
                        ++i;
                    }
                }
                if (!inheritedMethod.isDefault() || inheritedMethod.declaringClass.fPackage == this.type.fPackage) {
                    if (existingMethods == null) {
                        existingMethods = new MethodBinding[]{inheritedMethod};
                    } else {
                        length = existingMethods.length;
                        MethodBinding[] methodBindingArray = existingMethods;
                        existingMethods = new MethodBinding[length + 1];
                        System.arraycopy(methodBindingArray, 0, existingMethods, 0, length);
                        existingMethods[length] = inheritedMethod;
                    }
                    this.inheritedMethods.put(inheritedMethod.selector, existingMethods);
                    continue;
                }
                if (nonVisible == null) {
                    nonVisible = new MethodBinding[]{inheritedMethod};
                } else {
                    length = nonVisible.length;
                    MethodBinding[] methodBindingArray = nonVisible;
                    nonVisible = new MethodBinding[length + 1];
                    System.arraycopy(methodBindingArray, 0, nonVisible, 0, length);
                    nonVisible[length] = inheritedMethod;
                }
                nonVisibleDefaultMethods.put(inheritedMethod.selector, nonVisible);
                if (inheritedMethod.isAbstract() && !this.type.isAbstract()) {
                    this.problemReporter().abstractMethodCannotBeOverridden(this.type, inheritedMethod);
                }
                if ((current = (MethodBinding[])this.currentMethods.get(inheritedMethod.selector)) == null) continue;
                int i = 0;
                int length2 = current.length;
                while (i < length2) {
                    if (this.areMethodsEqual(current[i], inheritedMethod)) {
                        this.problemReporter().overridesPackageDefaultMethod(current[i], inheritedMethod);
                        continue block1;
                    }
                    ++i;
                }
            }
            superType = superType.superclass();
        }
        int i = 0;
        while (i <= lastPosition) {
            ReferenceBinding[] interfaces = interfacesToVisit[i];
            int j = 0;
            int l = interfaces.length;
            while (j < l) {
                superType = interfaces[j];
                if ((superType.tagBits & 0x800L) == 0L) {
                    superType.tagBits |= 0x800L;
                    if (superType.isValidBinding()) {
                        itsInterfaces = superType.superInterfaces();
                        if (itsInterfaces != NoSuperInterfaces) {
                            if (++lastPosition == interfacesToVisit.length) {
                                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                            }
                            interfacesToVisit[lastPosition] = itsInterfaces;
                        }
                        MethodBinding[] methods = superType.unResolvedMethods();
                        int m = methods.length;
                        block7: while (--m >= 0) {
                            MethodBinding inheritedMethod = methods[m];
                            MethodBinding[] existingMethods = (MethodBinding[])this.inheritedMethods.get(inheritedMethod.selector);
                            if (existingMethods == null) {
                                existingMethods = new MethodBinding[]{inheritedMethod};
                            } else {
                                int length = existingMethods.length;
                                int e = 0;
                                while (e < length) {
                                    if (this.isInterfaceMethodImplemented(inheritedMethod, existingMethods[e], superType)) continue block7;
                                    ++e;
                                }
                                MethodBinding[] methodBindingArray = existingMethods;
                                existingMethods = new MethodBinding[length + 1];
                                System.arraycopy(methodBindingArray, 0, existingMethods, 0, length);
                                existingMethods[length] = inheritedMethod;
                            }
                            this.inheritedMethods.put(inheritedMethod.selector, existingMethods);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i <= lastPosition) {
            ReferenceBinding[] interfaces = interfacesToVisit[i];
            int j = 0;
            int length = interfaces.length;
            while (j < length) {
                interfaces[j].tagBits &= 0xFFFFFFFFFFFFF7FFL;
                ++j;
            }
            ++i;
        }
    }

    void computeMethods() {
        MethodBinding[] methods = this.type.methods();
        int size = methods.length;
        this.currentMethods = new HashtableOfObject(size == 0 ? 1 : size);
        int m = size;
        while (--m >= 0) {
            MethodBinding method = methods[m];
            if (method.isConstructor() || method.isDefaultAbstract()) continue;
            MethodBinding[] existingMethods = (MethodBinding[])this.currentMethods.get(method.selector);
            if (existingMethods == null) {
                existingMethods = new MethodBinding[1];
            } else {
                MethodBinding[] methodBindingArray = existingMethods;
                existingMethods = new MethodBinding[existingMethods.length + 1];
                System.arraycopy(methodBindingArray, 0, existingMethods, 0, existingMethods.length - 1);
            }
            existingMethods[existingMethods.length - 1] = method;
            this.currentMethods.put(method.selector, existingMethods);
        }
    }

    MethodBinding computeSubstituteMethod(MethodBinding inheritedMethod, MethodBinding currentMethod) {
        if (inheritedMethod == null) {
            return null;
        }
        if (currentMethod.parameters.length != inheritedMethod.parameters.length) {
            return null;
        }
        return inheritedMethod;
    }

    public boolean doesMethodOverride(MethodBinding method, MethodBinding inheritedMethod) {
        return this.areParametersEqual(method, inheritedMethod);
    }

    boolean isAsVisible(MethodBinding newMethod, MethodBinding inheritedMethod) {
        if (inheritedMethod.modifiers == newMethod.modifiers) {
            return true;
        }
        if (newMethod.isPublic()) {
            return true;
        }
        if (inheritedMethod.isPublic()) {
            return false;
        }
        if (newMethod.isProtected()) {
            return true;
        }
        if (inheritedMethod.isProtected()) {
            return false;
        }
        return !newMethod.isPrivate();
    }

    boolean isInterfaceMethodImplemented(MethodBinding inheritedMethod, MethodBinding existingMethod, ReferenceBinding superType) {
        return this.areParametersEqual(existingMethod, inheritedMethod) && existingMethod.declaringClass.implementsInterface(superType, true);
    }

    boolean isSameClassOrSubclassOf(ReferenceBinding testClass, ReferenceBinding superclass) {
        do {
            if (testClass != superclass) continue;
            return true;
        } while ((testClass = testClass.superclass()) != null);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    boolean mustImplementAbstractMethod(ReferenceBinding declaringClass) {
        block4: {
            block3: {
                superclass = this.type.superclass();
                if (!declaringClass.isClass()) break block3;
                while (superclass.isAbstract() && superclass != declaringClass) {
                    superclass = superclass.superclass();
                }
                break block4;
            }
            if (!this.type.implementsInterface(declaringClass, false)) ** GOTO lbl14
            if (this.type.isAbstract()) {
                return false;
            }
            if (superclass.implementsInterface(declaringClass, true)) ** GOTO lbl14
            return true;
lbl-1000:
            // 1 sources

            {
                superclass = superclass.superclass();
lbl14:
                // 3 sources

                ** while (superclass.isAbstract() && !superclass.implementsInterface((ReferenceBinding)declaringClass, (boolean)false))
            }
        }
        return superclass.isAbstract();
    }

    boolean mustImplementAbstractMethods() {
        return !this.type.isInterface() && !this.type.isAbstract();
    }

    ProblemReporter problemReporter() {
        return this.type.scope.problemReporter();
    }

    ProblemReporter problemReporter(MethodBinding currentMethod) {
        ProblemReporter reporter = this.problemReporter();
        if (currentMethod.declaringClass == this.type && currentMethod.sourceMethod() != null) {
            reporter.referenceContext = currentMethod.sourceMethod();
        }
        return reporter;
    }

    ReferenceBinding[] resolvedExceptionTypesFor(MethodBinding method) {
        ReferenceBinding[] exceptions = method.thrownExceptions;
        if ((method.modifiers & 0x2000000) == 0) {
            return exceptions;
        }
        if (!(method.declaringClass instanceof BinaryTypeBinding)) {
            return TypeConstants.NoExceptions;
        }
        int i = exceptions.length;
        while (--i >= 0) {
            exceptions[i] = BinaryTypeBinding.resolveType(exceptions[i], this.environment, true);
        }
        return exceptions;
    }

    void verify(SourceTypeBinding someType) {
        this.type = someType;
        this.computeMethods();
        this.computeInheritedMethods();
        this.checkMethods();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append("MethodVerifier for type: ");
        buffer.append(this.type.readableName());
        buffer.append('\n');
        buffer.append("\t-inherited methods: ");
        buffer.append(this.inheritedMethods);
        return buffer.toString();
    }
}

