/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.debug.core.model.IScriptBreakpointPathMapperExtension;
import org.eclipse.koneki.ldt.core.LuaUtils;
import org.eclipse.koneki.ldt.debug.core.Activator;
import org.eclipse.koneki.ldt.debug.core.LuaModuleURIUtil;

public class LuaModuleURIBreakpointPathMapper
implements IScriptBreakpointPathMapperExtension {
    private HashMap<URI, URI> cache;
    private IScriptProject scriptProject;

    public LuaModuleURIBreakpointPathMapper(IScriptProject project) {
        this.scriptProject = project;
        this.cache = new HashMap();
    }

    public void clearCache() {
        this.cache.clear();
    }

    public URI map(URI uri) {
        if (this.cache.containsKey(uri)) {
            return this.cache.get(uri);
        }
        URI result = uri;
        ISourceModule module = LuaUtils.getSourceModuleFromAbsoluteURI((URI)uri, (IScriptProject)this.scriptProject);
        if (module != null) {
            try {
                result = LuaModuleURIUtil.getModuleURI(module);
            }
            catch (URISyntaxException e) {
                Activator.logWarning("Unable to get the Module URI for file :" + uri, e);
            }
        }
        this.cache.put(uri, result);
        return result;
    }
}

