/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.navigator;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgMoveStarter;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ScriptCopyProcessor;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ScriptMoveProcessor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class ScriptDropAssistant
extends CommonDropAdapterAssistant {
    private List fElements;
    private ScriptMoveProcessor fMoveProcessor;
    private int fCanMoveElements;
    private ScriptCopyProcessor fCopyProcessor;
    private int fCanCopyElements;

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(dropAdapter.getCurrentTransfer())) {
            try {
                switch (dropAdapter.getCurrentOperation()) {
                    case 2: {
                        this.handleDropMove(target);
                        break;
                    }
                    case 1: {
                        this.handleDropCopy(target);
                    }
                }
            }
            catch (ModelException modelException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            this.clear();
            return Status.OK_STATUS;
        }
        if (FileTransfer.getInstance().isSupportedType(dropAdapter.getCurrentTransfer())) {
            try {
                Object data = FileTransfer.getInstance().nativeToJava(dropAdapter.getCurrentTransfer());
                if (!(data instanceof String[])) {
                    return Status.CANCEL_STATUS;
                }
                IContainer targetContainer = this.getActualTarget(target);
                if (targetContainer == null) {
                    return Status.CANCEL_STATUS;
                }
                this.getShell().forceActive();
                new CopyFilesAndFoldersOperation(this.getShell()).copyFiles((String[])data, targetContainer);
            }
            catch (ModelException modelException) {}
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        IStatus result = Status.OK_STATUS;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            this.initializeSelection();
            try {
                switch (operation) {
                    case 16: {
                        if (this.handleValidateDefault(target) != 0) {
                            result = Status.OK_STATUS;
                            break;
                        }
                        result = Status.CANCEL_STATUS;
                        break;
                    }
                    case 1: {
                        if (this.handleValidateCopy(target) != 0) {
                            result = Status.OK_STATUS;
                            break;
                        }
                        result = Status.CANCEL_STATUS;
                        break;
                    }
                    case 2: {
                        if (this.handleValidateMove(target) != 0) {
                            result = Status.OK_STATUS;
                            break;
                        }
                        result = Status.CANCEL_STATUS;
                    }
                }
            }
            catch (ModelException modelException) {
                result = Status.CANCEL_STATUS;
            }
        }
        return result;
    }

    public boolean isSupportedType(TransferData transferType) {
        return super.isSupportedType(transferType) || FileTransfer.getInstance().isSupportedType(transferType);
    }

    private IContainer getActualTarget(Object dropTarget) throws ModelException {
        if (dropTarget instanceof IContainer) {
            return (IContainer)dropTarget;
        }
        if (dropTarget instanceof IModelElement) {
            return this.getActualTarget(((IModelElement)dropTarget).getCorrespondingResource());
        }
        return null;
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection s = LocalSelectionTransfer.getTransfer().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        this.fElements = ((IStructuredSelection)s).toList();
    }

    private void handleDropMove(Object target) throws ModelException, InvocationTargetException, InterruptedException {
        IModelElement[] javaElements = ReorgUtils.getModelElements(this.fElements);
        IResource[] resources = ReorgUtils.getResources(this.fElements);
        ReorgMoveStarter starter = null;
        if (target instanceof IResource) {
            starter = ReorgMoveStarter.create(javaElements, resources, (IResource)target);
        } else if (target instanceof IModelElement) {
            starter = ReorgMoveStarter.create(javaElements, resources, (IModelElement)target);
        }
        if (starter != null) {
            starter.run(this.getShell());
        }
    }

    private void handleDropCopy(Object target) throws ModelException, InvocationTargetException, InterruptedException {
        IModelElement[] javaElements = ReorgUtils.getModelElements(this.fElements);
        IResource[] resources = ReorgUtils.getResources(this.fElements);
        ReorgCopyStarter starter = null;
        if (target instanceof IResource) {
            starter = ReorgCopyStarter.create(javaElements, resources, (IResource)target);
        } else if (target instanceof IModelElement) {
            starter = ReorgCopyStarter.create(javaElements, resources, (IModelElement)target);
        }
        if (starter != null) {
            starter.run(this.getShell());
        }
    }

    private int handleValidateCopy(Object target) throws ModelException {
        IReorgPolicy.ICopyPolicy policy = ReorgPolicyFactory.createCopyPolicy(ReorgUtils.getResources(this.fElements), ReorgUtils.getModelElements(this.fElements));
        ScriptCopyProcessor scriptCopyProcessor = this.fCopyProcessor = policy.canEnable() ? new ScriptCopyProcessor(policy) : null;
        if (!this.canCopyElements()) {
            return 0;
        }
        if (target instanceof IResource && this.fCopyProcessor != null && this.fCopyProcessor.setDestination((IResource)target).isOK()) {
            return 1;
        }
        if (target instanceof IModelElement && this.fCopyProcessor != null && this.fCopyProcessor.setDestination((IModelElement)target).isOK()) {
            return 1;
        }
        return 0;
    }

    private int handleValidateDefault(Object target) throws ModelException {
        if (target == null) {
            return 0;
        }
        return this.handleValidateMove(target);
    }

    private int handleValidateMove(Object target) throws ModelException {
        if (target == null) {
            return 0;
        }
        IReorgPolicy.IMovePolicy policy = ReorgPolicyFactory.createMovePolicy(ReorgUtils.getResources(this.fElements), ReorgUtils.getModelElements(this.fElements));
        ScriptMoveProcessor scriptMoveProcessor = this.fMoveProcessor = policy.canEnable() ? new ScriptMoveProcessor(policy) : null;
        if (!this.canMoveElements()) {
            return 0;
        }
        if (target instanceof IResource && this.fMoveProcessor != null && this.fMoveProcessor.setDestination((IResource)target).isOK()) {
            return 2;
        }
        if (target instanceof IModelElement && this.fMoveProcessor != null && this.fMoveProcessor.setDestination((IModelElement)target).isOK()) {
            return 2;
        }
        return 0;
    }

    private boolean canMoveElements() {
        if (this.fCanMoveElements == 0) {
            this.fCanMoveElements = 2;
            if (this.fMoveProcessor == null) {
                this.fCanMoveElements = 1;
            }
        }
        return this.fCanMoveElements == 2;
    }

    private boolean canCopyElements() {
        if (this.fCanCopyElements == 0) {
            this.fCanCopyElements = 2;
            if (this.fCopyProcessor == null) {
                this.fCanCopyElements = 1;
            }
        }
        return this.fCanCopyElements == 2;
    }

    private void clear() {
        this.fElements = null;
        this.fMoveProcessor = null;
        this.fCanMoveElements = 0;
        this.fCopyProcessor = null;
        this.fCanCopyElements = 0;
    }
}

