/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.editor;

import org.eclipse.dltk.internal.ui.editor.BracketInserter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;

public class LuaBracketInserter
extends BracketInserter {
    private IPreferenceStore preferences;

    protected LuaBracketInserter(ScriptEditor editor, IPreferenceStore preferenceStore) {
        super(editor);
        this.preferences = preferenceStore;
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit || this.editor.getInsertMode() != ScriptEditor.SMART_INSERT) {
            return;
        }
        switch (event.character) {
            case '(': {
                if (this.isClosingBrackets()) break;
                return;
            }
            case '[': {
                if (this.isClosingBrackets()) break;
                return;
            }
            case '{': {
                if (this.isClosingBraces()) break;
                return;
            }
            case '\'': {
                if (this.isClosingStrings()) break;
                return;
            }
            case '\"': {
                if (this.isClosingStrings()) break;
                return;
            }
            default: {
                return;
            }
        }
        if (!this.editor.validateEditorInputState()) {
            return;
        }
        ISourceViewer sourceViewer = this.editor.getScriptSourceViewer();
        IDocument document = sourceViewer.getDocument();
        Point selection = sourceViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        try {
            if (!LuaBracketInserter.validatePartitioning((IDocument)document, (int)offset, (String)"__lua_partitioning", (String[])new String[0])) {
                return;
            }
            this.insertBrackets(document, offset, length, event.character, LuaBracketInserter.getPeerCharacter((char)event.character));
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            return;
        }
        event.doit = false;
    }

    private IPreferenceStore getPreferenceStore() {
        return this.preferences;
    }

    private boolean isClosingBrackets() {
        return this.getPreferenceStore().getBoolean("closeBrackets");
    }

    private boolean isClosingStrings() {
        return this.getPreferenceStore().getBoolean("closeStrings");
    }

    private boolean isClosingBraces() {
        return this.getPreferenceStore().getBoolean("closeBraces");
    }
}

