/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.breakpoints.IDbgpBreakpoint;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationEngine;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.internal.debug.core.model.IScriptStreamProxy;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;
import org.eclipse.koneki.ldt.debug.core.LuaCoroutineDbgpSession;
import org.eclipse.koneki.ldt.debug.core.LuaCoroutineStack;
import org.eclipse.koneki.ldt.debug.core.LuaDebugTarget;

public class LuaCoroutine
extends ScriptThread {
    private LuaDebugTarget debugTarget;
    private String coroutineId;
    private String name;
    private LuaCoroutineStack stack;

    public LuaCoroutine(LuaDebugTarget debugTarget, String id, String name) throws DbgpException, CoreException {
        super((IScriptDebugTarget)debugTarget, (IDbgpSession)new LuaCoroutineDbgpSession(debugTarget.getMainThread().getDbgpSession(), null), null);
        this.debugTarget = debugTarget;
        this.coroutineId = id;
        this.name = name;
        ((LuaCoroutineDbgpSession)super.getDbgpSession()).bindToCoroutine(this);
        this.stack = new LuaCoroutineStack(this);
    }

    public String getCoroutineId() {
        return this.coroutineId;
    }

    protected void coroNotSupported() throws DebugException {
        this.makeNotSupported("Not supported for a coroutine", null);
    }

    public boolean hasStackFrames() {
        return this.stack.hasFrames();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        return this.stack.getFrames();
    }

    public void updateStackFrames() {
        this.stack.updateFrames();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public IBreakpoint[] getBreakpoints() {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
    }

    public IDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    public boolean canResume() {
        return false;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        IScriptThread mainThread = this.debugTarget.getMainThread();
        return mainThread == null || mainThread.isSuspended();
    }

    public void resume() throws DebugException {
        this.coroNotSupported();
    }

    public void suspend() throws DebugException {
        this.coroNotSupported();
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto() throws DebugException {
        this.coroNotSupported();
    }

    public void stepOver() throws DebugException {
        this.coroNotSupported();
    }

    public void stepReturn() throws DebugException {
        this.coroNotSupported();
    }

    public boolean canTerminate() {
        IScriptThread mainThread = this.debugTarget.getMainThread();
        return mainThread != null && mainThread.canTerminate();
    }

    public boolean isTerminated() {
        IScriptThread mainThread = this.debugTarget.getMainThread();
        return mainThread == null || mainThread.isTerminated();
    }

    public void terminate() throws DebugException {
        IScriptThread mainThread = this.debugTarget.getMainThread();
        if (mainThread != null) {
            mainThread.terminate();
        }
    }

    public IDbgpBreakpoint getDbgpBreakpoint(String id) {
        IScriptThread mainThread = this.debugTarget.getMainThread();
        return mainThread == null ? null : mainThread.getDbgpBreakpoint(id);
    }

    public IScriptStreamProxy getStreamProxy() {
        IScriptThread mainThread = this.debugTarget.getMainThread();
        return mainThread == null ? null : mainThread.getStreamProxy();
    }

    public IScriptEvaluationEngine getEvaluationEngine() {
        IScriptThread mainThread = this.debugTarget.getMainThread();
        return mainThread == null ? null : mainThread.getEvaluationEngine();
    }

    public int getModificationsCount() {
        return 0;
    }

    public void sendTerminationRequest() throws DebugException {
        IScriptThread mainThread = this.debugTarget.getMainThread();
        if (mainThread != null) {
            this.debugTarget.getMainThread().sendTerminationRequest();
        }
    }

    public void initialize(IProgressMonitor monitor) throws DbgpException {
    }

    public void objectTerminated(Object object, Exception e) {
    }

    public void handleTermination(DbgpException e) {
    }

    public void handleResume(int detail) {
    }

    public void handleSuspend(int detail) {
    }
}

