/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.module;

import com.naef.jnlua.LuaState;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.koneki.ldt.parser.Activator;

public abstract class AbstractLuaModule {
    private static final String LUA_PATTERN = "?.lua;";
    private static final String LUAC_PATTERN = "?.luac;";
    private Map<String, File> foldersCache = new HashMap<String, File>();

    protected LuaState loadLuaModule() {
        LuaState luaState = this.createLuaState();
        List<File> luaSourceFolders = this.getScriptFolders(this.getLuaSourcePaths());
        List<File> luacSourceFolders = this.getScriptFolders(this.getLuacSourcePaths());
        AbstractLuaModule.setLuaPath(luaState, luaSourceFolders, luacSourceFolders);
        luaState.getGlobal("require");
        luaState.pushString(this.getModuleName());
        luaState.call(1, 1);
        luaState.setGlobal(this.getModuleName());
        return luaState;
    }

    protected void pushLuaModule(LuaState luaState) {
        luaState.getGlobal(this.getModuleName());
    }

    protected List<File> getScriptFolders(List<String> folderRelativePaths) {
        ArrayList<File> scriptFolders = new ArrayList<File>();
        if (folderRelativePaths != null) {
            for (String folderRelativePath : folderRelativePaths) {
                File scriptFolder = this.getScriptFolder(folderRelativePath);
                if (scriptFolder == null) continue;
                scriptFolders.add(scriptFolder);
            }
        }
        return scriptFolders;
    }

    protected File getScriptFolder(String relativepath) {
        File folder = this.foldersCache.get(relativepath);
        if (folder == null) {
            try {
                URL folderUrl = FileLocator.toFileURL((URL)Platform.getBundle((String)this.getPluginID()).getEntry(relativepath));
                folder = new File(folderUrl.getFile());
                this.foldersCache.put(relativepath, folder);
            }
            catch (IOException e) {
                Activator.logError("Unable to get entry " + relativepath + " in the plugin " + this.getPluginID(), e);
            }
        }
        return folder;
    }

    public static void setLuaPath(LuaState luaState, List<File> luafolders, List<File> luacfolders) {
        StringBuffer code = new StringBuffer("package.path=[[");
        for (File folder : luafolders) {
            code.append(folder.getPath());
            code.append(File.separatorChar);
            code.append(LUA_PATTERN);
        }
        for (File folder : luacfolders) {
            code.append(folder.getPath());
            code.append(File.separatorChar);
            code.append(LUAC_PATTERN);
        }
        code.append("]]..package.path");
        luaState.load(code.toString(), "reloadingPath");
        luaState.call(0, 0);
    }

    protected abstract List<String> getLuaSourcePaths();

    protected abstract List<String> getLuacSourcePaths();

    protected abstract LuaState createLuaState();

    protected abstract String getPluginID();

    protected abstract String getModuleName();
}

