/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class TelnetTask
extends Task {
    private static final int WAIT_INTERVAL = 250;
    private static final int TELNET_PORT = 23;
    private String userid = null;
    private String password = null;
    private String server = null;
    private int port = 23;
    private Vector telnetTasks = new Vector();
    private boolean addCarriageReturn = false;
    private Integer defaultTimeout = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.server == null) {
            throw new BuildException("No Server Specified");
        }
        if (this.userid == null && this.password != null) {
            throw new BuildException("No Userid Specified");
        }
        if (this.password == null && this.userid != null) {
            throw new BuildException("No Password Specified");
        }
        AntTelnetClient telnet = null;
        try {
            telnet = new AntTelnetClient();
            try {
                telnet.connect(this.server, this.port);
            }
            catch (IOException e) {
                throw new BuildException("Can't connect to " + this.server);
            }
            if (this.userid != null && this.password != null) {
                this.login(telnet);
            }
            Enumeration tasksToRun = this.telnetTasks.elements();
            while (tasksToRun != null && tasksToRun.hasMoreElements()) {
                TelnetSubTask task = (TelnetSubTask)tasksToRun.nextElement();
                if (task instanceof TelnetRead && this.defaultTimeout != null) {
                    ((TelnetRead)task).setDefaultTimeout(this.defaultTimeout);
                }
                task.execute(telnet);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (telnet != null && telnet.isConnected()) {
                try {
                    telnet.disconnect();
                }
                catch (IOException e) {
                    throw new BuildException("Error disconnecting from " + this.server);
                }
            }
            throw throwable;
        }
        if (telnet != null && telnet.isConnected()) {
            try {
                telnet.disconnect();
            }
            catch (IOException e) {
                throw new BuildException("Error disconnecting from " + this.server);
            }
        }
    }

    private void login(AntTelnetClient telnet) {
        if (this.addCarriageReturn) {
            telnet.sendString("\n", true);
        }
        telnet.waitForString("ogin:");
        telnet.sendString(this.userid, true);
        telnet.waitForString("assword:");
        telnet.sendString(this.password, false);
    }

    public void setUserid(String u) {
        this.userid = u;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public void setServer(String m) {
        this.server = m;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setInitialCR(boolean b) {
        this.addCarriageReturn = b;
    }

    public void setTimeout(Integer i) {
        this.defaultTimeout = i;
    }

    public TelnetSubTask createRead() {
        TelnetRead task = new TelnetRead();
        this.telnetTasks.addElement(task);
        return task;
    }

    public TelnetSubTask createWrite() {
        TelnetWrite task = new TelnetWrite();
        this.telnetTasks.addElement(task);
        return task;
    }

    public class AntTelnetClient
    extends TelnetClient {
        public void waitForString(String s) {
            this.waitForString(s, null);
        }

        public void waitForString(String s, Integer timeout) {
            InputStream is = this.getInputStream();
            try {
                int windowStart;
                StringBuffer sb = new StringBuffer();
                if (timeout == null || timeout == 0) {
                    for (windowStart = -s.length(); windowStart < 0 || !sb.substring(windowStart).equals(s); ++windowStart) {
                        sb.append((char)is.read());
                    }
                } else {
                    Calendar endTime = Calendar.getInstance();
                    endTime.add(13, timeout);
                    while (windowStart < 0 || !sb.substring(windowStart).equals(s)) {
                        while (Calendar.getInstance().before(endTime) && is.available() == 0) {
                            Thread.sleep(250L);
                        }
                        if (is.available() == 0) {
                            TelnetTask.this.log("Read before running into timeout: " + sb.toString(), 4);
                            throw new BuildException("Response timed-out waiting for \"" + s + '\"', TelnetTask.this.getLocation());
                        }
                        sb.append((char)is.read());
                        ++windowStart;
                    }
                }
                TelnetTask.this.log(sb.toString(), 2);
            }
            catch (BuildException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e, TelnetTask.this.getLocation());
            }
        }

        public void sendString(String s, boolean echoString) {
            OutputStream os = this.getOutputStream();
            try {
                os.write((s + "\n").getBytes());
                if (echoString) {
                    TelnetTask.this.log(s, 2);
                }
                os.flush();
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e, TelnetTask.this.getLocation());
            }
        }
    }

    public class TelnetRead
    extends TelnetSubTask {
        private Integer timeout;

        public TelnetRead() {
            this.timeout = null;
        }

        public void execute(AntTelnetClient telnet) throws BuildException {
            telnet.waitForString(this.taskString, this.timeout);
        }

        public void setTimeout(Integer i) {
            this.timeout = i;
        }

        public void setDefaultTimeout(Integer defaultTimeout) {
            if (this.timeout == null) {
                this.timeout = defaultTimeout;
            }
        }
    }

    public class TelnetSubTask {
        protected String taskString = "";

        public void execute(AntTelnetClient telnet) throws BuildException {
            throw new BuildException("Shouldn't be able instantiate a SubTask directly");
        }

        public void addText(String s) {
            this.setString(TelnetTask.this.getProject().replaceProperties(s));
        }

        public void setString(String s) {
            this.taskString = this.taskString + s;
        }
    }

    public class TelnetWrite
    extends TelnetSubTask {
        private boolean echoString = true;

        public void execute(AntTelnetClient telnet) throws BuildException {
            telnet.sendString(this.taskString, this.echoString);
        }

        public void setEcho(boolean b) {
            this.echoString = b;
        }
    }
}

