/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.core.attach;

import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.internal.debug.core.model.IScriptBreakpointPathMapperExtension;
import org.eclipse.dltk.internal.debug.core.model.ScriptLineBreakpoint;
import org.eclipse.koneki.ldt.debug.core.Activator;

public class LuaAttachBreakpointPathMapper
implements IScriptBreakpointPathMapperExtension {
    private HashMap<URI, URI> cache;
    private String mapTo;
    private IScriptProject scriptProject;

    public LuaAttachBreakpointPathMapper(IScriptProject project, String mapTo) {
        this.mapTo = mapTo;
        this.scriptProject = project;
        this.cache = new HashMap();
    }

    public void clearCache() {
        this.cache.clear();
    }

    public URI map(URI uri) {
        URI result;
        if (this.mapTo == null || "".equals(this.mapTo)) {
            return uri;
        }
        if (this.cache.containsKey(uri)) {
            return this.cache.get(uri);
        }
        Path path = new Path(uri.getPath());
        IPath strippedPath = this.stripSourceFolders((IPath)path);
        if (strippedPath != null) {
            IPath outgoing = new Path(this.mapTo).append(strippedPath);
            result = ScriptLineBreakpoint.makeUri((IPath)outgoing);
        } else {
            result = uri;
        }
        this.cache.put(uri, result);
        return result;
    }

    private IPath stripSourceFolders(IPath path) {
        try {
            IProjectFragment[] fragments = this.scriptProject.getAllProjectFragments();
            int i = 0;
            while (i < fragments.length) {
                IPath temp;
                IProjectFragment frag = fragments[i];
                if (frag.isExternal()) {
                    IPath localPath = EnvironmentPathUtils.getLocalPath((IPath)frag.getPath());
                    if (localPath.isPrefixOf(path)) {
                        temp = path.removeFirstSegments(localPath.segmentCount()).setDevice(null);
                        return temp;
                    }
                } else if (!frag.isArchive()) {
                    IPath projectPath = frag.getScriptProject().getProject().getLocation();
                    if (projectPath.isPrefixOf(path)) {
                        temp = path.removeFirstSegments(projectPath.segmentCount()).setDevice(null);
                        String name = frag.getElementName();
                        if (temp.segmentCount() > 0 && temp.segment(0).equals(name)) {
                            return temp.removeFirstSegments(1);
                        }
                    } else {
                        IPath localPath = frag.getResource().getLocation();
                        if (localPath.isPrefixOf(path)) {
                            IPath temp2 = path.removeFirstSegments(localPath.segmentCount()).setDevice(null);
                            return temp2;
                        }
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Activator.logError("Breakpoint path mapper failed to map this path :" + path, e);
        }
        return null;
    }
}

