/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.buildpath;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.koneki.ldt.Activator;
import org.eclipse.koneki.ldt.core.buildpath.LuaExecutionEnvironment;
import org.eclipse.koneki.ldt.core.buildpath.LuaExecutionEnvironmentBuildpathContainer;
import org.eclipse.koneki.ldt.core.buildpath.LuaExecutionEnvironmentBuildpathUtil;

public final class LuaExecutionEnvironmentManager {
    private static final String INSTALLATION_FOLDER = "ee";

    private LuaExecutionEnvironmentManager() {
    }

    private static LuaExecutionEnvironment getExecutionEnvironmentFromCompressedFile(String filePath) throws CoreException {
        String manifestString;
        block17: {
            ZipFile zipFile = null;
            manifestString = null;
            try {
                try {
                    zipFile = new ZipFile(filePath);
                    Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
                    while (zipEntries.hasMoreElements()) {
                        ZipEntry zipEntry = zipEntries.nextElement();
                        if (zipEntry.getName().contains("/") || !zipEntry.getName().endsWith(".rockspec")) continue;
                        if (manifestString != null) {
                            LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Invalid Execution Environment : more than one \"{0}\" file.", ".rockspec"), null, 4);
                        }
                        InputStream input = zipFile.getInputStream(zipEntry);
                        manifestString = IOUtils.toString((InputStream)input);
                    }
                }
                catch (IOException e) {
                    LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to extract manifest from zip file {0}", filePath), e, 4);
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException e2) {
                            Activator.logWarning(MessageFormat.format("Unable to close zip file {0}", filePath), e2);
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {
                        Activator.logWarning(MessageFormat.format("Unable to close zip file {0}", filePath), e);
                    }
                }
                throw throwable;
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    Activator.logWarning(MessageFormat.format("Unable to close zip file {0}", filePath), e);
                }
            }
        }
        if (manifestString == null) {
            LuaExecutionEnvironmentManager.throwException(MessageFormat.format("No manifest \"{0}\" file found", ".rockspec"), null, 4);
        }
        return LuaExecutionEnvironmentManager.getLuaExecutionEnvironmentFromManifest(manifestString);
    }

    private static LuaExecutionEnvironment getInstalledExecutionEnvironmentFromDir(File executionEnvironmentDirectory) throws CoreException {
        String manifestString;
        block16: {
            if (!executionEnvironmentDirectory.exists() || !executionEnvironmentDirectory.isDirectory()) {
                return null;
            }
            manifestString = null;
            File[] manifests = executionEnvironmentDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".rockspec");
                }
            });
            if (manifests == null || manifests.length != 1) {
                String message = MessageFormat.format("0 or more than 1 \"{0}\" file in given file.", ".rockspec");
                LuaExecutionEnvironmentManager.throwException(message, null, 4);
            }
            InputStream manifestInputStream = null;
            try {
                try {
                    manifestInputStream = new FileInputStream(manifests[0]);
                    manifestString = IOUtils.toString((InputStream)manifestInputStream);
                }
                catch (IOException e) {
                    LuaExecutionEnvironmentManager.throwException("Unable to read manifest file.", e, 4);
                    if (manifestInputStream != null) {
                        try {
                            manifestInputStream.close();
                        }
                        catch (IOException e2) {
                            Activator.logWarning(MessageFormat.format("Unable to close file {0}", manifests[0]), e2);
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (manifestInputStream != null) {
                    try {
                        manifestInputStream.close();
                    }
                    catch (IOException e) {
                        Activator.logWarning(MessageFormat.format("Unable to close file {0}", manifests[0]), e);
                    }
                }
                throw throwable;
            }
            if (manifestInputStream != null) {
                try {
                    manifestInputStream.close();
                }
                catch (IOException e) {
                    Activator.logWarning(MessageFormat.format("Unable to close file {0}", manifests[0]), e);
                }
            }
        }
        return LuaExecutionEnvironmentManager.getLuaExecutionEnvironmentFromManifest(manifestString);
    }

    private static LuaExecutionEnvironment getLuaExecutionEnvironmentFromManifest(String manifestString) throws CoreException {
        Pattern namePattern = Pattern.compile("(?:^|\\s+)package\\s*=\\s*(?:[\"']|\\[*)([\\w.]+)");
        String name = null;
        Matcher matcher = namePattern.matcher(manifestString);
        if (matcher.find() && matcher.groupCount() > 0) {
            name = matcher.group(1);
        }
        String version = null;
        namePattern = Pattern.compile("(?:^|\\s+)version\\s*=\\s*(?:[\"']|\\[*)([\\w.]+)");
        matcher = namePattern.matcher(manifestString);
        if (matcher.find() && matcher.groupCount() > 0) {
            version = matcher.group(1);
        }
        if (name == null || version == null) {
            LuaExecutionEnvironmentManager.throwException("Manifest from given file has no package name or version.", null, 4);
        }
        IPath pathToEE = LuaExecutionEnvironmentManager.getInstallDirectory().append(String.valueOf(name) + '-' + version);
        return new LuaExecutionEnvironment(name, version, pathToEE);
    }

    public static void removeLuaExecutionEnvironment(LuaExecutionEnvironment ee) throws CoreException {
        File eeInstallationDir;
        IPath pathToEE;
        if (ee == null) {
            LuaExecutionEnvironmentManager.throwException("No Execution Environment provided.", null, 4);
        }
        if ((pathToEE = ee.getPath()) == null) {
            LuaExecutionEnvironmentManager.throwException("The install path should not be null", null, 4);
        }
        if ((eeInstallationDir = pathToEE.toFile()).exists()) {
            try {
                FileUtils.deleteDirectory((File)eeInstallationDir);
                LuaExecutionEnvironmentManager.refreshDLTKModel(ee);
            }
            catch (IOException e) {
                LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to delete install directory : {0}", pathToEE.toOSString()), e, 4);
            }
        }
    }

    public static LuaExecutionEnvironment installLuaExecutionEnvironment(String zipPath) throws CoreException {
        LuaExecutionEnvironment ee;
        block45: {
            File installDirectory;
            IPath eePath;
            ee = null;
            ee = LuaExecutionEnvironmentManager.getExecutionEnvironmentFromCompressedFile(zipPath);
            if (ee == null) {
                LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to extract execution environment information from {0}.", zipPath), null, 4);
            }
            if (LuaExecutionEnvironmentManager.getInstalledExecutionEnvironments().contains(ee)) {
                LuaExecutionEnvironmentManager.throwException("Execution environment is already installed.", null, 4);
            }
            if ((eePath = ee.getPath()) == null) {
                LuaExecutionEnvironmentManager.throwException("The install path should not be null.", null, 4);
            }
            if ((installDirectory = eePath.toFile()).exists()) {
                if (installDirectory.isFile()) {
                    if (!installDirectory.delete()) {
                        LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to clean installation directory : {0}", eePath.toOSString()), null, 4);
                    }
                } else {
                    try {
                        FileUtils.deleteDirectory((File)installDirectory);
                    }
                    catch (IOException e) {
                        LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to clean installation directory : {0}", eePath.toOSString()), e, 4);
                    }
                }
            }
            if (!installDirectory.mkdirs()) {
                LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to create installation directory : {0}", eePath.toOSString()), null, 4);
            }
            ZipInputStream zipStream = null;
            FileInputStream input = null;
            try {
                try {
                    input = new FileInputStream(zipPath);
                    zipStream = new ZipInputStream(new BufferedInputStream(input));
                    ZipEntry entry = zipStream.getNextEntry();
                    while (entry != null) {
                        File outputFile = new File(installDirectory, entry.getName());
                        if (entry.isDirectory()) {
                            if (!outputFile.mkdir()) {
                                LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to create install directory {0}", outputFile.toString()), null, 4);
                            }
                        } else {
                            FileOutputStream fileOutputStream = null;
                            try {
                                fileOutputStream = new FileOutputStream(outputFile);
                                IOUtils.copy((InputStream)zipStream, (OutputStream)fileOutputStream);
                                fileOutputStream.flush();
                            }
                            catch (Throwable throwable) {
                                if (fileOutputStream != null) {
                                    try {
                                        fileOutputStream.close();
                                    }
                                    catch (IOException e) {
                                        Activator.logWarning(MessageFormat.format("Unable to close file {0}", outputFile), e);
                                    }
                                }
                                throw throwable;
                            }
                            if (fileOutputStream != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException e) {
                                    Activator.logWarning(MessageFormat.format("Unable to close file {0}", outputFile), e);
                                }
                            }
                        }
                        entry = zipStream.getNextEntry();
                    }
                }
                catch (IOException e) {
                    LuaExecutionEnvironmentManager.throwException(MessageFormat.format("Unable to extract zip file : {0}", zipPath), e, 4);
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e2) {
                            Activator.logWarning(MessageFormat.format("Unable to close file {0}", zipPath), e2);
                        }
                    }
                    if (zipStream != null) {
                        try {
                            zipStream.close();
                        }
                        catch (IOException e3) {
                            Activator.logWarning(MessageFormat.format("Unable to close file {0}", zipPath), e3);
                        }
                    }
                    break block45;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        Activator.logWarning(MessageFormat.format("Unable to close file {0}", zipPath), e);
                    }
                }
                if (zipStream != null) {
                    try {
                        zipStream.close();
                    }
                    catch (IOException e) {
                        Activator.logWarning(MessageFormat.format("Unable to close file {0}", zipPath), e);
                    }
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Activator.logWarning(MessageFormat.format("Unable to close file {0}", zipPath), e);
                }
            }
            if (zipStream != null) {
                try {
                    zipStream.close();
                }
                catch (IOException e) {
                    Activator.logWarning(MessageFormat.format("Unable to close file {0}", zipPath), e);
                }
            }
        }
        LuaExecutionEnvironmentManager.getInstalledExecutionEnvironment(ee.getID(), ee.getVersion());
        LuaExecutionEnvironmentManager.refreshDLTKModel(ee);
        return ee;
    }

    private static IPath getInstallDirectory() {
        return Activator.getDefault().getStateLocation().append(INSTALLATION_FOLDER);
    }

    public static List<LuaExecutionEnvironment> getInstalledExecutionEnvironments() {
        ArrayList<LuaExecutionEnvironment> result = new ArrayList<LuaExecutionEnvironment>();
        IPath installDirectoryPath = LuaExecutionEnvironmentManager.getInstallDirectory();
        File installDirectory = installDirectoryPath.toFile();
        if (installDirectory.exists() && installDirectory.isDirectory()) {
            File[] content;
            File[] fileArray = content = installDirectory.listFiles();
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                File executionEnvironmentDirectory = fileArray[n2];
                if (executionEnvironmentDirectory.exists() && executionEnvironmentDirectory.isDirectory()) {
                    try {
                        LuaExecutionEnvironment executionEnvironment = LuaExecutionEnvironmentManager.getInstalledExecutionEnvironmentFromDir(executionEnvironmentDirectory);
                        if (executionEnvironment != null) {
                            result.add(executionEnvironment);
                        }
                    }
                    catch (CoreException e) {
                        Activator.logWarning(MessageFormat.format("Unable to extract execution environment from {0}", executionEnvironmentDirectory), e);
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private static IPath getLuaExecutionEnvironmentPath(String name, String version) {
        return LuaExecutionEnvironmentManager.getInstallDirectory().append(String.valueOf(name) + '-' + version);
    }

    public static LuaExecutionEnvironment getInstalledExecutionEnvironment(String name, String version) throws CoreException {
        IPath luaExecutionEnvironmentPath = LuaExecutionEnvironmentManager.getLuaExecutionEnvironmentPath(name, version);
        return LuaExecutionEnvironmentManager.getInstalledExecutionEnvironmentFromDir(luaExecutionEnvironmentPath.toFile());
    }

    private static void refreshDLTKModel(LuaExecutionEnvironment ee) {
        try {
            IPath containerPath = LuaExecutionEnvironmentBuildpathUtil.getLuaExecutionEnvironmentContainerPath(ee);
            IScriptProject[] scriptProjects = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getScriptProjects();
            ArrayList<IScriptProject> affectedProjects = new ArrayList<IScriptProject>();
            int i = 0;
            while (i < scriptProjects.length) {
                IScriptProject scriptProject = scriptProjects[i];
                IBuildpathEntry[] entries = scriptProject.getRawBuildpath();
                int j = 0;
                while (j < entries.length) {
                    IBuildpathEntry entry = entries[j];
                    if (entry.getEntryKind() == 5 && containerPath.equals((Object)entry.getPath())) {
                        affectedProjects.add(scriptProject);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            int length = affectedProjects.size();
            if (length == 0) {
                return;
            }
            IScriptProject[] projects = new IScriptProject[length];
            affectedProjects.toArray(projects);
            IBuildpathContainer[] containers = new IBuildpathContainer[length];
            if (ee != null) {
                LuaExecutionEnvironmentBuildpathContainer container = new LuaExecutionEnvironmentBuildpathContainer(ee.getID(), ee.getVersion(), containerPath);
                int i2 = 0;
                while (i2 < length) {
                    containers[i2] = container;
                    ++i2;
                }
            }
            DLTKCore.setBuildpathContainer((IPath)containerPath, (IScriptProject[])projects, (IBuildpathContainer[])containers, null);
        }
        catch (ModelException e) {
            Activator.logError("Unable to refresh Model after execution environment change", e);
        }
    }

    private static void throwException(String message, Throwable t, int severity) throws CoreException {
        throw new CoreException((IStatus)new Status(severity, "org.eclipse.koneki.ldt", message, t));
    }
}

