/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.branding.splash.internal;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.BasicSplashHandler;

public class SplashHandler
extends BasicSplashHandler {
    private Font font;

    public void init(Shell splash) {
        int foregroundColorInteger;
        super.init(splash);
        String progressRectString = null;
        String messageRectString = null;
        String foregroundColorString = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            progressRectString = product.getProperty("startupProgressRect");
            messageRectString = product.getProperty("startupMessageRect");
            foregroundColorString = product.getProperty("startupForegroundColor");
        }
        Rectangle progressRect = StringConverter.asRectangle((String)progressRectString, (Rectangle)new Rectangle(10, 150, 100, 15));
        this.setProgressRect(progressRect);
        Rectangle messageRect = StringConverter.asRectangle((String)messageRectString, (Rectangle)new Rectangle(10, 35, 300, 15));
        this.setMessageRect(messageRect);
        try {
            foregroundColorInteger = Integer.parseInt(foregroundColorString, 16);
        }
        catch (NumberFormatException numberFormatException) {
            foregroundColorInteger = 13817855;
        }
        this.setForeground(new RGB((foregroundColorInteger & 0xFF0000) >> 16, (foregroundColorInteger & 0xFF00) >> 8, foregroundColorInteger & 0xFF));
        String version = (String)Platform.getBundle((String)"org.eclipse.koneki.ldt").getHeaders().get("Bundle-Version");
        final String buildId = "Version: " + version;
        String buildIdLocString = product.getProperty("buildIdLocation");
        final Point buildIdPoint = StringConverter.asPoint((String)buildIdLocString, (Point)new Point(280, 150));
        this.font = new Font((Device)Display.getDefault(), new FontData("Helvetica", Platform.getOS().equals("macosx") ? 9 : 7, 1));
        this.getContent().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(SplashHandler.this.getForeground());
                e.gc.setFont(SplashHandler.this.font);
                e.gc.drawText(buildId, buildIdPoint.x, buildIdPoint.y, true);
            }
        });
    }

    public void dispose() {
        this.font.dispose();
        super.dispose();
    }
}

