/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.buildpath;

import org.eclipse.core.runtime.IPath;

public class LuaExecutionEnvironment {
    private final String id;
    private final String version;
    private final IPath path;

    public LuaExecutionEnvironment(String identifier, String eeversion, IPath pathToEE) {
        this.id = identifier;
        this.version = eeversion;
        this.path = pathToEE;
    }

    public String getID() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public IPath getPath() {
        return this.path;
    }

    public IPath[] getSourcepath() {
        IPath sourcePath;
        if (this.path != null && this.path.toFile().exists() && (sourcePath = this.path.append("api.zip")).toFile().exists()) {
            return new IPath[]{sourcePath};
        }
        return new IPath[0];
    }

    public IPath[] getDocumentationPath() {
        IPath sourcePath;
        if (this.path != null && this.path.toFile().exists() && (sourcePath = this.path.append("docs/")).toFile().exists()) {
            return new IPath[]{sourcePath};
        }
        return new IPath[0];
    }

    public String getEEIdentifier() {
        return String.valueOf(this.getID()) + '-' + this.getVersion();
    }

    public String toString() {
        return this.getEEIdentifier();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LuaExecutionEnvironment other = (LuaExecutionEnvironment)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

