/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.buildpath;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.koneki.ldt.Activator;
import org.eclipse.koneki.ldt.core.buildpath.LuaExecutionEnvironment;
import org.eclipse.koneki.ldt.core.buildpath.LuaExecutionEnvironmentManager;

public final class LuaExecutionEnvironmentBuildpathUtil {
    private LuaExecutionEnvironmentBuildpathUtil() {
    }

    public static boolean isLuaExecutionEnvironmentContainer(IPath containerPath) {
        if (LuaExecutionEnvironmentBuildpathUtil.isValidExecutionEnvironmentBuildPath(containerPath)) {
            String eeid = LuaExecutionEnvironmentBuildpathUtil.getEEID(containerPath);
            String eeVersion = LuaExecutionEnvironmentBuildpathUtil.getEEVersion(containerPath);
            try {
                return LuaExecutionEnvironmentManager.getInstalledExecutionEnvironment(eeid, eeVersion) != null;
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
                return false;
            }
        }
        return false;
    }

    public static IPath getLuaExecutionEnvironmentContainerPath(LuaExecutionEnvironment env) {
        return new Path("org.eclipse.koneki.ldt.ExecutionEnvironmentContainer").append(env.getID()).append(env.getVersion());
    }

    public static String getEEID(IPath eePath) {
        if (LuaExecutionEnvironmentBuildpathUtil.isValidExecutionEnvironmentBuildPath(eePath)) {
            return eePath.segment(1);
        }
        return null;
    }

    public static String getEEVersion(IPath eePath) {
        if (LuaExecutionEnvironmentBuildpathUtil.isValidExecutionEnvironmentBuildPath(eePath)) {
            return eePath.segment(2);
        }
        return null;
    }

    public static LuaExecutionEnvironment getExecutionEnvironment(IPath path) throws CoreException {
        if (LuaExecutionEnvironmentBuildpathUtil.isValidExecutionEnvironmentBuildPath(path)) {
            String id = LuaExecutionEnvironmentBuildpathUtil.getEEID(path);
            String version = LuaExecutionEnvironmentBuildpathUtil.getEEVersion(path);
            return LuaExecutionEnvironmentManager.getInstalledExecutionEnvironment(id, version);
        }
        return null;
    }

    public static List<IPath> getExecutionEnvironmentBuildPath(IPath path) throws CoreException {
        LuaExecutionEnvironment ee;
        if (LuaExecutionEnvironmentBuildpathUtil.isValidExecutionEnvironmentBuildPath(path) && (ee = LuaExecutionEnvironmentBuildpathUtil.getExecutionEnvironment(path)) != null) {
            return LuaExecutionEnvironmentBuildpathUtil.getExecutionEnvironmentBuildPath(ee);
        }
        return new ArrayList<IPath>();
    }

    public static List<IPath> getExecutionEnvironmentBuildPath(LuaExecutionEnvironment ee) {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        IPath[] iPathArray = ee.getSourcepath();
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath sourcePath = iPathArray[n2];
            IEnvironment env = EnvironmentManager.getLocalEnvironment();
            IPath buildPath = EnvironmentPathUtils.getFullPath((IEnvironment)env, (IPath)sourcePath);
            arrayList.add(buildPath);
            ++n2;
        }
        return arrayList;
    }

    public static boolean isValidExecutionEnvironmentBuildPath(IPath eePath) {
        String[] segments = eePath.segments();
        return segments.length == 3 && "org.eclipse.koneki.ldt.ExecutionEnvironmentContainer".equals(segments[0]);
    }
}

