/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.BasicPartList;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.SWTRenderersMessages;
import org.eclipse.e4.ui.internal.workbench.swt.CSSRenderingUtils;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MOpaqueMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MOpaqueMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.ElementReferenceRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.LazyStackRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.EventHandler;
import org.w3c.dom.css.CSSValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackRenderer
extends LazyStackRenderer {
    public static final String TAG_VIEW_MENU = "ViewMenu";
    private static final String SHELL_CLOSE_EDITORS_MENU = "shell_close_editors_menu";
    private static final String STACK_SELECTED_PART = "stack_selected_part";
    private static int MIN_VIEW_CHARS = 1;
    private static int MIN_EDITOR_CHARS = 15;
    private static final String TOP_RIGHT = "topRight";
    Image viewMenuImage;
    @Inject
    IStylingEngine stylingEngine;
    @Inject
    IEventBroker eventBroker;
    @Inject
    IPresentationEngine renderer;
    private EventHandler itemUpdater;
    private EventHandler dirtyUpdater;
    private EventHandler viewMenuUpdater;
    private EventHandler childrenHandler;
    private boolean ignoreTabSelChanges = false;
    private ActivationJob activationJob = null;
    @Inject
    private MApplication application;

    private boolean isValid(MUIElement element) {
        if (element == null || !element.isToBeRendered()) {
            return false;
        }
        if (element instanceof MApplication) {
            return true;
        }
        MElementContainer parent = element.getParent();
        if (parent == null && element instanceof MWindow) {
            parent = (MUIElement)((EObject)element).eContainer();
        }
        if (parent == null) {
            MWindow window = this.modelService.getTopLevelWindowFor(element);
            return window == null ? false : this.isValid((MUIElement)this.modelService.findPlaceholderFor(window, element));
        }
        return this.isValid((MUIElement)parent);
    }

    private synchronized void activateStack(MElementContainer<MUIElement> stack) {
        CTabFolder ctf = (CTabFolder)stack.getWidget();
        if (ctf == null || ctf.isDisposed()) {
            return;
        }
        if (this.activationJob == null) {
            this.activationJob = new ActivationJob();
            this.activationJob.stackToActivate = stack;
            ctf.getDisplay().asyncExec((Runnable)this.activationJob);
        } else {
            this.activationJob.stackToActivate = stack;
        }
    }

    @PostConstruct
    public void init() {
        super.init(this.eventBroker);
        this.itemUpdater = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                MUIElement element = (MUIElement)event.getProperty("ChangedElement");
                if (!(element instanceof MPart)) {
                    return;
                }
                MPart part = (MPart)element;
                String attName = (String)event.getProperty("AttName");
                Object newValue = event.getProperty("NewValue");
                if (element.getParent() != null && element.getParent().getRenderer() == StackRenderer.this) {
                    CTabItem cti = StackRenderer.this.findItemForPart(element, (MElementContainer<MUIElement>)element.getParent());
                    if (cti != null) {
                        StackRenderer.this.updateTab(cti, part, attName, newValue);
                    }
                    return;
                }
                MWindow win = StackRenderer.this.modelService.getTopLevelWindowFor((MUIElement)part);
                List refs = StackRenderer.this.modelService.findElements((MUIElement)win, null, MPlaceholder.class, null);
                if (refs != null) {
                    for (MPlaceholder ref : refs) {
                        CTabItem cti;
                        MElementContainer refParent;
                        if (ref.getRef() != part || (refParent = ref.getParent()) == null || !(refParent.getRenderer() instanceof StackRenderer) || (cti = StackRenderer.this.findItemForPart((MUIElement)ref, (MElementContainer<MUIElement>)refParent)) == null) continue;
                        StackRenderer.this.updateTab(cti, part, attName, newValue);
                    }
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UILabel/*", this.itemUpdater);
        this.dirtyUpdater = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                Object objElement = event.getProperty("ChangedElement");
                if (!(objElement instanceof MPart)) {
                    return;
                }
                MPart part = (MPart)objElement;
                String attName = (String)event.getProperty("AttName");
                Object newValue = event.getProperty("NewValue");
                MElementContainer parent = part.getParent();
                if (parent != null && parent.getRenderer() == StackRenderer.this) {
                    CTabItem cti = StackRenderer.this.findItemForPart((MUIElement)part, (MElementContainer<MUIElement>)parent);
                    if (cti != null) {
                        StackRenderer.this.updateTab(cti, part, attName, newValue);
                    }
                    return;
                }
                List<MPlaceholder> refs = ElementReferenceRenderer.getRenderedPlaceholders((MUIElement)part);
                for (MPlaceholder ref : refs) {
                    CTabItem cti;
                    MElementContainer refParent = ref.getParent();
                    if (!(refParent.getRenderer() instanceof StackRenderer) || (cti = StackRenderer.this.findItemForPart((MUIElement)ref, (MElementContainer<MUIElement>)refParent)) == null) continue;
                    StackRenderer.this.updateTab(cti, part, attName, newValue);
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/Dirtyable", (String)"dirty"), this.dirtyUpdater);
        this.viewMenuUpdater = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                Object widget;
                MUIElement element;
                Object objElement = event.getProperty("ChangedElement");
                if (!(objElement instanceof MMenuElement)) {
                    return;
                }
                EObject parent = ((EObject)objElement).eContainer();
                while (parent instanceof MMenuElement) {
                    element = (MUIElement)parent;
                    if (!element.isToBeRendered() || !element.isVisible()) {
                        return;
                    }
                    objElement = parent;
                    parent = parent.eContainer();
                }
                if (!(parent instanceof MPart)) {
                    return;
                }
                element = (MPart)parent;
                MElementContainer parentElement = element.getParent();
                if (parentElement == null) {
                    MPlaceholder placeholder = element.getCurSharedRef();
                    if (placeholder == null) {
                        return;
                    }
                    parentElement = placeholder.getParent();
                    if (parentElement == null) {
                        return;
                    }
                }
                if ((widget = parentElement.getWidget()) instanceof CTabFolder) {
                    Boolean newValue = (Boolean)event.getProperty("NewValue");
                    CTabFolder folder = (CTabFolder)widget;
                    if (newValue.booleanValue()) {
                        if (StackRenderer.this.getViewMenuTB(folder) == null) {
                            StackRenderer.this.disposeViewMenu(folder);
                            StackRenderer.this.setupMenuButton((MPart)element, folder);
                            StackRenderer.this.layoutTopRight(folder);
                        }
                    } else if (!StackRenderer.this.isMenuVisible((MMenu)objElement)) {
                        StackRenderer.this.disposeViewMenu(folder);
                    }
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/visible/*", this.viewMenuUpdater);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this.viewMenuUpdater);
        this.childrenHandler = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                Object widget;
                MElementContainer parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (!(changedObj instanceof MToolBar)) {
                    return;
                }
                EObject container = ((EObject)changedObj).eContainer();
                if (container instanceof MPart && (parent = ((MPart)container).getParent()) instanceof MPartStack && parent.getSelectedElement() == container && parent.getRenderer() == StackRenderer.this && (widget = parent.getWidget()) instanceof CTabFolder) {
                    StackRenderer.this.layoutTopRight((CTabFolder)widget);
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this.childrenHandler);
    }

    private boolean isMenuVisible(MMenu menu) {
        if (menu.isToBeRendered() && menu.isVisible()) {
            for (MMenuElement element : menu.getChildren()) {
                if (element.isToBeRendered() && element.isVisible()) {
                    return true;
                }
                if (!(element instanceof MMenu) || !this.isMenuVisible((MMenu)element)) continue;
                return true;
            }
        }
        return false;
    }

    protected void updateTab(CTabItem cti, MPart part, String attName, Object newValue) {
        if ("label".equals(attName)) {
            String newName = (String)newValue;
            cti.setText(this.getLabel((MUILabel)part, newName));
        } else if ("iconURI".equals(attName)) {
            cti.setImage(this.getImage((MUILabel)part));
        } else if ("tooltip".equals(attName)) {
            String newTTip = (String)newValue;
            cti.setToolTipText(newTTip);
        } else if ("dirty".equals(attName)) {
            boolean hasAsterisk;
            Boolean dirtyState = (Boolean)newValue;
            String text = cti.getText();
            boolean bl = hasAsterisk = text.length() > 0 && text.charAt(0) == '*';
            if (dirtyState.booleanValue()) {
                if (!hasAsterisk) {
                    cti.setText(String.valueOf('*') + text);
                }
            } else if (hasAsterisk) {
                cti.setText(text.substring(1));
            }
        }
    }

    @PreDestroy
    public void contextDisposed() {
        super.contextDisposed(this.eventBroker);
        this.eventBroker.unsubscribe(this.itemUpdater);
        this.eventBroker.unsubscribe(this.dirtyUpdater);
        this.eventBroker.unsubscribe(this.viewMenuUpdater);
        this.eventBroker.unsubscribe(this.childrenHandler);
    }

    private String getLabel(MUILabel itemPart, String newName) {
        if (newName == null) {
            newName = "";
        }
        if (itemPart instanceof MDirtyable && ((MDirtyable)itemPart).isDirty()) {
            newName = String.valueOf('*') + newName;
        }
        return newName;
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MPartStack) || !(parent instanceof Composite)) {
            return null;
        }
        Composite parentComposite = (Composite)parent;
        if (element.getElementId() == null || element.getElementId().length() == 0) {
            String generatedId = "PartStack@" + Integer.toHexString(element.hashCode());
            element.setElementId(generatedId);
        }
        CTabFolder ctf = new CTabFolder(parentComposite, 2048);
        ctf.setMRUVisible(this.getInitialMRUValue((Control)ctf));
        int location = this.modelService.getElementLocation(element);
        if ((location & 8) != 0) {
            ctf.setMinimumCharacters(MIN_EDITOR_CHARS);
            ctf.setUnselectedCloseVisible(true);
        } else {
            ctf.setMinimumCharacters(MIN_VIEW_CHARS);
            ctf.setUnselectedCloseVisible(false);
        }
        this.bindWidget(element, ctf);
        this.addTopRight(ctf);
        return ctf;
    }

    private boolean getInitialMRUValue(Control control) {
        boolean result = false;
        CSSRenderingUtils util = (CSSRenderingUtils)this.context.get(CSSRenderingUtils.class);
        if (util == null) {
            return result;
        }
        CSSValue value = util.getCSSValue(control, "MPartStack", "swt-mru-visible");
        if (value == null) {
            value = util.getCSSValue(control, "MPartStack", "mru-visible");
        }
        if (value == null) {
            return result;
        }
        return Boolean.parseBoolean(value.getCssText());
    }

    private void addTopRight(CTabFolder ctf) {
        Composite trComp = new Composite((Composite)ctf, 0);
        trComp.setBackground(Display.getCurrent().getSystemColor(14));
        RowLayout rl = new RowLayout();
        trComp.setLayout((Layout)rl);
        rl.marginLeft = 0;
        rl.marginRight = 0;
        rl.marginTop = 0;
        rl.marginBottom = 0;
        ctf.setData(TOP_RIGHT, (Object)trComp);
        ctf.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Composite c = (Composite)e.widget.getData(StackRenderer.TOP_RIGHT);
                if (c != null && !c.isDisposed()) {
                    c.dispose();
                }
            }
        });
    }

    private Composite getTRComposite(CTabFolder ctf) {
        return (Composite)ctf.getData(TOP_RIGHT);
    }

    public void disposeViewMenu(CTabFolder ctf) {
        ToolBar vmTB = this.getViewMenuTB(ctf);
        if (vmTB != null && !vmTB.isDisposed()) {
            vmTB.dispose();
        }
    }

    public void clearTR(CTabFolder ctf) {
        MToolBar viewTBModel;
        this.disposeViewMenu(ctf);
        ToolBar vmTB = this.getViewMenuTB(ctf);
        if (vmTB != null && !vmTB.isDisposed()) {
            vmTB.dispose();
        }
        if ((viewTBModel = this.getViewTB(ctf)) != null && viewTBModel.getWidget() != null) {
            viewTBModel.setVisible(false);
        }
        ctf.setTopRight(null);
        this.getTRComposite(ctf).setVisible(false);
    }

    public void adjustTR(final CTabFolder ctf, MPart part) {
        this.clearTR(ctf);
        if (part == null) {
            return;
        }
        if (part.getToolbar() != null && part.getToolbar().isToBeRendered()) {
            part.getToolbar().setVisible(true);
            Object tbObj = this.renderer.createGui((MUIElement)part.getToolbar(), (Object)this.getTRComposite(ctf), part.getContext());
            if (tbObj instanceof Composite) {
                Control[] kids;
                Control[] controlArray = kids = ((Composite)tbObj).getChildren();
                int n = kids.length;
                int n2 = 0;
                while (n2 < n) {
                    Control kid = controlArray[n2];
                    if (kid instanceof ToolBar) {
                        kid.addControlListener(new ControlListener(){

                            public void controlResized(ControlEvent e) {
                                if (!ctf.isDisposed()) {
                                    Control tr = ctf.getTopRight();
                                    if (tr != null && !tr.isDisposed()) {
                                        ctf.getTopRight().pack();
                                    }
                                    ctf.layout(true, true);
                                }
                            }

                            public void controlMoved(ControlEvent e) {
                            }
                        });
                    }
                    ++n2;
                }
            }
        }
        this.setupMenuButton(part, ctf);
        this.layoutTopRight(ctf);
    }

    public void layoutTopRight(CTabFolder ctf) {
        Composite trComp = this.getTRComposite(ctf);
        if (trComp.getChildren().length > 0) {
            trComp.setVisible(true);
            ctf.setTopRight((Control)trComp, 131136);
        } else {
            ctf.setTopRight(null);
            trComp.setVisible(false);
        }
        trComp.pack();
        ctf.layout(true, true);
    }

    private MToolBar getViewTB(CTabFolder ctf) {
        Composite trComp = (Composite)ctf.getData(TOP_RIGHT);
        Control[] controlArray = trComp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control kid = controlArray[n2];
            if (kid.getData("modelElement") instanceof MToolBar) {
                return (MToolBar)kid.getData("modelElement");
            }
            ++n2;
        }
        return null;
    }

    private ToolBar getViewMenuTB(CTabFolder ctf) {
        Composite trComp = (Composite)ctf.getData(TOP_RIGHT);
        Control[] controlArray = trComp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control kid = controlArray[n2];
            if (kid.getData("modelElement") == null && TAG_VIEW_MENU.equals(kid.getData())) {
                return (ToolBar)kid;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected void createTab(MElementContainer<MUIElement> stack, MUIElement element) {
        Control ctrl;
        MPart part = null;
        if (element instanceof MPart) {
            part = (MPart)element;
        } else if (element instanceof MPlaceholder) {
            part = (MPart)((MPlaceholder)element).getRef();
            part.setCurSharedRef((MPlaceholder)element);
        }
        CTabFolder ctf = (CTabFolder)stack.getWidget();
        CTabItem cti = this.findItemForPart(element, stack);
        if (cti != null) {
            if (element.getWidget() != null && cti.getControl() != element.getWidget()) {
                cti.setControl((Control)element.getWidget());
            }
            return;
        }
        int createFlags = 0;
        if (part != null && this.isClosable(part)) {
            createFlags |= 0x40;
        }
        int index = this.calcIndexFor(stack, element);
        cti = new CTabItem(ctf, createFlags, index);
        cti.setData("modelElement", (Object)element);
        cti.setText(this.getLabel((MUILabel)part, part.getLocalizedLabel()));
        cti.setImage(this.getImage((MUILabel)part));
        cti.setToolTipText(part.getLocalizedTooltip());
        if (element.getWidget() != null && (ctrl = (Control)element.getWidget()).getParent() == ctf) {
            cti.setControl((Control)element.getWidget());
        }
    }

    private int calcIndexFor(MElementContainer<MUIElement> stack, MUIElement part) {
        int index = 0;
        for (MUIElement mPart : stack.getChildren()) {
            if (mPart == part) {
                return index;
            }
            if (!mPart.isToBeRendered() || !mPart.isVisible()) continue;
            ++index;
        }
        return index;
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        if (!(parentElement instanceof MPartStack) || !(element instanceof MStackElement)) {
            return;
        }
        this.createTab(parentElement, element);
    }

    private CTabItem findItemForPart(MUIElement element, MElementContainer<MUIElement> stack) {
        CTabFolder ctf;
        if (stack == null) {
            stack = element.getParent();
        }
        if ((ctf = (CTabFolder)stack.getWidget()) == null) {
            return null;
        }
        CTabItem[] items = ctf.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData("modelElement") == element) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        CTabFolder ctf = (CTabFolder)parentElement.getWidget();
        if (ctf == null) {
            return;
        }
        CTabItem cti = this.findItemForPart(child, parentElement);
        if (cti != null && !cti.isDisposed()) {
            cti.setControl(null);
            cti.dispose();
        }
        if (parentElement.getSelectedElement() == child) {
            this.clearTR(ctf);
        } else {
            MToolBar toolbar;
            MPlaceholder placeholder;
            if (child instanceof MPlaceholder && ((child = (placeholder = (MPlaceholder)child).getRef()) == null || child.getCurSharedRef() != placeholder)) {
                return;
            }
            if (child instanceof MPart && (toolbar = ((MPart)child).getToolbar()) != null) {
                toolbar.setVisible(false);
            }
        }
    }

    @Override
    public void hookControllerLogic(MUIElement me) {
        super.hookControllerLogic(me);
        if (!(me instanceof MElementContainer)) {
            return;
        }
        final MElementContainer stack = (MElementContainer)me;
        final CTabFolder ctf = (CTabFolder)me.getWidget();
        ctf.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (StackRenderer.this.ignoreTabSelChanges) {
                    return;
                }
                MUIElement ele = (MUIElement)e.item.getData("modelElement");
                ele.getParent().setSelectedElement(ele);
                StackRenderer.this.activateStack((MElementContainer<MUIElement>)stack);
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CTabItem item = ctf.getItem(new Point(e.x, e.y));
                if (item != null && e.button == 2) {
                    StackRenderer.this.closePart((Widget)item, false);
                }
                if (e.button == 1) {
                    Control ctrl;
                    MUIElement ele;
                    Rectangle clientArea;
                    if (item == null && !(clientArea = ctf.getClientArea()).contains(e.x, e.y)) {
                        item = ctf.getSelection();
                    }
                    if (item != null && (ele = (MUIElement)item.getData("modelElement")).getParent().getSelectedElement() == ele && (ctrl = (Control)ele.getWidget()) != null) {
                        ctrl.setFocus();
                    }
                }
            }
        };
        ctf.addMouseListener((MouseListener)mouseListener);
        CTabFolder2Adapter closeListener = new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                event.doit = StackRenderer.this.closePart(event.item, true);
            }

            public void showList(CTabFolderEvent event) {
                event.doit = false;
                StackRenderer.this.showAvailableItems(stack, ctf);
            }
        };
        ctf.addCTabFolder2Listener((CTabFolder2Listener)closeListener);
        ctf.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                CTabFolder ctf = (CTabFolder)event.widget;
                MElementContainer stack = (MElementContainer)ctf.getData("modelElement");
                StackRenderer.this.activateStack((MElementContainer<MUIElement>)stack);
            }
        });
        ctf.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                Rectangle clientArea;
                Point absolutePoint = new Point(e.x, e.y);
                Point relativePoint = ctf.getDisplay().map(null, (Control)ctf, absolutePoint);
                CTabItem eventTabItem = ctf.getItem(relativePoint);
                if (eventTabItem == null && !(clientArea = ctf.getClientArea()).contains(relativePoint)) {
                    eventTabItem = ctf.getSelection();
                }
                if (eventTabItem != null) {
                    MUIElement uiElement = (MUIElement)eventTabItem.getData("modelElement");
                    MPart tabPart = (MPart)(uiElement instanceof MPart ? uiElement : ((MPlaceholder)uiElement).getRef());
                    StackRenderer.this.openMenuFor(tabPart, ctf, absolutePoint);
                }
            }
        });
    }

    public void showAvailableItems(MElementContainer<?> stack, CTabFolder ctf) {
        IEclipseContext ctxt = this.getContext((MUIElement)stack);
        final BasicPartList editorList = new BasicPartList(ctf.getShell(), 16384, 768, (EPartService)ctxt.get(EPartService.class), stack, (ISWTResourceUtilities)ctxt.get(IResourceUtilities.class), this.getInitialMRUValue((Control)ctf));
        editorList.setInput();
        Point size = editorList.computeSizeHint();
        editorList.setSize(size.x, size.y);
        editorList.setLocation(ctf.toDisplay(this.getChevronLocation(ctf)));
        editorList.setVisible(true);
        editorList.setFocus();
        editorList.getShell().addListener(27, new Listener(){

            public void handleEvent(Event event) {
                editorList.getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        editorList.dispose();
                    }
                });
            }
        });
    }

    private Point getChevronLocation(CTabFolder tabFolder) {
        int numItems = tabFolder.getItemCount();
        CTabItem item = null;
        int i = 0;
        while (i < numItems) {
            CTabItem tempItem = tabFolder.getItem(i);
            if (tempItem.isShowing()) {
                item = tempItem;
            }
            ++i;
        }
        if (item == null) {
            return new Point(0, 0);
        }
        Rectangle itemBounds = item.getBounds();
        int x = itemBounds.x + itemBounds.width;
        int y = itemBounds.y + itemBounds.height;
        return new Point(x, y);
    }

    private boolean closePart(Widget widget, boolean check) {
        MUIElement uiElement = (MUIElement)widget.getData("modelElement");
        MPart part = (MPart)(uiElement instanceof MPart ? uiElement : ((MPlaceholder)uiElement).getRef());
        if (!check && !this.isClosable(part)) {
            return false;
        }
        IEclipseContext partContext = part.getContext();
        IEclipseContext parentContext = this.getContextForParent((MUIElement)part);
        IEclipseContext context = partContext == null ? parentContext : partContext;
        EPartService partService = (EPartService)context.get(EPartService.class.getName());
        if (partService.savePart(part, true)) {
            partService.hidePart(part);
            return true;
        }
        return false;
    }

    @Override
    protected void showTab(MUIElement element) {
        Control ctrl;
        super.showTab(element);
        if (!element.isVisible()) {
            return;
        }
        CTabFolder ctf = (CTabFolder)this.getParentWidget(element);
        CTabItem cti = this.findItemForPart(element, null);
        if (cti == null) {
            this.createTab((MElementContainer<MUIElement>)element.getParent(), element);
            cti = this.findItemForPart(element, (MElementContainer<MUIElement>)element.getParent());
        }
        if ((ctrl = (Control)element.getWidget()) != null && ctrl.getParent() != ctf) {
            ctrl.setParent((Composite)ctf);
            cti.setControl(ctrl);
        } else if (element.getWidget() == null) {
            Control tabCtrl = (Control)this.renderer.createGui(element);
            cti.setControl(tabCtrl);
        }
        this.ignoreTabSelChanges = true;
        ctf.setSelection(cti);
        this.ignoreTabSelChanges = false;
        MPart part = (MPart)(element instanceof MPart ? element : ((MPlaceholder)element).getRef());
        this.adjustTR(ctf, part);
    }

    public void setupMenuButton(MPart part, CTabFolder ctf) {
        MMenu viewMenu = StackRenderer.getViewMenu(part);
        if (viewMenu != null && this.hasVisibleMenuItems(viewMenu, part)) {
            this.showMenuButton(part, ctf, viewMenu);
        } else {
            ToolBar menuTB = this.getViewMenuTB(ctf);
            if (menuTB != null) {
                menuTB.dispose();
            }
        }
    }

    private void showMenuButton(MPart part, CTabFolder ctf, MMenu menu) {
        ToolItem ti;
        ToolBar menuTB = this.getViewMenuTB(ctf);
        if (menuTB == null) {
            menuTB = new ToolBar(this.getTRComposite(ctf), 0x820000);
            menuTB.setData((Object)TAG_VIEW_MENU);
            ti = new ToolItem(menuTB, 8);
            ti.setImage(this.getViewMenuImage());
            ti.setHotImage(null);
            ti.setToolTipText(SWTRenderersMessages.viewMenu);
            ti.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    StackRenderer.this.showMenu((ToolItem)e.widget);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    StackRenderer.this.showMenu((ToolItem)e.widget);
                }
            });
            menuTB.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    if (e.childID != -1) {
                        ToolItem item;
                        Accessible accessible = (Accessible)e.getSource();
                        ToolBar toolBar = (ToolBar)accessible.getControl();
                        if (e.childID >= 0 && e.childID < toolBar.getItemCount() && (item = toolBar.getItem(e.childID)) != null) {
                            e.result = item.getToolTipText();
                        }
                    }
                }
            });
        }
        ti = menuTB.getItem(0);
        ti.setData("theMenu", (Object)menu);
        ti.setData("thePart", (Object)part);
    }

    protected void showMenu(ToolItem item) {
        MMenu menuModel = (MMenu)item.getData("theMenu");
        Menu menu = null;
        Object obj = menuModel.getWidget();
        if (obj instanceof Menu) {
            menu = (Menu)obj;
        }
        if (menu == null || menu.isDisposed()) {
            Menu tmpMenu;
            MPart part = (MPart)item.getData("thePart");
            Control ctrl = (Control)part.getWidget();
            menu = tmpMenu = (Menu)this.renderer.createGui((MUIElement)menuModel, (Object)ctrl.getShell(), part.getContext());
            if (tmpMenu != null) {
                ctrl.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (!tmpMenu.isDisposed()) {
                            tmpMenu.dispose();
                        }
                    }
                });
            }
        }
        if (menu == null) {
            return;
        }
        Rectangle ib = item.getBounds();
        Point displayAt = item.getParent().toDisplay(ib.x, ib.y + ib.height);
        menu.setLocation(displayAt);
        menu.setVisible(true);
        Display display = Display.getCurrent();
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!menu.isDisposed() && !(menu.getData() instanceof MenuManager)) {
            menu.dispose();
        }
    }

    private Image getViewMenuImage() {
        if (this.viewMenuImage == null) {
            Display d = Display.getCurrent();
            Image viewMenu = new Image((Device)d, 16, 16);
            Image viewMenuMask = new Image((Device)d, 16, 16);
            Display display = Display.getCurrent();
            GC gc = new GC((Drawable)viewMenu);
            GC maskgc = new GC((Drawable)viewMenuMask);
            gc.setForeground(display.getSystemColor(17));
            gc.setBackground(display.getSystemColor(25));
            int[] shapeArray = new int[]{6, 1, 15, 1, 11, 5, 10, 5};
            gc.fillPolygon(shapeArray);
            gc.drawPolygon(shapeArray);
            Color black = display.getSystemColor(2);
            Color white = display.getSystemColor(1);
            maskgc.setBackground(black);
            maskgc.fillRectangle(0, 0, 16, 16);
            maskgc.setBackground(white);
            maskgc.setForeground(white);
            maskgc.fillPolygon(shapeArray);
            maskgc.drawPolygon(shapeArray);
            gc.dispose();
            maskgc.dispose();
            ImageData data = viewMenu.getImageData();
            data.transparentPixel = data.getPixel(0, 0);
            this.viewMenuImage = new Image((Device)d, viewMenu.getImageData(), viewMenuMask.getImageData());
            viewMenu.dispose();
            viewMenuMask.dispose();
        }
        return this.viewMenuImage;
    }

    private void openMenuFor(MPart part, CTabFolder folder, Point point) {
        Menu tabMenu = this.createTabMenu(folder, part);
        tabMenu.setData(STACK_SELECTED_PART, (Object)part);
        tabMenu.setLocation(point.x, point.y);
        tabMenu.setVisible(true);
    }

    private boolean isClosable(MPart part) {
        if (part.getCurSharedRef() != null) {
            return !part.getCurSharedRef().getTags().contains("NoClose");
        }
        return part.isCloseable();
    }

    private Menu createTabMenu(CTabFolder folder, MPart part) {
        MElementContainer<MUIElement> parent;
        Shell shell = folder.getShell();
        Menu cachedMenu = (Menu)shell.getData(SHELL_CLOSE_EDITORS_MENU);
        if (cachedMenu == null) {
            cachedMenu = new Menu((Control)folder);
            shell.setData(SHELL_CLOSE_EDITORS_MENU, (Object)cachedMenu);
        } else {
            MenuItem[] menuItemArray = cachedMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                item.dispose();
                ++n2;
            }
        }
        final Menu menu = cachedMenu;
        if (this.isClosable(part)) {
            MenuItem menuItemClose = new MenuItem(menu, 0);
            menuItemClose.setText(SWTRenderersMessages.menuClose);
            menuItemClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MPart part = (MPart)menu.getData(StackRenderer.STACK_SELECTED_PART);
                    EPartService partService = (EPartService)StackRenderer.this.getContextForParent((MUIElement)part).get(EPartService.class);
                    if (partService.savePart(part, true)) {
                        partService.hidePart(part);
                    }
                }
            });
        }
        if ((parent = this.getParent(part)) != null) {
            int count = 0;
            for (MUIElement element : parent.getChildren()) {
                if (!element.isToBeRendered() || ++count != 2) continue;
                MenuItem menuItemOthers = new MenuItem(menu, 0);
                menuItemOthers.setText(SWTRenderersMessages.menuCloseOthers);
                menuItemOthers.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MPart part = (MPart)menu.getData(StackRenderer.STACK_SELECTED_PART);
                        StackRenderer.this.closeSiblingParts(part, true);
                    }
                });
                MenuItem menuItemAll = new MenuItem(menu, 0);
                menuItemAll.setText(SWTRenderersMessages.menuCloseAll);
                menuItemAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MPart part = (MPart)menu.getData(StackRenderer.STACK_SELECTED_PART);
                        StackRenderer.this.closeSiblingParts(part, false);
                    }
                });
                break;
            }
        }
        return menu;
    }

    private MElementContainer<MUIElement> getParent(MPart part) {
        MElementContainer parent = part.getParent();
        if (parent == null) {
            MPlaceholder placeholder = part.getCurSharedRef();
            return placeholder == null ? null : placeholder.getParent();
        }
        return parent;
    }

    private void closeSiblingParts(MPart part, boolean skipThisPart) {
        MUIElement selectedElement;
        MElementContainer<MUIElement> container = this.getParent(part);
        if (container == null) {
            return;
        }
        List children = container.getChildren();
        LinkedList<MPart> others = new LinkedList<MPart>();
        for (MUIElement child : children) {
            MUIElement otherItem;
            MPart otherPart = null;
            if (child instanceof MPart) {
                otherPart = (MPart)child;
            } else if (child instanceof MPlaceholder && (otherItem = ((MPlaceholder)child).getRef()) instanceof MPart) {
                otherPart = (MPart)otherItem;
            }
            if (otherPart == null || part.equals(otherPart) || !otherPart.isToBeRendered() || !this.isClosable(otherPart)) continue;
            others.add(otherPart);
        }
        if (!skipThisPart && part.isToBeRendered() && this.isClosable(part)) {
            others.add(part);
        }
        if (others.remove(selectedElement = container.getSelectedElement())) {
            others.add((MPart)selectedElement);
        } else if (selectedElement instanceof MPlaceholder && others.remove(selectedElement = ((MPlaceholder)selectedElement).getRef())) {
            others.add((MPart)selectedElement);
        }
        EPartService partService = (EPartService)this.getContextForParent((MUIElement)part).get(EPartService.class);
        for (MPart otherPart : others) {
            if (!partService.savePart(otherPart, true)) continue;
            partService.hidePart(otherPart);
        }
    }

    public static MMenu getViewMenu(MPart part) {
        if (part.getMenus() == null) {
            return null;
        }
        for (MMenu menu : part.getMenus()) {
            if (!menu.getTags().contains(TAG_VIEW_MENU)) continue;
            return menu;
        }
        return null;
    }

    private boolean hasVisibleMenuItems(MMenu viewMenu, MPart part) {
        Menu menu;
        MenuManager manager;
        if (!viewMenu.isToBeRendered() || !viewMenu.isVisible()) {
            return false;
        }
        for (MMenuElement menuElement : viewMenu.getChildren()) {
            IContributionItem item;
            if (!menuElement.isToBeRendered() || !menuElement.isVisible()) continue;
            if (menuElement instanceof MOpaqueMenuItem) {
                item = (IContributionItem)((MOpaqueMenuItem)menuElement).getOpaqueItem();
                if (item == null || !item.isVisible()) continue;
                return true;
            }
            if (menuElement instanceof MOpaqueMenuSeparator) {
                item = (IContributionItem)((MOpaqueMenuSeparator)menuElement).getOpaqueItem();
                if (item == null || !item.isVisible()) continue;
                return true;
            }
            return true;
        }
        Object menuRenderer = viewMenu.getRenderer();
        if (menuRenderer instanceof MenuManagerRenderer && (manager = ((MenuManagerRenderer)((Object)menuRenderer)).getManager(viewMenu)) != null && manager.isVisible()) {
            return true;
        }
        Control control = (Control)part.getWidget();
        if (control != null && (menu = (Menu)this.renderer.createGui((MUIElement)viewMenu, (Object)control.getShell(), part.getContext())) != null) {
            MenuManagerRenderer menuManagerRenderer;
            MenuManager manager2;
            menuRenderer = viewMenu.getRenderer();
            if (menuRenderer instanceof MenuManagerRenderer && (manager2 = (menuManagerRenderer = (MenuManagerRenderer)((Object)menuRenderer)).getManager(viewMenu)) != null) {
                manager2.markDirty();
            }
            return menu.getItemCount() != 0;
        }
        return false;
    }

    private class ActivationJob
    implements Runnable {
        public MElementContainer<MUIElement> stackToActivate = null;

        private ActivationJob() {
        }

        private boolean shouldActivate() {
            IEclipseContext applicationContext;
            IEclipseContext activeChild;
            return StackRenderer.this.application == null || (activeChild = (applicationContext = StackRenderer.this.application.getContext()).getActiveChild()) != null && activeChild.get(MWindow.class) == StackRenderer.this.application.getSelectedElement() && StackRenderer.this.application.getSelectedElement() == StackRenderer.this.modelService.getTopLevelWindowFor(this.stackToActivate);
        }

        public void run() {
            StackRenderer.this.activationJob = null;
            if (this.stackToActivate != null && this.stackToActivate.getSelectedElement() != null && this.shouldActivate()) {
                int location = StackRenderer.this.modelService.getElementLocation(this.stackToActivate);
                if ((location & 2) == 0 && (location & 1) == 0 && (location & 8) == 0) {
                    return;
                }
                MUIElement selElement = this.stackToActivate.getSelectedElement();
                if (!StackRenderer.this.isValid(selElement)) {
                    return;
                }
                if (selElement instanceof MPlaceholder) {
                    selElement = ((MPlaceholder)selElement).getRef();
                }
                StackRenderer.this.activate((MPart)selElement);
            }
        }
    }
}

