/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal;

import org.eclipse.equinox.bidi.advanced.ISTextExpert;
import org.eclipse.equinox.bidi.advanced.STextEnvironment;
import org.eclipse.equinox.bidi.custom.STextCharTypes;
import org.eclipse.equinox.bidi.custom.STextOffsets;
import org.eclipse.equinox.bidi.custom.STextTypeHandler;

public class STextImpl
implements ISTextExpert {
    static final String EMPTY_STRING = "";
    static final byte B = 10;
    static final byte L = 0;
    static final byte R = 1;
    static final byte AL = 2;
    static final byte AN = 6;
    static final byte EN = 3;
    static final char LRM = '\u200e';
    static final char RLM = '\u200f';
    static final char LRE = '\u202a';
    static final char RLE = '\u202b';
    static final char PDF = '\u202c';
    static final char[] MARKS = new char[]{'\u200e', '\u200f'};
    static final char[] EMBEDS = new char[]{'\u202a', '\u202b'};
    static final int PREFIX_LENGTH = 2;
    static final int SUFFIX_LENGTH = 2;
    static final int FIXES_LENGTH = 4;
    static final int[] EMPTY_INT_ARRAY = new int[0];
    protected final STextTypeHandler handler;
    protected final STextEnvironment environment;
    protected final boolean sharedExpert;
    protected Object state;

    public STextImpl(STextTypeHandler structuredTextHandler, STextEnvironment environment, boolean shared) {
        this.handler = structuredTextHandler;
        this.environment = environment;
        this.sharedExpert = shared;
    }

    public STextTypeHandler getTypeHandler() {
        return this.handler;
    }

    public STextEnvironment getEnvironment() {
        return this.environment;
    }

    public int getTextDirection(String text) {
        return this.handler.getDirection(this, text);
    }

    public void clearState() {
        if (this.sharedExpert) {
            this.state = null;
        }
    }

    public void setState(Object newState) {
        if (this.sharedExpert) {
            this.state = newState;
        }
    }

    public Object getState() {
        return this.state;
    }

    long computeNextLocation(String text, STextCharTypes charTypes, STextOffsets offsets, int[] locations, int curPos) {
        int location;
        int len;
        String separators = this.handler.getSeparators(this);
        int separCount = separators.length();
        int specialsCount = this.handler.getSpecialsCount(this);
        int nextLocation = len = text.length();
        int idxLocation = 0;
        int i = 0;
        while (i < specialsCount) {
            location = locations[separCount + i];
            if (location < curPos) {
                location = this.handler.indexOfSpecial(this, text, charTypes, offsets, i + 1, curPos);
                if (location < 0) {
                    location = len;
                }
                locations[separCount + i] = location;
            }
            if (location < nextLocation) {
                nextLocation = location;
                idxLocation = separCount + i;
            }
            ++i;
        }
        i = 0;
        while (i < separCount) {
            location = locations[i];
            if (location < curPos) {
                location = text.indexOf(separators.charAt(i), curPos);
                if (location < 0) {
                    location = len;
                }
                locations[i] = location;
            }
            if (location < nextLocation) {
                nextLocation = location;
                idxLocation = i;
            }
            ++i;
        }
        return (long)nextLocation + ((long)idxLocation << 32);
    }

    public static void processSeparator(String text, STextCharTypes charTypes, STextOffsets offsets, int separLocation) {
        int len = text.length();
        int direction = charTypes.getDirection();
        if (direction == 1) {
            int i = separLocation - 1;
            while (i >= 0) {
                byte charType = charTypes.getBidiTypeAt(i);
                if (charType == 1 || charType == 2) {
                    return;
                }
                if (charType == 0) {
                    int j = separLocation;
                    while (j < len) {
                        charType = charTypes.getBidiTypeAt(j);
                        if (charType == 1 || charType == 2) {
                            return;
                        }
                        if (charType == 0 || charType == 3) {
                            offsets.insertOffset(charTypes, separLocation);
                            return;
                        }
                        ++j;
                    }
                    return;
                }
                --i;
            }
            return;
        }
        boolean doneAN = false;
        int i = separLocation - 1;
        while (i >= 0) {
            int j;
            byte charType = charTypes.getBidiTypeAt(i);
            if (charType == 0) {
                return;
            }
            if (charType == 1 || charType == 2) {
                j = separLocation;
                while (j < len) {
                    charType = charTypes.getBidiTypeAt(j);
                    if (charType == 0) {
                        return;
                    }
                    if (charType == 1 || charType == 3 || charType == 2 || charType == 6) {
                        offsets.insertOffset(charTypes, separLocation);
                        return;
                    }
                    ++j;
                }
                return;
            }
            if (charType == 6 && !doneAN) {
                j = separLocation;
                while (j < len) {
                    charType = charTypes.getBidiTypeAt(j);
                    if (charType == 0) {
                        return;
                    }
                    if (charType == 2 || charType == 6 || charType == 1) {
                        offsets.insertOffset(charTypes, separLocation);
                        return;
                    }
                    ++j;
                }
                doneAN = true;
            }
            --i;
        }
    }

    public String leanToFullText(String text) {
        int len = text.length();
        if (len == 0) {
            return text;
        }
        STextCharTypes charTypes = new STextCharTypes(this, text);
        STextOffsets offsets = this.leanToFullCommon(text, charTypes);
        int prefixLength = offsets.getPrefixLength();
        int direction = charTypes.getDirection();
        return this.insertMarks(text, offsets.getOffsets(), direction, prefixLength);
    }

    public int[] leanToFullMap(String text) {
        int len = text.length();
        if (len == 0) {
            return EMPTY_INT_ARRAY;
        }
        STextCharTypes charTypes = new STextCharTypes(this, text);
        STextOffsets offsets = this.leanToFullCommon(text, charTypes);
        int prefixLength = offsets.getPrefixLength();
        int[] map = new int[len];
        int count = offsets.getCount();
        int added = prefixLength;
        int pos = 0;
        int i = 0;
        while (pos < len) {
            if (i < count && pos == offsets.getOffset(i)) {
                ++added;
                ++i;
            }
            map[pos] = pos + added;
            ++pos;
        }
        return map;
    }

    public int[] leanBidiCharOffsets(String text) {
        int len = text.length();
        if (len == 0) {
            return EMPTY_INT_ARRAY;
        }
        STextCharTypes charTypes = new STextCharTypes(this, text);
        STextOffsets offsets = this.leanToFullCommon(text, charTypes);
        return offsets.getOffsets();
    }

    private STextOffsets leanToFullCommon(String text, STextCharTypes charTypes) {
        int prefixLength;
        int orientation;
        int len = text.length();
        int direction = this.handler.getDirection(this, text, charTypes);
        STextOffsets offsets = new STextOffsets();
        if (!this.handler.skipProcessing(this, text, charTypes)) {
            long res;
            int nextLocation;
            int separCount = this.handler.getSeparators(this).length();
            int[] locations = new int[separCount + this.handler.getSpecialsCount(this)];
            int i = 0;
            int k = locations.length;
            while (i < k) {
                locations[i] = -1;
                ++i;
            }
            int curPos = 0;
            if (this.state != null) {
                curPos = this.handler.processSpecial(this, text, charTypes, offsets, 0, -1);
            }
            while ((nextLocation = (int)((res = this.computeNextLocation(text, charTypes, offsets, locations, curPos)) & 0xFFFFFFFFFFFFFFFFL)) < len) {
                int idxLocation = (int)(res >> 32);
                if (idxLocation < separCount) {
                    STextImpl.processSeparator(text, charTypes, offsets, nextLocation);
                    curPos = nextLocation + 1;
                } else {
                    curPos = this.handler.processSpecial(this, text, charTypes, offsets, idxLocation -= separCount - 1, nextLocation);
                }
                if (curPos < len) continue;
            }
        }
        if ((orientation = this.environment.getOrientation()) == 8) {
            prefixLength = 0;
        } else {
            int resolvedOrientation = charTypes.resolveOrientation();
            prefixLength = orientation != 4 && resolvedOrientation == direction ? 0 : ((orientation & 2) != 0 ? 1 : 2);
        }
        offsets.setPrefixLength(prefixLength);
        return offsets;
    }

    public String fullToLeanText(String full) {
        char c;
        if (full.length() == 0) {
            return full;
        }
        int dir = this.handler.getDirection(this, full);
        char curMark = MARKS[dir];
        char curEmbed = EMBEDS[dir];
        int lenFull = full.length();
        int i = 0;
        while (i < lenFull) {
            c = full.charAt(i);
            if (c != curEmbed && c != curMark) break;
            ++i;
        }
        if (i > 0) {
            full = full.substring(i);
            lenFull = full.length();
        }
        i = lenFull - 1;
        while (i >= 0) {
            c = full.charAt(i);
            if (c != '\u202c' && c != curMark) break;
            --i;
        }
        if (i < 0) {
            return EMPTY_STRING;
        }
        if (i < lenFull - 1) {
            full = full.substring(0, i + 1);
            lenFull = full.length();
        }
        char[] chars = full.toCharArray();
        int cnt = 0;
        i = 0;
        while (i < lenFull) {
            char c2 = chars[i];
            if (c2 == curMark) {
                ++cnt;
            } else if (cnt > 0) {
                chars[i - cnt] = c2;
            }
            ++i;
        }
        String lean = new String(chars, 0, lenFull - cnt);
        String full2 = this.leanToFullText(lean);
        int beginIndex = 0;
        int endIndex = full2.length();
        if (full2.charAt(0) == curMark) {
            beginIndex = 1;
        } else {
            if (full2.charAt(0) == curEmbed) {
                beginIndex = 1;
                if (full2.charAt(0) == curMark) {
                    beginIndex = 2;
                }
            }
            if (full2.charAt(endIndex - 1) == '\u202c' && full2.charAt(--endIndex - 1) == curMark) {
                --endIndex;
            }
        }
        if (beginIndex > 0 || endIndex < full2.length()) {
            full2 = full2.substring(beginIndex, endIndex);
        }
        if (full2.equals(full)) {
            return lean;
        }
        char[] newChars = new char[lenFull];
        int lenFull2 = full2.length();
        int newCharsPos = 0;
        int idxLean = 0;
        int idxFull2 = 0;
        int idxFull = 0;
        while (idxFull < lenFull && idxFull2 < lenFull2) {
            char cFull;
            char cFull2 = full2.charAt(idxFull2);
            if (cFull2 == (cFull = full.charAt(idxFull))) {
                if (cFull2 != curMark) {
                    newChars[newCharsPos++] = chars[idxLean++];
                }
                ++idxFull;
                ++idxFull2;
                continue;
            }
            if (cFull2 == curMark) {
                ++idxFull2;
                continue;
            }
            if (cFull == curMark) {
                if (full.charAt(++idxFull - 2) == curMark) continue;
                newChars[newCharsPos++] = curMark;
                continue;
            }
            throw new IllegalStateException("Internal error: extra character not a Mark.");
        }
        if (idxFull < lenFull) {
            throw new IllegalStateException("Internal error: unexpected EOL.");
        }
        lean = new String(newChars, 0, newCharsPos);
        return lean;
    }

    public int[] fullToLeanMap(String full) {
        int lenFull = full.length();
        if (lenFull == 0) {
            return EMPTY_INT_ARRAY;
        }
        String lean = this.fullToLeanText(full);
        int lenLean = lean.length();
        int dir = this.handler.getDirection(this, lean);
        char curMark = MARKS[dir];
        char curEmbed = EMBEDS[dir];
        int[] map = new int[lenFull];
        int idxFull = 0;
        while (idxFull < lenFull) {
            char c = full.charAt(idxFull);
            if (c != curEmbed && c != curMark) break;
            map[idxFull] = -1;
            ++idxFull;
        }
        int idxLean = 0;
        while (idxLean < lenLean) {
            map[idxFull] = full.charAt(idxFull) == lean.charAt(idxLean) ? idxLean++ : -1;
            ++idxFull;
        }
        while (idxFull < lenFull) {
            map[idxFull] = -1;
            ++idxFull;
        }
        return map;
    }

    public int[] fullBidiCharOffsets(String full) {
        int lenFull = full.length();
        if (lenFull == 0) {
            return EMPTY_INT_ARRAY;
        }
        String lean = this.fullToLeanText(full);
        STextOffsets offsets = new STextOffsets();
        int lenLean = lean.length();
        int idxFull = 0;
        int idxLean = 0;
        while (idxLean < lenLean) {
            if (full.charAt(idxFull) == lean.charAt(idxLean)) {
                ++idxLean;
            } else {
                offsets.insertOffset(null, idxFull);
            }
            ++idxFull;
        }
        while (idxFull < lenFull) {
            offsets.insertOffset(null, idxFull);
            ++idxFull;
        }
        return offsets.getOffsets();
    }

    public String insertMarks(String text, int[] offsets, int direction, int affixLength) {
        int count;
        if (direction != 0 && direction != 1) {
            throw new IllegalArgumentException("Invalid direction");
        }
        if (affixLength < 0 || affixLength > 2) {
            throw new IllegalArgumentException("Invalid affix length");
        }
        int n = count = offsets == null ? 0 : offsets.length;
        if (count == 0 && affixLength == 0) {
            return text;
        }
        int textLength = text.length();
        if (textLength == 0) {
            return text;
        }
        int newLen = textLength + count;
        if (affixLength == 1) {
            ++newLen;
        } else if (affixLength == 2) {
            newLen += 4;
        }
        char[] fullChars = new char[newLen];
        int added = affixLength;
        char curMark = MARKS[direction];
        int i = 0;
        int j = 0;
        while (i < textLength) {
            char c = text.charAt(i);
            if (j < count && i == offsets[j]) {
                fullChars[i + added] = curMark;
                ++added;
                ++j;
            }
            fullChars[i + added] = c;
            ++i;
        }
        if (affixLength > 0) {
            if (affixLength == 1) {
                fullChars[0] = curMark;
            } else {
                char curEmbed;
                fullChars[0] = curEmbed = EMBEDS[direction];
                fullChars[1] = curMark;
                fullChars[newLen - 1] = 8236;
                fullChars[newLen - 2] = curMark;
            }
        }
        return new String(fullChars);
    }
}

