/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.parser;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestVisitor;
import org.eclipse.koneki.ldt.parser.LuaASTUtils;
import org.eclipse.koneki.ldt.parser.api.external.FunctionTypeDef;
import org.eclipse.koneki.ldt.parser.api.external.Item;
import org.eclipse.koneki.ldt.parser.api.external.LuaFileAPI;
import org.eclipse.koneki.ldt.parser.api.external.Parameter;
import org.eclipse.koneki.ldt.parser.api.external.RecordTypeDef;
import org.eclipse.koneki.ldt.parser.api.external.TypeDef;
import org.eclipse.koneki.ldt.parser.ast.Block;

public class LuaSourceElementRequestorVisitor
extends SourceElementRequestVisitor {
    private LuaFileAPI luafileapi = null;
    private Block firstBlock = null;

    public LuaSourceElementRequestorVisitor(ISourceElementRequestor requesor) {
        super((IElementRequestor)requesor);
    }

    public boolean visit(ASTNode s) throws Exception {
        if (s instanceof Item) {
            return this.visit((Item)s);
        }
        if (s instanceof RecordTypeDef) {
            return this.visit((RecordTypeDef)s);
        }
        if (s instanceof LuaFileAPI) {
            return this.visit((LuaFileAPI)s);
        }
        if (s instanceof Block) {
            return this.visit((Block)s);
        }
        return super.visit(s);
    }

    public boolean endvisit(ASTNode s) throws Exception {
        if (s instanceof RecordTypeDef) {
            return this.endvisit((RecordTypeDef)s);
        }
        if (s instanceof LuaFileAPI) {
            return this.endvisit((LuaFileAPI)s);
        }
        return super.endvisit(s);
    }

    public boolean visit(LuaFileAPI luaAPI) throws Exception {
        this.luafileapi = luaAPI;
        return true;
    }

    public boolean endvisit(LuaFileAPI luaAPI) throws Exception {
        this.luafileapi = null;
        return true;
    }

    public boolean visit(Block block) throws Exception {
        if (this.firstBlock == null) {
            this.firstBlock = block;
            return true;
        }
        return false;
    }

    public boolean visit(Item item) throws Exception {
        TypeDef resolvedType = LuaASTUtils.resolveTypeLocaly(this.luafileapi, item);
        if (resolvedType instanceof FunctionTypeDef) {
            IElementRequestor.MethodInfo methodInfo = new IElementRequestor.MethodInfo();
            FunctionTypeDef funtionTypeDef = (FunctionTypeDef)resolvedType;
            List<Parameter> params = funtionTypeDef.getParameters();
            String[] parametersName = new String[params.size()];
            int i = 0;
            while (i < params.size()) {
                Parameter param = params.get(i);
                parametersName[i] = param.getName();
                ++i;
            }
            methodInfo.name = item.getName();
            methodInfo.parameterNames = parametersName;
            methodInfo.nameSourceStart = item.sourceStart();
            methodInfo.nameSourceEnd = item.sourceEnd();
            methodInfo.declarationStart = item.sourceStart();
            int modifiers = 0;
            if (LuaASTUtils.isLocal(item)) {
                modifiers |= 0x10;
            } else if (LuaASTUtils.isModuleTypeField(this.luafileapi, item)) {
                modifiers |= 0x400;
            } else if (LuaASTUtils.isGlobal(item) || LuaASTUtils.isTypeField(item)) {
                modifiers |= 0x40;
            }
            methodInfo.modifiers = modifiers;
            this.fRequestor.enterMethod(methodInfo);
            int declarationEnd = item.sourceEnd();
            this.fRequestor.exitMethod(declarationEnd);
            return true;
        }
        IElementRequestor.FieldInfo fieldinfo = new IElementRequestor.FieldInfo();
        fieldinfo.name = item.getName();
        fieldinfo.nameSourceStart = item.sourceStart();
        fieldinfo.nameSourceEnd = item.sourceEnd();
        fieldinfo.declarationStart = item.sourceStart();
        int modifiers = 0;
        if (LuaASTUtils.isLocal(item)) {
            modifiers |= 0x10;
        } else if (LuaASTUtils.isModuleTypeField(this.luafileapi, item)) {
            modifiers |= 0x400;
        } else if (LuaASTUtils.isGlobal(item) || LuaASTUtils.isTypeField(item)) {
            modifiers |= 0x40;
        }
        fieldinfo.modifiers = modifiers;
        this.fRequestor.enterField(fieldinfo);
        int declarationEnd = item.sourceEnd();
        this.fRequestor.exitField(declarationEnd);
        return true;
    }

    public boolean visit(RecordTypeDef type) throws Exception {
        RecordTypeDef recordtype = type;
        IElementRequestor.TypeInfo typeinfo = new IElementRequestor.TypeInfo();
        typeinfo.name = recordtype.getName();
        typeinfo.declarationStart = type.sourceStart();
        typeinfo.nameSourceStart = type.sourceStart();
        typeinfo.nameSourceEnd = type.sourceEnd();
        int modifiers = 0;
        modifiers = LuaASTUtils.isModule(this.luafileapi, recordtype) ? (modifiers |= 0x400) : (modifiers |= 0x40);
        typeinfo.modifiers = modifiers;
        this.fRequestor.enterType(typeinfo);
        return true;
    }

    public boolean endvisit(RecordTypeDef type) throws Exception {
        int declarationEnd = type.sourceEnd();
        this.fRequestor.exitType(declarationEnd);
        return true;
    }
}

