/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.tweaklets.PreferencePageEnhancer;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.internal.util.PrefUtil;

public class ViewsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IThemeEngine engine;
    private ComboViewer themeIdCombo;
    private ITheme currentTheme;
    private String defaultTheme;
    private Button enableAnimations;

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0).setText(WorkbenchMessages.ViewsPreferencePage_Theme);
        this.themeIdCombo = new ComboViewer(comp, 8);
        this.themeIdCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ITheme)element).getLabel();
            }
        });
        this.themeIdCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.themeIdCombo.setInput((Object)this.engine.getThemes());
        this.themeIdCombo.getControl().setLayoutData((Object)new GridData(768));
        this.currentTheme = this.engine.getActiveTheme();
        this.themeIdCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentTheme));
        this.themeIdCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITheme selection = ViewsPreferencePage.this.getSelection();
                ViewsPreferencePage.this.engine.setTheme(selection, false);
                ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).setSelection(selection);
            }
        });
        this.createEnableAnimationsPref(comp);
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).setSelection(this.currentTheme);
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).createContents(comp);
        return comp;
    }

    private Button createCheckButton(Composite composite, String text, boolean selection) {
        Button button = new Button(composite, 32);
        GridData data = new GridData(1, 0x1000000, false, false, 2, 1);
        button.setLayoutData((Object)data);
        button.setText(text);
        button.setSelection(selection);
        return button;
    }

    protected void createEnableAnimationsPref(Composite composite) {
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.enableAnimations = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_enableAnimations, apiStore.getBoolean("ENABLE_ANIMATIONS"));
    }

    private ITheme getSelection() {
        return (ITheme)((IStructuredSelection)this.themeIdCombo.getSelection()).getFirstElement();
    }

    public void init(IWorkbench workbench) {
        MApplication application = (MApplication)workbench.getService(MApplication.class);
        IEclipseContext context = application.getContext();
        this.defaultTheme = (String)context.get("cssTheme");
        this.engine = (IThemeEngine)context.get(IThemeEngine.class);
    }

    public boolean performOk() {
        this.engine.setTheme(this.getSelection(), true);
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        apiStore.setValue("ENABLE_ANIMATIONS", this.enableAnimations.getSelection());
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).performOK();
        return super.performOk();
    }

    protected void performDefaults() {
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).performDefaults();
        this.engine.setTheme(this.defaultTheme, true);
        this.themeIdCombo.setSelection((ISelection)new StructuredSelection((Object)this.engine.getActiveTheme()));
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.enableAnimations.setSelection(apiStore.getDefaultBoolean("ENABLE_ANIMATIONS"));
        super.performDefaults();
    }

    public boolean performCancel() {
        this.engine.setTheme(this.currentTheme, false);
        return super.performCancel();
    }
}

