/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.di.ObjectDescriptor;
import org.eclipse.e4.core.internal.di.Requestor;

public class MethodRequestor
extends Requestor {
    private final Method method;
    private static Map<Method, Annotation[][]> annotationCache = new WeakHashMap<Method, Annotation[][]>();

    public MethodRequestor(Method method, IInjector injector, PrimaryObjectSupplier primarySupplier, PrimaryObjectSupplier tempSupplier, Object requestingObject, boolean track) {
        super(method, injector, primarySupplier, tempSupplier, requestingObject, track);
        this.method = method;
    }

    public Object execute() throws InjectionException {
        if (this.actualArgs == null && this.method.getParameterTypes().length > 0) {
            return null;
        }
        Object userObject = this.getRequestingObject();
        if (userObject == null) {
            return null;
        }
        Object result = null;
        boolean wasAccessible = true;
        if (!this.method.isAccessible()) {
            this.method.setAccessible(true);
            wasAccessible = false;
        }
        boolean pausedRecording = false;
        if (this.primarySupplier != null) {
            this.primarySupplier.pauseRecording();
            pausedRecording = true;
        }
        try {
            try {
                result = this.method.invoke(userObject, this.actualArgs);
            }
            catch (IllegalArgumentException e) {
                throw new InjectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new InjectionException(e);
            }
            catch (InvocationTargetException e) {
                Throwable originalException = e.getCause();
                throw new InjectionException(originalException != null ? originalException : e);
            }
        }
        finally {
            if (!wasAccessible) {
                this.method.setAccessible(false);
            }
            if (pausedRecording) {
                this.primarySupplier.resumeRecording();
            }
            this.clearResolvedArgs();
        }
        return result;
    }

    protected IObjectDescriptor[] calcDependentObjects() {
        Type[] parameterTypes = this.method.getGenericParameterTypes();
        Annotation[][] annotations = this.getParameterAnnotations();
        IObjectDescriptor[] descriptors = new IObjectDescriptor[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            descriptors[i] = new ObjectDescriptor(parameterTypes[i], annotations[i]);
            ++i;
        }
        return descriptors;
    }

    private Annotation[][] getParameterAnnotations() {
        Annotation[][] result = annotationCache.get(this.method);
        if (result == null) {
            result = this.method.getParameterAnnotations();
            annotationCache.put(this.method, result);
        }
        return result;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        Object object = this.getRequestingObject();
        if (object != null) {
            tmp.append(object.getClass().getSimpleName());
        }
        tmp.append('#');
        tmp.append(this.method.getName());
        tmp.append('(');
        tmp.append(')');
        return tmp.toString();
    }
}

