/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.wizards.pages;

import java.util.List;
import java.util.Observable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.koneki.ldt.core.buildpath.LuaExecutionEnvironment;
import org.eclipse.koneki.ldt.core.buildpath.LuaExecutionEnvironmentManager;
import org.eclipse.koneki.ldt.wizards.pages.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class LuaExecutionEnvironmentGroup
extends Observable {
    private final ComboViewer installedEEsComboViewer;
    private boolean isListAvailable = false;
    private ISelection selection;
    private final Button eeButton;
    private final Button noEEButton;
    private final SelectionListener eeChoiceListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (LuaExecutionEnvironmentGroup.this.eeButton.getSelection()) {
                LuaExecutionEnvironmentGroup.this.isListAvailable = true;
            } else if (LuaExecutionEnvironmentGroup.this.noEEButton.getSelection()) {
                LuaExecutionEnvironmentGroup.this.isListAvailable = false;
            }
            LuaExecutionEnvironmentGroup.this.installedEEsComboViewer.getCombo().setEnabled(LuaExecutionEnvironmentGroup.this.isListAvailable);
        }
    };

    public LuaExecutionEnvironmentGroup(final Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.LuaExecutionEnvironmentGroupTitle);
        GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)group);
        this.noEEButton = new Button((Composite)group, 16);
        this.noEEButton.setText(Messages.LuaExecutionEnvironmentGroupNoEEForProjectCreation);
        this.noEEButton.setSelection(true);
        this.noEEButton.addSelectionListener(this.eeChoiceListener);
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.noEEButton);
        this.eeButton = new Button((Composite)group, 16);
        this.eeButton.setText(Messages.LuaExecutionEnvironmentGroupSelectEE);
        this.eeButton.addSelectionListener(this.eeChoiceListener);
        this.installedEEsComboViewer = new ComboViewer((Composite)group, 2056);
        this.installedEEsComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.updateExecutionEnvironmentList();
        this.installedEEsComboViewer.getCombo().setEnabled(this.isListAvailable);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo(this.installedEEsComboViewer.getControl());
        Link link = new Link((Composite)group, 0);
        link.setFont(group.getFont());
        link.setText("<a>" + Messages.LuaExecutionEnvironmentGroupManageExecutionEnvironment + "</a>");
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).applyTo((Control)link);
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.koneki.ldt.ui.executionenvironmentpreferencepage", (String[])new String[]{"org.eclipse.koneki.ldt.ui.executionenvironmentpreferencepage"}, null).open();
                LuaExecutionEnvironmentGroup.this.updateExecutionEnvironmentList();
            }
        });
    }

    public LuaExecutionEnvironment getSelectedLuaExecutionEnvironment() {
        if (this.isListAvailable) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (LuaExecutionEnvironmentGroup.this.installedEEsComboViewer != null) {
                        LuaExecutionEnvironmentGroup.this.selection = LuaExecutionEnvironmentGroup.this.installedEEsComboViewer.getSelection();
                    } else {
                        LuaExecutionEnvironmentGroup.this.selection = null;
                    }
                }
            });
            if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
                return (LuaExecutionEnvironment)((IStructuredSelection)this.selection).getFirstElement();
            }
        }
        return null;
    }

    private void updateExecutionEnvironmentList() {
        if (this.installedEEsComboViewer != null) {
            List installedExecutionEnvironments = LuaExecutionEnvironmentManager.getInstalledExecutionEnvironments();
            this.installedEEsComboViewer.setInput((Object)installedExecutionEnvironments);
            if (installedExecutionEnvironments.size() > 0) {
                this.installedEEsComboViewer.setSelection((ISelection)new StructuredSelection(installedExecutionEnvironments.get(0)));
            }
            this.setChanged();
            this.notifyObservers();
        }
    }
}

