/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.ui.internal.interpreters;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.LazyFileHandle;
import org.eclipse.dltk.internal.debug.ui.interpreters.AbstractInterpreterLibraryBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.AddScriptInterpreterDialog;
import org.eclipse.dltk.internal.debug.ui.interpreters.IAddInterpreterDialogRequestor;
import org.eclipse.dltk.internal.debug.ui.interpreters.IScriptInterpreterDialog;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.koneki.ldt.debug.core.IEmbeddedInterpreterInstallType;
import org.eclipse.koneki.ldt.debug.core.internal.interpreter.generic.LuaGenericInterpreterInstallType;
import org.eclipse.koneki.ldt.debug.ui.internal.interpreters.LuaInterpreterEnvironmentVariablesBlock;
import org.eclipse.koneki.ldt.ui.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddLuaInterpreterDialog
extends StatusDialog
implements IScriptInterpreterDialog {
    private IAddInterpreterDialogRequestor requestor;
    private IEnvironment environment;
    private IInterpreterInstall currentInterperter;
    private IInterpreterInstallType[] interpreterInstallTypes;
    private ComboViewer typesCombo;
    private Text nameText;
    private Text pathText;
    private Button browseButton;
    private Text argsText;
    private LuaInterpreterEnvironmentVariablesBlock environementVariableBlock;

    public AddLuaInterpreterDialog(IAddInterpreterDialogRequestor requestor, Shell shell, IEnvironment environment, IInterpreterInstallType[] interpreterInstallTypes, IInterpreterInstall standin) {
        super(shell);
        this.requestor = requestor;
        this.environment = environment;
        this.currentInterperter = standin;
        this.interpreterInstallTypes = interpreterInstallTypes;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        Point margin = new Point(0, 0);
        margin.x = this.convertHorizontalDLUsToPixels(7);
        margin.y = this.convertVerticalDLUsToPixels(7);
        Point spacing = new Point(0, 0);
        spacing.x = this.convertHorizontalDLUsToPixels(7);
        spacing.y = this.convertVerticalDLUsToPixels(4);
        GridLayoutFactory.swtDefaults().spacing(spacing).margins(margin).numColumns(3).applyTo(container);
        GridDataFactory.swtDefaults().grab(true, true).align(4, 4).applyTo((Control)container);
        this.createLabel(container, InterpretersMessages.addInterpreterDialog_InterpreterEnvironmentType);
        this.typesCombo = new ComboViewer(container);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).span(2, 1).applyTo(this.typesCombo.getControl());
        this.createLabel(container, InterpretersMessages.addInterpreterDialog_InterpreterExecutableName);
        this.pathText = new Text(container, 2052);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).hint(300, -1).applyTo((Control)this.pathText);
        this.browseButton = new Button(container, 8);
        this.browseButton.setText(InterpretersMessages.addInterpreterDialog_browse1);
        GridDataFactory.swtDefaults().hint(SWTUtil.getButtonWidthHint((Button)this.browseButton), -1).applyTo((Control)this.browseButton);
        this.createLabel(container, InterpretersMessages.addInterpreterDialog_InterpreterEnvironmentName);
        this.nameText = new Text(container, 2052);
        GridDataFactory.swtDefaults().grab(true, false).span(2, 1).align(4, 0x1000000).applyTo((Control)this.nameText);
        this.createLabel(container, InterpretersMessages.AddInterpreterDialog_iArgs);
        this.argsText = new Text(container, 2052);
        GridDataFactory.swtDefaults().grab(true, false).span(2, 1).align(4, 0x1000000).applyTo((Control)this.argsText);
        this.environementVariableBlock = new LuaInterpreterEnvironmentVariablesBlock(new AddInterpreterDialogAdapter(this.requestor, this.getShell(), this.interpreterInstallTypes, this.currentInterperter));
        Composite environementComposite = (Composite)this.environementVariableBlock.createControl(container);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(environementComposite);
        GridDataFactory.swtDefaults().grab(true, true).span(3, 1).align(4, 4).applyTo((Control)environementComposite);
        AddLuaInterpreterDialog.applyDialogFont((Control)container);
        this.hookListeners();
        this.init();
        return container;
    }

    private void createLabel(Composite container, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridDataFactory.swtDefaults().applyTo((Control)label);
    }

    private void hookListeners() {
        this.typesCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddLuaInterpreterDialog.this.updateOnInterpreterTypeChange();
            }
        });
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AddLuaInterpreterDialog.this.browseForInstallation();
            }
        });
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddLuaInterpreterDialog.this.updateStatusLine();
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddLuaInterpreterDialog.this.updateStatusLine();
            }
        });
    }

    private void init() {
        this.typesCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typesCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IInterpreterInstallType) {
                    return ((IInterpreterInstallType)element).getName();
                }
                return super.getText(element);
            }
        });
        this.typesCombo.setInput((Object)this.interpreterInstallTypes);
        this.typesCombo.getControl().setEnabled(this.currentInterperter == null);
        if (this.currentInterperter != null) {
            this.typesCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentInterperter.getInterpreterInstallType()));
            this.updateOnInterpreterTypeChange();
            if (this.currentInterperter.getInstallLocation().length() > 0L) {
                this.pathText.setText(this.currentInterperter.getInstallLocation().toOSString());
            }
            this.nameText.setText(this.currentInterperter.getName());
            String args = this.currentInterperter.getInterpreterArgs();
            if (args != null) {
                this.argsText.setText(args);
            }
            this.environementVariableBlock.initializeFrom(this.currentInterperter, this.currentInterperter.getInterpreterInstallType());
        } else {
            IInterpreterInstallType[] iInterpreterInstallTypeArray = this.interpreterInstallTypes;
            int n = this.interpreterInstallTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IInterpreterInstallType type = iInterpreterInstallTypeArray[n2];
                if (type instanceof LuaGenericInterpreterInstallType && this.typesCombo.getSelection().isEmpty()) {
                    this.typesCombo.setSelection((ISelection)new StructuredSelection((Object)type));
                }
                ++n2;
            }
        }
        this.environementVariableBlock.update();
    }

    private void updateOnInterpreterTypeChange() {
        IInterpreterInstallType selectedType = this.getSelectedInterpreterType();
        boolean isEmbedded = selectedType instanceof IEmbeddedInterpreterInstallType;
        this.pathText.setEnabled(!isEmbedded);
        this.browseButton.setEnabled(!isEmbedded);
        String embeddedPathValue = "(Embedded)";
        if (isEmbedded) {
            this.pathText.setText(embeddedPathValue);
        } else if (embeddedPathValue.equals(this.pathText.getText())) {
            this.pathText.setText("");
        } else if (this.currentInterperter != null) {
            this.pathText.setText(this.currentInterperter.getInstallLocation().toOSString());
        }
    }

    private IInterpreterInstallType getSelectedInterpreterType() {
        return (IInterpreterInstallType)((IStructuredSelection)this.typesCombo.getSelection()).getFirstElement();
    }

    private void browseForInstallation() {
        IEnvironmentUI environmentUI = (IEnvironmentUI)this.environment.getAdapter(IEnvironmentUI.class);
        if (environmentUI != null) {
            String defaultPath = this.currentInterperter != null ? this.currentInterperter.getInstallLocation().toOSString() : null;
            String newPath = environmentUI.selectFile(this.getShell(), 1, defaultPath);
            if (newPath != null) {
                this.pathText.setText(newPath);
            }
        }
    }

    protected void okPressed() {
        if (this.currentInterperter == null) {
            IInterpreterInstallType selectedType = this.getSelectedInterpreterType();
            this.currentInterperter = new InterpreterStandin(selectedType, this.createUniqueId(selectedType));
            this.setFieldValuesToInterpreter();
            this.requestor.interpreterAdded(this.currentInterperter);
        } else {
            this.setFieldValuesToInterpreter();
        }
        super.okPressed();
    }

    private String createUniqueId(IInterpreterInstallType interpreterType) {
        String id = null;
        while (interpreterType.findInterpreterInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    protected void setFieldValuesToInterpreter() {
        this.currentInterperter.setInstallLocation((IFileHandle)new LazyFileHandle(this.environment.getId(), (IPath)new Path(this.pathText.getText().trim())));
        this.currentInterperter.setName(this.nameText.getText().trim());
        String argString = this.argsText.getText().trim();
        if (argString != null && argString.length() > 0) {
            this.currentInterperter.setInterpreterArgs(argString);
        } else {
            this.currentInterperter.setInterpreterArgs(null);
        }
        this.environementVariableBlock.performApply(this.currentInterperter);
    }

    public boolean execute() {
        return this.open() == 0;
    }

    public void updateStatusLine() {
        String path = this.pathText.getText().trim();
        if (path.isEmpty()) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.koneki.ldt.debug.ui", InterpretersMessages.addInterpreterDialog_enterLocation));
        } else {
            String name = this.nameText.getText().trim();
            if (name.isEmpty()) {
                this.updateStatus((IStatus)new Status(4, "org.eclipse.koneki.ldt.debug.ui", InterpretersMessages.addInterpreterDialog_enterName));
            } else if (this.requestor.isDuplicateName(name, this.currentInterperter)) {
                this.updateStatus((IStatus)new Status(4, "org.eclipse.koneki.ldt.debug.ui", InterpretersMessages.addInterpreterDialog_duplicateName));
            } else {
                this.updateStatus(Status.OK_STATUS);
            }
        }
    }

    public void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
    }

    private class AddInterpreterDialogAdapter
    extends AddScriptInterpreterDialog {
        public AddInterpreterDialogAdapter(IAddInterpreterDialogRequestor requestor, Shell shell, IInterpreterInstallType[] interpreterInstallTypes, IInterpreterInstall editedInterpreter) {
            super(requestor, shell, interpreterInstallTypes, editedInterpreter);
        }

        protected AbstractInterpreterLibraryBlock createLibraryBlock(AddScriptInterpreterDialog dialog) {
            return null;
        }

        public IEnvironment getEnvironment() {
            return AddLuaInterpreterDialog.this.environment;
        }

        public void updateLibraries(EnvironmentVariable[] newVars, EnvironmentVariable[] oldVars) {
        }

        protected void updateValidateInterpreterLocation() {
        }

        public Shell getShell() {
            return AddLuaInterpreterDialog.this.getShell();
        }

        public void updateStatusLine() {
            AddLuaInterpreterDialog.this.updateStatusLine();
        }

        public void setSystemLibraryStatus(IStatus status) {
        }

        public void setButtonLayoutData(Button button) {
            AddLuaInterpreterDialog.this.setButtonLayoutData(button);
        }

        public int open() {
            return 0;
        }
    }
}

