/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.metalua;

import com.naef.jnlua.LuaState;
import com.naef.jnlua.eclipse.AbstractLuaModule;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.koneki.ldt.metalua.internal.MetaluaStateFactory;

public abstract class AbstractMetaLuaModule
extends AbstractLuaModule {
    protected LuaState loadLuaModule() {
        this.compileMetaluaFiles();
        return super.loadLuaModule();
    }

    public void compileMetaluaFiles() {
        LuaState newLuaState = MetaluaStateFactory.newLuaState();
        try {
            List<String> metaLuaFileToCompile = this.getMetaLuaFileToCompile();
            for (String metaluaSourcePath : this.getMetaLuaSourcePaths()) {
                File metaluaSourceFile = this.getScriptFolder(metaluaSourcePath);
                if (metaLuaFileToCompile == null || metaluaSourcePath == null) continue;
                for (String filename : metaLuaFileToCompile) {
                    AbstractMetaLuaModule.compileMetaluaFile(newLuaState, metaluaSourceFile, filename);
                }
            }
        }
        catch (IOException iOException) {
            newLuaState.close();
        }
    }

    public static void compileMetaluaFile(LuaState luastate, File folder, String fileName) throws IOException {
        File regular = new File(folder, fileName);
        if (regular.isFile() && regular.exists()) {
            String fileNameWithoutExtension = fileName.substring(0, fileName.lastIndexOf(46));
            File build = new File(folder, String.valueOf(fileNameWithoutExtension) + ".luac");
            StringBuffer command = new StringBuffer("local bin  = mlc.luafile_to_luacstring([[");
            command.append(regular.getPath());
            command.append("]]) ");
            command.append("local file = io.open([[");
            command.append(build.getPath());
            command.append("]], 'wb') file:write(bin) file:close()");
            luastate.load(command.toString(), "libraryCompilation");
            luastate.call(0, 0);
        }
    }

    protected List<String> getLuacSourcePaths() {
        return this.getMetaLuaSourcePaths();
    }

    protected LuaState createLuaState() {
        return MetaluaStateFactory.newLuaState();
    }

    protected abstract List<String> getMetaLuaSourcePaths();

    protected abstract List<String> getMetaLuaFileToCompile();

    protected abstract String getPluginID();

    protected abstract String getModuleName();
}

