/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.formatter;

import com.naef.jnlua.LuaRuntimeException;
import com.naef.jnlua.LuaState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.koneki.ldt.core.internal.Activator;
import org.eclipse.koneki.ldt.core.internal.formatter.Messages;
import org.eclipse.koneki.ldt.metalua.AbstractMetaLuaModule;

public final class LuaFormatterModule
extends AbstractMetaLuaModule {
    public static final String FORMATTER_PATH = "/script/external";
    public static final String FORMATTER_LIB_NAME = "luaformatter";
    public static final String INDENTATION_FUNTION = "indentcode";

    public String indent(String source, String delimiter, boolean indentInTable, String tabulation) {
        LuaState lua = this.loadLuaModule();
        this.pushLuaModule(lua);
        lua.getField(-1, INDENTATION_FUNTION);
        lua.pushString(source);
        lua.pushString(delimiter);
        lua.pushBoolean(indentInTable);
        lua.pushString(tabulation);
        try {
            lua.call(4, 1);
        }
        catch (LuaRuntimeException e) {
            Activator.logWarning(Messages.LuaSourceFormatIndentationError, e);
            return source;
        }
        String formattedCode = lua.toString(-1);
        lua.close();
        return formattedCode;
    }

    public String indent(String source, String delimiter, boolean indentInTable, int tabSize, int indentationSize) {
        LuaState lua = this.loadLuaModule();
        this.pushLuaModule(lua);
        lua.getField(-1, INDENTATION_FUNTION);
        lua.pushString(source);
        lua.pushString(delimiter);
        lua.pushBoolean(indentInTable);
        lua.pushInteger(tabSize);
        lua.pushInteger(indentationSize);
        try {
            lua.call(5, 1);
        }
        catch (LuaRuntimeException e) {
            Activator.logWarning(Messages.LuaSourceFormatIndentationError, e);
            return source;
        }
        String formattedCode = lua.toString(-1);
        lua.close();
        return formattedCode;
    }

    protected List<String> getLuaSourcePaths() {
        ArrayList<String> sourcepaths = new ArrayList<String>();
        sourcepaths.add(FORMATTER_PATH);
        return sourcepaths;
    }

    protected List<String> getLuacSourcePaths() {
        return null;
    }

    protected String getPluginID() {
        return "org.eclipse.koneki.ldt";
    }

    protected String getModuleName() {
        return FORMATTER_LIB_NAME;
    }

    protected List<String> getMetaLuaSourcePaths() {
        return Collections.emptyList();
    }

    protected List<String> getMetaLuaFileToCompile() {
        return Collections.emptyList();
    }
}

