/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.expressions;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class ReevaluateWatchExpressionAction
implements IObjectActionDelegate {
    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    protected IDebugElement getContext() {
        IAdaptable object = DebugUITools.getDebugContext();
        IDebugElement context = null;
        if (object instanceof IDebugElement) {
            context = (IDebugElement)object;
        } else if (object instanceof ILaunch) {
            context = ((ILaunch)object).getDebugTarget();
        }
        return context;
    }

    protected IStructuredSelection getCurrentSelection() {
        ISelection selection;
        IWorkbenchPage page = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
        if (page != null && (selection = page.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public void run(IAction action) {
        IDebugElement context = this.getContext();
        Iterator iter = this.getCurrentSelection().iterator();
        while (iter.hasNext()) {
            IWatchExpression expression = (IWatchExpression)iter.next();
            expression.setExpressionContext(context);
            if (expression.isEnabled()) continue;
            expression.evaluate();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IDebugElement debugElement = this.getContext();
        if (debugElement == null) {
            action.setEnabled(false);
        } else {
            action.setEnabled(true);
        }
    }
}

