/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.search.BasicSearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.index.MixinIndex;
import org.eclipse.dltk.core.search.matching.IMatchLocator;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.ModuleFactory;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.search.IndexSelector;
import org.eclipse.dltk.internal.core.search.LazyDLTKSearchDocument;
import org.eclipse.dltk.internal.core.util.Util;

public class DLTKSearchParticipant
extends SearchParticipant {
    private IndexSelector indexSelector;
    private boolean bOnlyMixin = false;

    public void beginSearching() {
        super.beginSearching();
        this.indexSelector = null;
    }

    public void doneSearching() {
        this.indexSelector = null;
        super.doneSearching();
    }

    public String getDescription() {
        return "DLTK";
    }

    public SearchDocument getDocument(String documentPath, IProject project) {
        return new LazyDLTKSearchDocument(documentPath, this, this.isExternal(documentPath), project);
    }

    private boolean isExternal(String documentPath) {
        Object target = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IPath)new Path(documentPath), true);
        return !(target instanceof IResource);
    }

    public void locateMatches(SearchDocument[] indexMatches, SearchPattern pattern, IDLTKSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        IMatchLocator matchLocator = this.createMatchLocator(scope.getLanguageToolkit());
        matchLocator.initialize(pattern, scope);
        matchLocator.setRequestor(requestor);
        matchLocator.setProgressMonitor((IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 95)));
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locateMatches(indexMatches);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public ISourceModule[] locateModules(SearchDocument[] indexMatches, IDLTKSearchScope scope, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return this.doLocateModules(indexMatches, scope, monitor);
    }

    private ISourceModule[] doLocateModules(SearchDocument[] searchDocuments, IDLTKSearchScope scope, IProgressMonitor progressMonitor) {
        ArrayList<ISourceModule> modules = new ArrayList<ISourceModule>(searchDocuments.length);
        int docsLength = searchDocuments.length;
        if (BasicSearchEngine.VERBOSE) {
            System.out.println("Locating matches in documents [");
            int i = 0;
            while (i < docsLength) {
                System.out.println("\t" + searchDocuments[i]);
                ++i;
            }
            System.out.println("]");
        }
        int n = docsLength < 1000 ? Math.min(Math.max(docsLength / 200 + 1, 2), 4) : 5 * (docsLength / 1000);
        int progressStep = docsLength < n ? 1 : docsLength / n;
        int progressWorked = 0;
        ModuleFactory moduleFactory = new ModuleFactory(scope);
        if (progressMonitor != null) {
            progressMonitor.beginTask("", searchDocuments.length);
        }
        Util.sort(searchDocuments, new Util.Comparer(){

            public int compare(Object a, Object b) {
                return ((SearchDocument)a).getPath().compareTo(((SearchDocument)b).getPath());
            }
        });
        HashSet<String> previousPaths = new HashSet<String>();
        int i = 0;
        while (i < docsLength) {
            ISourceModule openable;
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (progressMonitor != null && ++progressWorked % progressStep == 0) {
                progressMonitor.worked(progressStep);
            }
            SearchDocument searchDocument = searchDocuments[i];
            searchDocuments[i] = null;
            if (previousPaths.add(searchDocument.getPath()) && (openable = moduleFactory.create(searchDocument)) != null) {
                modules.add(openable);
            }
            ++i;
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
        return modules.toArray(new ISourceModule[modules.size()]);
    }

    protected IMatchLocator createMatchLocator(IDLTKLanguageToolkit toolkit) {
        if (toolkit != null) {
            return DLTKLanguageManager.createMatchLocator(toolkit.getNatureId());
        }
        return new MatchLocator();
    }

    public IPath[] selectIndexes(SearchPattern pattern, IDLTKSearchScope scope) {
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(scope, pattern);
            this.indexSelector.setMixinOnly(this.bOnlyMixin);
        }
        return this.indexSelector.getIndexLocations();
    }

    public IPath[] selectMixinIndexes(SearchPattern query, IDLTKSearchScope scope) {
        this.skipNotMixin();
        return this.selectIndexes(query, scope);
    }

    public void skipNotMixin() {
        this.bOnlyMixin = true;
    }

    public boolean isSkipped(Index index) {
        boolean mixinIndex = index instanceof MixinIndex || index.containerPath.startsWith("#special#mixin#");
        return this.bOnlyMixin ^ mixinIndex;
    }
}

