/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.koneki.ldt.core.LuaUtils;
import org.eclipse.koneki.ldt.core.internal.Activator;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTModelUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.MatchNodeVisitor;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.ExprTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.ExternalTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.FunctionTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.InternalTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Item;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.LuaFileAPI;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.ModuleTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.PrimitiveTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.RecordTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Return;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.TypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.TypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaASTNode;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Block;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Call;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Identifier;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Index;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Invoke;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LocalVar;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaExpression;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaInternalContent;

public final class LuaASTUtils {
    private LuaASTUtils() {
    }

    public static Item getClosestLocalVar(LuaSourceRoot luaSourceRoot, String identifierName, int position) {
        try {
            ClosestItemVisitor closestItemVisitor = new ClosestItemVisitor(position, identifierName);
            luaSourceRoot.getInternalContent().getContent().traverse(closestItemVisitor);
            return closestItemVisitor.getResult();
        }
        catch (Exception e) {
            Activator.logError("unable to collect local var", e);
            return null;
        }
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, TypeRef typeRef) {
        if (typeRef instanceof PrimitiveTypeRef) {
            return null;
        }
        if (typeRef instanceof InternalTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (InternalTypeRef)typeRef);
        }
        if (typeRef instanceof ExternalTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (ExternalTypeRef)typeRef);
        }
        if (typeRef instanceof ModuleTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (ModuleTypeRef)typeRef);
        }
        if (typeRef instanceof ExprTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (ExprTypeRef)typeRef);
        }
        return null;
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, InternalTypeRef internalTypeRef) {
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule);
        TypeDef typeDef = luaSourceRoot.getFileapi().getTypes().get(internalTypeRef.getTypeName());
        return new TypeResolution(sourceModule, typeDef);
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, ExternalTypeRef externalTypeRef) {
        ISourceModule externalSourceModule = LuaUtils.getSourceModule(externalTypeRef.getModuleName(), sourceModule.getScriptProject());
        if (externalSourceModule == null) {
            return null;
        }
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(externalSourceModule);
        TypeDef typeDef = luaSourceRoot.getFileapi().getTypes().get(externalTypeRef.getTypeName());
        return new TypeResolution(externalSourceModule, typeDef);
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, ModuleTypeRef moduleTypeRef) {
        Return returnValues;
        ArrayList<Return> returns;
        ISourceModule referencedSourceModule = LuaUtils.getSourceModule(moduleTypeRef.getModuleName(), sourceModule.getScriptProject());
        if (referencedSourceModule == null) {
            return null;
        }
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(referencedSourceModule);
        LuaFileAPI fileapi = luaSourceRoot.getFileapi();
        if (fileapi != null && (returns = fileapi.getReturns()).size() > 0 && (returnValues = returns.get(0)).getTypes().size() > moduleTypeRef.getReturnPosition() - 1) {
            TypeRef typeRef = returnValues.getTypes().get(moduleTypeRef.getReturnPosition() - 1);
            return LuaASTUtils.resolveType(referencedSourceModule, typeRef);
        }
        return null;
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, ExprTypeRef exprTypeRef) {
        LuaExpression expression = exprTypeRef.getExpression();
        if (expression == null) {
            return null;
        }
        return LuaASTUtils.resolveType(sourceModule, expression, exprTypeRef.getReturnPosition());
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, LuaExpression expr) {
        return LuaASTUtils.resolveType(sourceModule, expr, 1);
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, LuaExpression expr, int returnposition) {
        List<TypeRef> types;
        FunctionTypeDef functiontype;
        TypeResolution resolvedFunctionType;
        RecordTypeDef recordtype;
        Item item;
        Invoke invoke;
        TypeResolution resolvedRecordType;
        if (expr instanceof Identifier) {
            Definition definition = LuaASTUtils.getDefinition(sourceModule, expr);
            if (definition == null || definition.getItem() == null || definition.getItem().getType() == null) {
                return null;
            }
            return LuaASTUtils.resolveType(definition.getModule(), definition.getItem().getType());
        }
        if (expr instanceof Index) {
            RecordTypeDef recordtype2;
            Item item2;
            Index index = (Index)expr;
            LuaExpression left = index.getLeft();
            TypeResolution resolvedLeftType = LuaASTUtils.resolveType(sourceModule, left);
            if (resolvedLeftType != null && resolvedLeftType.getTypeDef() instanceof RecordTypeDef && (item2 = (recordtype2 = (RecordTypeDef)resolvedLeftType.getTypeDef()).getFields().get(index.getRight())) != null && item2.getType() != null) {
                return LuaASTUtils.resolveType(resolvedLeftType.getModule(), item2.getType());
            }
            return null;
        }
        if (expr instanceof Call) {
            List<TypeRef> types2;
            FunctionTypeDef functiontype2;
            Call call = (Call)expr;
            TypeResolution resolvedFunctionType2 = LuaASTUtils.resolveType(sourceModule, call.getFunction());
            if (resolvedFunctionType2 != null && resolvedFunctionType2.getTypeDef() instanceof FunctionTypeDef && (functiontype2 = (FunctionTypeDef)resolvedFunctionType2.getTypeDef()).getReturns().size() > 0 && (types2 = functiontype2.getReturns().get(0).getTypes()).size() >= returnposition) {
                return LuaASTUtils.resolveType(resolvedFunctionType2.getModule(), types2.get(returnposition - 1));
            }
            return null;
        }
        if (expr instanceof Invoke && (resolvedRecordType = LuaASTUtils.resolveType(sourceModule, (invoke = (Invoke)expr).getRecord())) != null && resolvedRecordType.getTypeDef() instanceof RecordTypeDef && (item = (recordtype = (RecordTypeDef)resolvedRecordType.getTypeDef()).getFields().get(invoke.getFunctionName())) != null && item.getType() != null && (resolvedFunctionType = LuaASTUtils.resolveType(resolvedRecordType.getModule(), item.getType())) != null && resolvedFunctionType.getTypeDef() instanceof FunctionTypeDef && (functiontype = (FunctionTypeDef)resolvedFunctionType.getTypeDef()).getReturns().size() > 0 && (types = functiontype.getReturns().get(0).getTypes()).size() >= returnposition) {
            return LuaASTUtils.resolveType(resolvedFunctionType.getModule(), types.get(returnposition - 1));
        }
        return null;
    }

    public static Collection<Item> getLocalVars(LuaSourceRoot luaSourceRoot, final int offset, final String start) {
        final HashMap collectedLocalVars = new HashMap();
        ASTVisitor localvarCollector = new ASTVisitor(){

            public boolean visit(ASTNode node) throws Exception {
                if (node instanceof Block) {
                    return node.sourceStart() <= offset && offset <= node.sourceEnd();
                }
                return false;
            }

            public boolean endvisit(ASTNode node) throws Exception {
                if (node instanceof Block) {
                    List<LocalVar> localVars = ((Block)node).getLocalVars();
                    for (LocalVar localVar : localVars) {
                        Item item = localVar.getVar();
                        if (collectedLocalVars.containsKey(item.getName()) || start != null && !item.getName().toLowerCase().startsWith(start.toLowerCase())) continue;
                        collectedLocalVars.put(item.getName(), item);
                    }
                    return true;
                }
                return false;
            }
        };
        try {
            luaSourceRoot.getInternalContent().getContent().traverse(localvarCollector);
        }
        catch (Exception e) {
            Activator.logError("unable to collect local var", e);
        }
        return collectedLocalVars.values();
    }

    public static LuaExpression getLuaExpressionAt(LuaSourceRoot luaSourceRoot, int startOffset, int endOffset) {
        try {
            MatchNodeVisitor matchNodeVisitor = new MatchNodeVisitor(startOffset, endOffset, LuaExpression.class);
            luaSourceRoot.getInternalContent().getContent().traverse(matchNodeVisitor);
            return (LuaExpression)matchNodeVisitor.getNode();
        }
        catch (Exception e) {
            Activator.logError("unable to get expression at", e);
            return null;
        }
    }

    public static Definition getDefinition(ISourceModule sourceModule, LuaExpression luaExpression) {
        if (luaExpression instanceof Identifier) {
            Identifier identifier = (Identifier)luaExpression;
            if (identifier.getDefinition() != null) {
                Definition globalVarDefinition;
                Item definition = identifier.getDefinition();
                if (LuaASTUtils.isUnresolvedGlobal(definition) && (globalVarDefinition = LuaASTUtils.getGlobalVarDefinition(sourceModule, definition.getName())) != null) {
                    return globalVarDefinition;
                }
                return new Definition(sourceModule, definition);
            }
        } else if (luaExpression instanceof Index) {
            Index index = (Index)luaExpression;
            TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, index.getLeft());
            if (resolveType != null && resolveType.getTypeDef() instanceof RecordTypeDef) {
                RecordTypeDef typeDef = (RecordTypeDef)resolveType.getTypeDef();
                Item definition = typeDef.getFields().get(index.getRight());
                return new Definition(resolveType.getModule(), definition);
            }
        } else if (luaExpression instanceof Invoke) {
            Invoke invoke = (Invoke)luaExpression;
            TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, invoke.getRecord());
            if (resolveType != null && resolveType.getTypeDef() instanceof RecordTypeDef) {
                RecordTypeDef typeDef = (RecordTypeDef)resolveType.getTypeDef();
                Item definition = typeDef.getFields().get(invoke.getFunctionName());
                return new Definition(resolveType.getModule(), definition);
            }
        } else if (luaExpression instanceof Call) {
            Call call = (Call)luaExpression;
            Definition definition = LuaASTUtils.getDefinition(sourceModule, call.getFunction());
            return definition;
        }
        return null;
    }

    public static List<Definition> getAllGlobalVarsDefinition(ISourceModule sourceModule, String start) {
        ISourceModule preloadedSourceModule = LuaASTUtils.getPreloadSourceModule(sourceModule);
        if (preloadedSourceModule == null) {
            return Collections.emptyList();
        }
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(preloadedSourceModule);
        if (luaSourceRoot == null) {
            return Collections.emptyList();
        }
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        for (Item globalvar : luaSourceRoot.getFileapi().getGlobalvars().values()) {
            if (start != null && !start.isEmpty() && !globalvar.getName().toLowerCase().startsWith(start.toLowerCase())) continue;
            definitions.add(new Definition(preloadedSourceModule, globalvar));
        }
        return definitions;
    }

    public static Definition getGlobalVarDefinition(ISourceModule sourceModule, String varname) {
        ISourceModule preloadedSourceModule = LuaASTUtils.getPreloadSourceModule(sourceModule);
        if (preloadedSourceModule == null) {
            return null;
        }
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(preloadedSourceModule);
        if (luaSourceRoot == null) {
            return null;
        }
        Item item = luaSourceRoot.getFileapi().getGlobalvars().get(varname);
        if (item == null) {
            return null;
        }
        return new Definition(preloadedSourceModule, item);
    }

    public static ISourceModule getPreloadSourceModule(ISourceModule sourceModule) {
        if (sourceModule != null && sourceModule.getScriptProject() != null) {
            return LuaUtils.getSourceModule("global", sourceModule.getScriptProject());
        }
        return null;
    }

    public static boolean isLocal(Item item) {
        return item.getParent() instanceof Block;
    }

    public static boolean isGlobal(Item item) {
        return item.getParent() instanceof LuaFileAPI;
    }

    public static boolean isTypeField(Item item) {
        return item.getParent() instanceof RecordTypeDef;
    }

    public static boolean isModuleTypeField(LuaFileAPI luaFileAPI, Item item) {
        LuaASTNode parent = item.getParent();
        if (parent instanceof RecordTypeDef) {
            return LuaASTUtils.isModule(luaFileAPI, (RecordTypeDef)parent);
        }
        return false;
    }

    public static boolean isUnresolvedGlobal(Item item) {
        return item.getParent() instanceof LuaInternalContent;
    }

    public static TypeDef resolveTypeLocaly(LuaFileAPI luaFileAPI, Item item) {
        if (luaFileAPI == null) {
            return null;
        }
        TypeRef typeref = item.getType();
        if (!(typeref instanceof InternalTypeRef)) {
            return null;
        }
        InternalTypeRef internaltyperef = (InternalTypeRef)typeref;
        TypeDef typeDef = luaFileAPI.getTypes().get(internaltyperef.getTypeName());
        return typeDef;
    }

    public static boolean isModule(LuaFileAPI luaFileAPI, RecordTypeDef recordTypeDef) {
        TypeRef moduleReturnTypeRef = LuaASTUtils.getModuleReturnType(luaFileAPI);
        if (!(moduleReturnTypeRef instanceof InternalTypeRef)) {
            return false;
        }
        String typename = ((InternalTypeRef)moduleReturnTypeRef).getTypeName();
        return luaFileAPI.getTypes().get(typename) == recordTypeDef;
    }

    public static TypeRef getModuleReturnType(LuaFileAPI luaFileAPI) {
        ArrayList<Return> returns = luaFileAPI.getReturns();
        if (returns.isEmpty()) {
            return null;
        }
        Return returnValues = returns.get(0);
        if (returnValues.getTypes().isEmpty()) {
            return null;
        }
        return returnValues.getTypes().get(0);
    }

    private static class ClosestItemVisitor
    extends ASTVisitor {
        private Item result = null;
        private int position;
        private String identifierName;

        public ClosestItemVisitor(int position, String identifierName) {
            this.position = position;
            this.identifierName = identifierName;
        }

        public Item getResult() {
            return this.result;
        }

        public boolean visit(ASTNode node) throws Exception {
            if (node instanceof LocalVar) {
                return false;
            }
            if (node instanceof Block) {
                return node.sourceStart() <= this.position && this.position <= node.sourceEnd();
            }
            return false;
        }

        public boolean endvisit(ASTNode node) throws Exception {
            if (this.result == null && node instanceof Block) {
                List<LocalVar> localVars = ((Block)node).getLocalVars();
                for (LocalVar localVar : localVars) {
                    Item item = localVar.getVar();
                    if (!item.getName().equals(this.identifierName)) continue;
                    this.result = item;
                }
                return true;
            }
            return false;
        }
    }

    public static class Definition {
        private ISourceModule module;
        private Item item;

        public Definition(ISourceModule module, Item item) {
            this.module = module;
            this.item = item;
        }

        public ISourceModule getModule() {
            return this.module;
        }

        public Item getItem() {
            return this.item;
        }
    }

    public static class TypeResolution {
        private ISourceModule module;
        private TypeDef typeDef;

        public TypeResolution(ISourceModule module, TypeDef typeDef) {
            this.module = module;
            this.typeDef = typeDef;
        }

        public ISourceModule getModule() {
            return this.module;
        }

        public TypeDef getTypeDef() {
            return this.typeDef;
        }
    }
}

