/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.gogo.runtime.Closure;
import org.apache.felix.gogo.runtime.CommandProcessorImpl;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Converter;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandSessionImpl
implements CommandSession,
Converter {
    public static final String SESSION_CLOSED = "session is closed";
    public static final String VARIABLES = ".variables";
    public static final String COMMANDS = ".commands";
    private static final String COLUMN = "%-20s %s\n";
    protected InputStream in;
    protected PrintStream out;
    PrintStream err;
    private final CommandProcessorImpl processor;
    protected final Map<String, Object> variables = new HashMap<String, Object>();
    private boolean closed;

    protected CommandSessionImpl(CommandProcessorImpl shell, InputStream in, PrintStream out, PrintStream err) {
        this.processor = shell;
        this.in = in;
        this.out = out;
        this.err = err;
    }

    ThreadIO threadIO() {
        return this.processor.threadIO;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public Object execute(CharSequence commandline) throws Exception {
        assert (this.processor != null);
        assert (this.processor.threadIO != null);
        if (this.closed) {
            throw new IllegalStateException(SESSION_CLOSED);
        }
        this.processor.beforeExecute(this, commandline);
        try {
            Closure impl = new Closure(this, null, commandline);
            Object result = impl.execute(this, null);
            this.processor.afterExecute((CommandSession)this, commandline, result);
            return result;
        }
        catch (Exception e) {
            this.processor.afterExecute((CommandSession)this, commandline, e);
            throw e;
        }
    }

    @Override
    public InputStream getKeyboard() {
        return this.in;
    }

    @Override
    public Object get(String name) {
        if (name == null || VARIABLES.equals(name)) {
            return this.variables.keySet();
        }
        if (COMMANDS.equals(name)) {
            return this.processor.getCommands();
        }
        if (this.processor.constants.containsKey(name)) {
            return this.processor.constants.get(name);
        }
        if (this.variables.containsKey("#" + name)) {
            Object f = this.variables.get("#" + name);
            if (f instanceof Function) {
                try {
                    f = ((Function)f).execute(this, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return f;
        }
        if (this.variables.containsKey(name)) {
            return this.variables.get(name);
        }
        return this.processor.getCommand(name, this.variables.get("SCOPE"));
    }

    @Override
    public void put(String name, Object value) {
        this.variables.put(name, value);
    }

    @Override
    public PrintStream getConsole() {
        return this.out;
    }

    @Override
    public CharSequence format(Object target, int level, Converter escape) throws Exception {
        StringBuilder sb;
        if (target == null) {
            return "null";
        }
        if (target instanceof CharSequence) {
            return (CharSequence)target;
        }
        for (Converter converter : this.processor.converters) {
            CharSequence s = converter.format(target, level, this);
            if (s == null) continue;
            return s;
        }
        if (target.getClass().isArray()) {
            if (target.getClass().getComponentType().isPrimitive()) {
                if (target.getClass().getComponentType() == Boolean.TYPE) {
                    return Arrays.toString((boolean[])target);
                }
                if (target.getClass().getComponentType() == Byte.TYPE) {
                    return Arrays.toString((byte[])target);
                }
                if (target.getClass().getComponentType() == Short.TYPE) {
                    return Arrays.toString((short[])target);
                }
                if (target.getClass().getComponentType() == Integer.TYPE) {
                    return Arrays.toString((int[])target);
                }
                if (target.getClass().getComponentType() == Long.TYPE) {
                    return Arrays.toString((long[])target);
                }
                if (target.getClass().getComponentType() == Float.TYPE) {
                    return Arrays.toString((float[])target);
                }
                if (target.getClass().getComponentType() == Double.TYPE) {
                    return Arrays.toString((double[])target);
                }
                if (target.getClass().getComponentType() == Character.TYPE) {
                    return Arrays.toString((char[])target);
                }
            }
            target = Arrays.asList((Object[])target);
        }
        if (target instanceof Collection) {
            if (level == 0) {
                sb = new StringBuilder();
                Collection collection = (Collection)target;
                for (Object e : collection) {
                    sb.append(this.format(e, level + 1, this));
                    sb.append("\n");
                }
                return sb;
            }
            if (level == 1) {
                sb = new StringBuilder();
                Collection collection = (Collection)target;
                sb.append("[");
                for (Object object : collection) {
                    if (sb.length() > 1) {
                        sb.append(", ");
                    }
                    sb.append(this.format(object, level + 1, this));
                }
                sb.append("]");
                return sb;
            }
        }
        if (target instanceof Dictionary) {
            HashMap result = new HashMap();
            Enumeration enumeration = ((Dictionary)target).keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                result.put(key, ((Dictionary)target).get(key));
            }
            target = result;
        }
        if (target instanceof Map) {
            if (level == 0) {
                sb = new StringBuilder();
                Map map = (Map)target;
                for (Map.Entry entry : map.entrySet()) {
                    CharSequence key = this.format(entry.getKey(), level + 1, this);
                    sb.append(key);
                    for (int i = key.length(); i < 20; ++i) {
                        sb.append(' ');
                    }
                    sb.append(this.format(entry.getValue(), level + 1, this));
                    sb.append("\n");
                }
                return sb;
            }
            if (level == 1) {
                sb = new StringBuilder();
                Map map = (Map)target;
                sb.append("[");
                for (Map.Entry entry : map.entrySet()) {
                    if (sb.length() > 1) {
                        sb.append(", ");
                    }
                    sb.append(this.format(entry, level + 1, this));
                }
                sb.append("]");
                return sb;
            }
        }
        if (level == 0) {
            return this.inspect(target);
        }
        return target.toString();
    }

    CharSequence inspect(Object b) {
        Method[] methods;
        boolean found = false;
        Formatter f = new Formatter();
        for (Method m : methods = b.getClass().getMethods()) {
            try {
                String name = m.getName();
                if (!m.getName().startsWith("get") || m.getName().equals("getClass") || m.getParameterTypes().length != 0 || !Modifier.isPublic(m.getModifiers())) continue;
                found = true;
                name = name.substring(3);
                m.setAccessible(true);
                Object value = m.invoke(b, (Object[])null);
                f.format(COLUMN, name, this.format(value, 1, this));
            }
            catch (IllegalAccessException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (found) {
            return (StringBuilder)f.out();
        }
        return b.toString();
    }

    @Override
    public Object convert(Class<?> desiredType, Object in) {
        return this.processor.convert(desiredType, in);
    }

    @Override
    public CharSequence format(Object result, int inspect) {
        try {
            return this.format(result, inspect, this);
        }
        catch (Exception e) {
            return "<can not format " + result + ":" + e;
        }
    }
}

