/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.dltk.console.ui.ScriptConsoleUIPlugin;
import org.eclipse.dltk.console.ui.internal.Messages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;

public class HTTPConsoleHyperlink
implements IHyperlink {
    private TextConsole fConsole;

    public HTTPConsoleHyperlink(TextConsole console) {
        this.fConsole = console;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        String uri = this.getLinkURI();
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = browserSupport.createBrowser(null);
            browser.openURL(new URL(uri));
        }
        catch (PartInitException e) {
            String msg = NLS.bind((String)Messages.HTTPConsoleHyperlink_failedToInitializeBrowserFor, (Object)uri);
            ScriptConsoleUIPlugin.error(msg, e);
        }
        catch (MalformedURLException e) {
            String msg = NLS.bind((String)Messages.HTTPConsoleHyperlink_failedToOpenInvalidUri, (Object)uri);
            ScriptConsoleUIPlugin.error(msg, e);
        }
    }

    protected TextConsole getConsole() {
        return this.fConsole;
    }

    protected String getLinkURI() {
        try {
            IDocument document = this.getConsole().getDocument();
            IRegion region = this.getConsole().getRegion((IHyperlink)this);
            return document.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

