/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.templates;

import java.io.IOException;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.templates.TemplateMessages;
import org.eclipse.dltk.ui.text.templates.ITemplateAccess;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public abstract class ScriptTemplateAccess
implements ITemplateAccess {
    private ContextTypeRegistry fRegistry;
    private TemplateStore fStore;

    public TemplateStore getTemplateStore() {
        if (this.fStore == null) {
            this.fStore = new ContributionTemplateStore(this.getContextTypeRegistry(), this.getPreferenceStore(), this.getCustomTemplatesKey());
            this.loadTemplates();
        }
        return this.fStore;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.createContextTypeRegistry();
        }
        return this.fRegistry;
    }

    protected ContextTypeRegistry createContextTypeRegistry() {
        ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
        String[] stringArray = this.getContextTypeIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            registry.addContextType(id);
            ++n2;
        }
        return registry;
    }

    @Deprecated
    protected String getContextTypeId() {
        return null;
    }

    protected String[] getContextTypeIds() {
        String[] stringArray;
        String contextTypeId = this.getContextTypeId();
        if (contextTypeId != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = contextTypeId;
        } else {
            stringArray = CharOperation.NO_STRINGS;
        }
        return stringArray;
    }

    protected abstract String getCustomTemplatesKey();

    protected abstract IPreferenceStore getPreferenceStore();

    public IPreferenceStore getTemplatePreferenceStore() {
        return this.getPreferenceStore();
    }

    private void loadTemplates() {
        try {
            this.fStore.load();
        }
        catch (IOException e) {
            String msg = NLS.bind((String)TemplateMessages.ScriptTemplateAccess_unableToLoadTemplateStore, (Object)e);
            DLTKUIPlugin.logErrorMessage(msg, e);
        }
    }
}

