/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.dltk.core.IArchive;
import org.eclipse.dltk.core.IArchiveEntry;
import org.eclipse.dltk.internal.core.ZipArchiveEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipArchiveFile
implements IArchive {
    private ZipFile zipFile;

    public ZipArchiveFile(File file) throws ZipException, IOException {
        this.zipFile = new ZipFile(file);
    }

    public ZipArchiveFile(String zipName) throws IOException {
        this.zipFile = new ZipFile(zipName);
    }

    @Override
    public InputStream getInputStream(IArchiveEntry entry) throws IOException {
        ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)entry;
        return this.zipFile.getInputStream(zipArchiveEntry.getZipEntry());
    }

    @Override
    public IArchiveEntry getArchiveEntry(String name) {
        return new ZipArchiveEntry(this.zipFile.getEntry(name));
    }

    @Override
    public Enumeration<? extends IArchiveEntry> getArchiveEntries() {
        final Enumeration<? extends ZipEntry> zipEnumeration = this.zipFile.entries();
        return new Enumeration<IArchiveEntry>(){

            @Override
            public boolean hasMoreElements() {
                return zipEnumeration.hasMoreElements();
            }

            @Override
            public IArchiveEntry nextElement() {
                return new ZipArchiveEntry((ZipEntry)zipEnumeration.nextElement());
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    @Override
    public String getName() {
        return this.zipFile.getName();
    }
}

