/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource.undostates;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.MarkerUndoState;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.ResourceUndoState;

abstract class AbstractResourceUndoState
extends ResourceUndoState {
    protected IContainer parent;
    protected long localTimeStamp = -1L;
    private long modificationStamp = -1L;
    private ResourceAttributes resourceAttributes;
    private MarkerUndoState[] markerDescriptions;

    protected AbstractResourceUndoState() {
    }

    protected AbstractResourceUndoState(IResource resource) {
        this.parent = resource.getParent();
        if (resource.isAccessible()) {
            this.modificationStamp = resource.getModificationStamp();
            this.localTimeStamp = resource.getLocalTimeStamp();
            this.resourceAttributes = resource.getResourceAttributes();
            try {
                IMarker[] markers = resource.findMarkers(null, true, 2);
                this.markerDescriptions = new MarkerUndoState[markers.length];
                int i = 0;
                while (i < markers.length) {
                    this.markerDescriptions[i] = new MarkerUndoState(markers[i]);
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public IResource createResource(IProgressMonitor monitor) throws CoreException {
        IResource resource = this.createResourceHandle();
        this.createExistentResourceFromHandle(resource, monitor);
        this.restoreResourceAttributes(resource);
        return resource;
    }

    public boolean isValid() {
        return this.parent == null || this.parent.exists();
    }

    protected void restoreResourceAttributes(IResource resource) throws CoreException {
        if (this.modificationStamp != -1L) {
            resource.revertModificationStamp(this.modificationStamp);
        }
        if (this.localTimeStamp != -1L) {
            resource.setLocalTimeStamp(this.localTimeStamp);
        }
        if (this.resourceAttributes != null) {
            resource.setResourceAttributes(this.resourceAttributes);
        }
        if (this.markerDescriptions != null) {
            int i = 0;
            while (i < this.markerDescriptions.length) {
                if (this.markerDescriptions[i].resource.exists()) {
                    this.markerDescriptions[i].createMarker();
                }
                ++i;
            }
        }
    }

    IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public boolean verifyExistence(boolean checkMembers) {
        IResource handle;
        IContainer p = this.parent;
        if (p == null) {
            p = this.getWorkspace().getRoot();
        }
        return (handle = p.findMember(this.getName())) != null;
    }
}

