/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast;

import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTModelUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaExpression;

public class LuaSelectionEngine
extends ScriptSelectionEngine {
    public IModelElement[] select(IModuleSource module, int start, int end) {
        if (!(module instanceof ISourceModule)) {
            return new IModelElement[0];
        }
        ISourceModule sourceModule = (ISourceModule)module;
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule);
        if (luaSourceRoot == null) {
            return null;
        }
        LuaExpression luaExpression = LuaASTUtils.getLuaExpressionAt(luaSourceRoot, start, end + 1);
        if (luaExpression == null) {
            return null;
        }
        LuaASTUtils.Definition definition = LuaASTUtils.getDefinition(sourceModule, luaExpression);
        if (definition == null) {
            return null;
        }
        IModelElement result = LuaASTModelUtils.getIModelElement(definition.getModule(), definition.getItem());
        if (result == null) {
            return null;
        }
        return new IModelElement[]{result};
    }
}

