/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.display;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.dltk.console.ui.ScriptConsole;
import org.eclipse.dltk.console.ui.internal.ScriptConsolePage;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.display.DebugConsole;
import org.eclipse.dltk.debug.ui.display.OpenInputFieldAction;
import org.eclipse.dltk.debug.ui.display.ResetOnLaunchAction;
import org.eclipse.dltk.debug.ui.display.RunInputFieldAction;
import org.eclipse.dltk.internal.debug.ui.ScriptEvaluationContextManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextDropTargetEffect;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.IUpdate;

public class DebugConsolePage
extends ScriptConsolePage {
    private DebugEventListener debugEventListener = null;
    private IAction runAction;
    private IAction resetOnLaunchAction;
    private IAction normalPasteAction;
    private IAction normalCopyAction;
    private IAction normalCutAction;
    private IAction normalSelectAllAction;
    private boolean resetOnLaunch;
    private SashForm sash;
    private StyledText inputField;
    private boolean focus = false;
    private boolean enabled = true;
    private final Job enableUpdateJob = new Job("Enable update"){

        protected IStatus run(IProgressMonitor monitor) {
            DLTKDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    DebugConsolePage.this.setEnabled(DebugConsolePage.this.isDebuggerAvailable());
                }
            });
            return Status.OK_STATUS;
        }
    };

    public DebugConsolePage(ScriptConsole console, IConsoleView view, SourceViewerConfiguration cfg) {
        super(console, view, cfg);
    }

    protected IAction createTerminateConsoleAction() {
        return null;
    }

    protected void createActions() {
        super.createActions();
        IActionBars actionBars = this.getSite().getActionBars();
        IToolBarManager tbManager = actionBars.getToolBarManager();
        tbManager.appendToGroup("scriptGroup", (IAction)new OpenInputFieldAction(this));
        this.runAction = new RunInputFieldAction(this);
        tbManager.appendToGroup("scriptGroup", this.runAction);
        this.resetOnLaunchAction = new ResetOnLaunchAction(this);
        this.resetOnLaunchAction.setChecked(this.resetOnLaunch);
        actionBars.getMenuManager().add(this.resetOnLaunchAction);
        this.updateActions();
        this.normalPasteAction = (IAction)this.fGlobalActions.get(ActionFactory.PASTE.getId());
        this.normalCopyAction = (IAction)this.fGlobalActions.get(ActionFactory.COPY.getId());
        this.normalCutAction = (IAction)this.fGlobalActions.get(ActionFactory.CUT.getId());
        this.normalSelectAllAction = (IAction)this.fGlobalActions.get(ActionFactory.SELECT_ALL.getId());
    }

    private void setEnabled(boolean value) {
        if (value != this.enabled) {
            this.enabled = value;
            if (this.inputField != null) {
                this.inputField.setEditable(value);
            }
            this.getViewer().setEditable(value);
            Control control = this.getViewer().getControl();
            control.setBackground(value ? null : control.getDisplay().getSystemColor(22));
        }
    }

    public Control getControl() {
        return this.sash != null ? this.sash : super.getControl();
    }

    public void createControl(Composite parent) {
        this.sash = new SashForm(parent, 66048);
        this.inputField = new StyledText((Composite)this.sash, 768);
        this.inputField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                DebugConsolePage.this.focus = false;
                DebugConsolePage.this.updateInputFieldActions();
            }

            public void focusGained(FocusEvent e) {
                DebugConsolePage.this.focus = true;
                DebugConsolePage.this.updateInputFieldActions();
            }
        });
        DropTarget target = new DropTarget((Control)this.inputField, 23);
        target.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new StyledTextDropTargetEffect(this.inputField){

            public void dragEnter(DropTargetEvent e) {
                super.dragEnter(e);
                if (e.detail == 16) {
                    e.detail = 1;
                }
            }

            public void dragOperationChanged(DropTargetEvent e) {
                super.dragOperationChanged(e);
                if (e.detail == 16) {
                    e.detail = 1;
                }
            }

            public void drop(DropTargetEvent e) {
                super.drop(e);
                Point selection = DebugConsolePage.this.inputField.getSelectionRange();
                DebugConsolePage.this.inputField.replaceTextRange(selection.x, selection.y, (String)e.data);
            }
        });
        this.inputField.setEditable(true);
        super.createControl((Composite)this.sash);
        this.inputField.setFont(this.getViewer().getControl().getFont());
        this.inputField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugConsolePage.this.updateActions();
            }
        });
        this.sash.setMaximizedControl(this.getViewer().getControl());
        this.setEnabled(this.isDebuggerAvailable());
        if (this.debugEventListener == null) {
            this.debugEventListener = new DebugEventListener();
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this.debugEventListener);
        }
        this.enableUpdateJob.schedule(500L);
    }

    private void updateInputFieldActions() {
        IActionBars actionBars = this.getSite().getActionBars();
        if (this.focus) {
            this.setGlobalAction(actionBars, ActionFactory.PASTE.getId(), (IAction)new PasteAction(this.inputField));
            this.setGlobalAction(actionBars, ActionFactory.COPY.getId(), (IAction)new CopyAction(this.inputField));
            this.setGlobalAction(actionBars, ActionFactory.CUT.getId(), (IAction)new CutAction(this.inputField));
            this.setGlobalAction(actionBars, ActionFactory.SELECT_ALL.getId(), (IAction)new SelectAllAction(this.inputField));
        } else {
            this.setGlobalAction(actionBars, ActionFactory.PASTE.getId(), this.normalPasteAction);
            this.setGlobalAction(actionBars, ActionFactory.COPY.getId(), this.normalCopyAction);
            this.setGlobalAction(actionBars, ActionFactory.CUT.getId(), this.normalCutAction);
            this.setGlobalAction(actionBars, ActionFactory.SELECT_ALL.getId(), this.normalSelectAllAction);
        }
        this.updateSelectionDependentActions();
    }

    private boolean isDebuggerAvailable() {
        IScriptThread thread;
        IPageSite site = this.getSite();
        if (site == null) {
            return false;
        }
        IWorkbenchPage page = site.getPage();
        if (page == null) {
            return false;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        IScriptStackFrame frame = ScriptEvaluationContextManager.getEvaluationContext(part);
        if (frame != null && (thread = frame.getScriptThread()) != null) {
            return thread.isSuspended();
        }
        return false;
    }

    public void dispose() {
        if (this.debugEventListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this.debugEventListener);
            this.debugEventListener = null;
        }
        super.dispose();
    }

    public boolean canExecuteInputField() {
        return this.sash != null && this.sash.getMaximizedControl() == null && this.inputField.getText().length() != 0;
    }

    public void openInputField() {
        if (this.sash != null) {
            this.sash.setWeights(new int[]{30, 70});
            this.sash.setMaximizedControl(null);
            this.inputField.setFocus();
        }
        this.updateActions();
    }

    public void closeInputField() {
        if (this.sash != null) {
            Control consoleControl = this.getViewer().getControl();
            this.sash.setMaximizedControl(consoleControl);
            consoleControl.setFocus();
        }
        this.updateActions();
    }

    private void updateActions() {
        if (this.runAction instanceof IUpdate) {
            ((IUpdate)this.runAction).update();
        }
    }

    public void executeInputField() {
        if (this.inputField != null) {
            String input = this.inputField.getText();
            ((ScriptConsole)this.getConsole()).executeCommand(input);
        }
    }

    private static boolean isTargetCreate(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 4 && event.getSource() instanceof IDebugTarget) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isResetOnLaunch() {
        return this.resetOnLaunch;
    }

    public void setResetOnLaunch(boolean resetOnLaunch) {
        this.resetOnLaunch = resetOnLaunch;
    }

    private static class CopyAction
    extends Action {
        private StyledText text;

        public CopyAction(StyledText text) {
            this.text = text;
        }

        public void run() {
            this.text.copy();
        }
    }

    private static class CutAction
    extends Action {
        private StyledText text;

        public CutAction(StyledText text) {
            this.text = text;
        }

        public void run() {
            this.text.cut();
        }
    }

    private final class DebugEventListener
    implements IDebugEventSetListener {
        private DebugEventListener() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            DebugConsolePage.this.enableUpdateJob.schedule(500L);
            if (DebugConsolePage.this.resetOnLaunch && DebugConsolePage.isTargetCreate(events)) {
                DLTKDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ((DebugConsole)DebugConsolePage.this.getConsole()).clearConsole();
                    }
                });
            }
        }
    }

    private static class PasteAction
    extends Action {
        private StyledText text;

        public PasteAction(StyledText text) {
            this.text = text;
        }

        public void run() {
            this.text.paste();
        }
    }

    private static class SelectAllAction
    extends Action {
        private StyledText text;

        public SelectAllAction(StyledText text) {
            this.text = text;
        }

        public void run() {
            this.text.selectAll();
        }
    }
}

