/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.httpclient4;

import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.filetransfer.BrowseFileTransferException;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemRequest;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient4.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient4.ConnectingSocketMonitor;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient4.HttpClientProxyCredentialProvider;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient4.Messages;
import org.eclipse.ecf.provider.filetransfer.browse.AbstractFileSystemBrowser;
import org.eclipse.ecf.provider.filetransfer.browse.URLRemoteFile;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketEventSource;
import org.eclipse.ecf.provider.filetransfer.httpclient4.HttpClientOptions;
import org.eclipse.ecf.provider.filetransfer.httpclient4.HttpClientRetrieveFileTransfer;
import org.eclipse.ecf.provider.filetransfer.httpclient4.NTLMProxyDetector;
import org.eclipse.ecf.provider.filetransfer.util.JREProxyHelper;
import org.eclipse.ecf.provider.filetransfer.util.ProxySetupHelper;
import org.eclipse.osgi.util.NLS;

public class HttpClientFileSystemBrowser
extends AbstractFileSystemBrowser {
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    protected static final int DEFAULT_CONNECTION_TIMEOUT = HttpClientOptions.BROWSE_DEFAULT_CONNECTION_TIMEOUT;
    private static final String USERNAME_PREFIX = "Username:";
    private JREProxyHelper proxyHelper = null;
    private ConnectingSocketMonitor connectingSockets;
    protected String username = null;
    protected String password = null;
    protected DefaultHttpClient httpClient = null;
    protected volatile HttpHead headMethod;
    protected volatile HttpResponse httpResponse;
    protected volatile HttpContext httpContext;

    public HttpClientFileSystemBrowser(DefaultHttpClient httpClient, IFileID directoryOrFileID, IRemoteFileSystemListener listener, URL directoryOrFileURL, IConnectContext connectContext, Proxy proxy) {
        super(directoryOrFileID, listener, directoryOrFileURL, connectContext, proxy);
        Assert.isNotNull((Object)httpClient);
        this.httpClient = httpClient;
        this.httpClient.setCredentialsProvider((CredentialsProvider)new HttpClientProxyCredentialProvider(){

            protected Proxy getECFProxy() {
                return HttpClientFileSystemBrowser.this.getProxy();
            }

            protected Credentials getNTLMCredentials(Proxy lp) {
                if (HttpClientFileSystemBrowser.this.hasForceNTLMProxyOption()) {
                    return HttpClientRetrieveFileTransfer.createNTLMCredentials(lp);
                }
                return null;
            }
        });
        this.proxyHelper = new JREProxyHelper();
        this.connectingSockets = new ConnectingSocketMonitor(1);
        this.prepareAuth();
    }

    private void prepareAuth() {
        ArrayList<String> authpref = new ArrayList<String>(3);
        authpref.add("NTLM");
        authpref.add("Digest");
        authpref.add("Basic");
        this.httpClient.getParams().setParameter("http.auth.proxy-scheme-pref", authpref);
        this.httpClient.getParams().setParameter("http.auth.target-scheme-pref", authpref);
    }

    protected IRemoteFileSystemRequest createRemoteFileSystemRequest() {
        return new HttpClientRemoteFileSystemRequest();
    }

    protected void cancel() {
        if (this.isCanceled()) {
            return;
        }
        this.setCanceled(this.getException());
        super.cancel();
        if (this.headMethod != null && !this.headMethod.isAborted()) {
            this.headMethod.abort();
        }
        if (this.connectingSockets != null) {
            for (Socket socket : this.connectingSockets.getConnectingSockets()) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/catching", ((Object)((Object)this)).getClass(), (String)"cancel", (Throwable)e);
                }
            }
        }
    }

    protected boolean hasForceNTLMProxyOption() {
        return System.getProperties().getProperty("org.eclipse.ecf.provider.filetransfer.httpclient4.options.ForceNTLMProxy") != null;
    }

    protected void setupProxies() {
        if (this.proxy == null) {
            try {
                this.proxy = ProxySetupHelper.getSocksProxy((URL)this.directoryOrFile);
                if (this.proxy == null) {
                    this.proxy = ProxySetupHelper.getProxy((String)this.directoryOrFile.toExternalForm());
                }
            }
            catch (NoClassDefFoundError e) {
                Activator.logNoProxyWarning(e);
            }
        }
        if (this.proxy != null) {
            this.setupProxy(this.proxy);
        }
    }

    protected void cleanUp() {
        this.clearProxy();
        super.cleanUp();
    }

    protected void runRequest() throws Exception {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"runRequest");
        this.setupProxies();
        this.httpClient.getParams().setIntParameter("http.socket.timeout", DEFAULT_CONNECTION_TIMEOUT);
        this.httpClient.getParams().setIntParameter("http.connection.timeout", DEFAULT_CONNECTION_TIMEOUT);
        String urlString = this.directoryOrFile.toString();
        this.setupAuthentication(urlString);
        this.headMethod = new HttpHead(urlString);
        this.headMethod.addHeader("Cache-Control", "max-age=0");
        long lastModified = 0L;
        long fileLength = -1L;
        this.connectingSockets.clear();
        int code = -1;
        try {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("browse=" + urlString));
            this.httpContext = new BasicHttpContext();
            this.httpResponse = this.httpClient.execute((HttpUriRequest)this.headMethod, this.httpContext);
            code = this.httpResponse.getStatusLine().getStatusCode();
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("browse resp=" + code));
            boolean ntlmProxyFound = NTLMProxyDetector.detectNTLMProxy(this.httpContext);
            if (ntlmProxyFound && !this.hasForceNTLMProxyOption()) {
                throw new BrowseFileTransferException("HttpClient Provider is not configured to support NTLM proxy authentication.", 477);
            }
            if (NTLMProxyDetector.detectSPNEGOProxy(this.httpContext)) {
                throw new BrowseFileTransferException("HttpClient Provider does not support the use of SPNEGO proxy authentication.");
            }
            if (code == 200) {
                Header contentLength = this.httpResponse.getLastHeader(CONTENT_LENGTH_HEADER);
                if (contentLength != null) {
                    fileLength = Integer.parseInt(contentLength.getValue());
                }
            } else {
                if (code == 404) {
                    throw new BrowseFileTransferException(NLS.bind((String)"File not found: {0}", (Object)urlString), code);
                }
                if (code == 401) {
                    throw new BrowseFileTransferException(Messages.HttpClientRetrieveFileTransfer_Unauthorized, code);
                }
                if (code == 403) {
                    throw new BrowseFileTransferException("Forbidden", code);
                }
                if (code == 407) {
                    throw new BrowseFileTransferException(Messages.HttpClientRetrieveFileTransfer_Proxy_Auth_Required, code);
                }
                throw new BrowseFileTransferException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_ERROR_GENERAL_RESPONSE_CODE, (Object)new Integer(code)), code);
            }
            lastModified = this.getLastModifiedTimeFromHeader();
            this.remoteFiles = new IRemoteFile[1];
            this.remoteFiles[0] = new URLRemoteFile(lastModified, fileLength, this.fileID);
        }
        catch (Exception e) {
            Trace.throwing((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/throwing", ((Object)((Object)this)).getClass(), (String)"runRequest", (Throwable)e);
            BrowseFileTransferException ex = (BrowseFileTransferException)(e instanceof BrowseFileTransferException ? e : new BrowseFileTransferException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_EXCEPTION_COULD_NOT_CONNECT, (Object)urlString), (Throwable)e, code));
            throw ex;
        }
    }

    private long getLastModifiedTimeFromHeader() throws IOException {
        Header lastModifiedHeader = this.httpResponse.getLastHeader("Last-Modified");
        if (lastModifiedHeader == null) {
            return 0L;
        }
        String lastModifiedString = lastModifiedHeader.getValue();
        long lastModified = 0L;
        if (lastModifiedString != null) {
            try {
                lastModified = DateUtils.parseDate((String)lastModifiedString).getTime();
            }
            catch (Exception e) {
                throw new IOException(Messages.HttpClientRetrieveFileTransfer_EXCEPITION_INVALID_LAST_MODIFIED_FROM_SERVER);
            }
        }
        return lastModified;
    }

    Proxy getProxy() {
        return this.proxy;
    }

    protected Credentials getFileRequestCredentials() throws UnsupportedCallbackException, IOException {
        if (this.connectContext == null) {
            return null;
        }
        CallbackHandler callbackHandler = this.connectContext.getCallbackHandler();
        if (callbackHandler == null) {
            return null;
        }
        NameCallback usernameCallback = new NameCallback(USERNAME_PREFIX);
        ObjectCallback passwordCallback = new ObjectCallback();
        callbackHandler.handle(new Callback[]{usernameCallback, passwordCallback});
        this.username = usernameCallback.getName();
        this.password = (String)passwordCallback.getObject();
        return new UsernamePasswordCredentials(this.username, this.password);
    }

    protected void setupAuthentication(String urlString) throws UnsupportedCallbackException, IOException {
        Credentials credentials = null;
        if (this.username == null) {
            credentials = this.getFileRequestCredentials();
        }
        if (credentials != null && this.username != null) {
            AuthScope authScope = new AuthScope(HttpClientRetrieveFileTransfer.getHostFromURL(urlString), HttpClientRetrieveFileTransfer.getPortFromURL(urlString), AuthScope.ANY_REALM);
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("browse credentials=" + credentials));
            this.httpClient.getCredentialsProvider().setCredentials(authScope, credentials);
        }
    }

    protected void setupProxy(Proxy proxy) {
        if (proxy.getType().equals(Proxy.Type.HTTP)) {
            ProxyAddress address = proxy.getAddress();
            ConnRouteParams.setDefaultProxy((HttpParams)this.httpClient.getParams(), (HttpHost)new HttpHost(address.getHostName(), address.getPort()));
        } else if (proxy.getType().equals(Proxy.Type.SOCKS)) {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("brows socksproxy=" + proxy.getAddress()));
            this.proxyHelper.setupProxy(proxy);
        }
    }

    protected void clearProxy() {
        ConnRouteParams.setDefaultProxy((HttpParams)this.httpClient.getParams(), null);
    }

    class HttpClientRemoteFileSystemRequest
    extends AbstractFileSystemBrowser.RemoteFileSystemRequest {
        protected SocketEventSource socketEventSource;

        HttpClientRemoteFileSystemRequest() {
            super((AbstractFileSystemBrowser)HttpClientFileSystemBrowser.this);
            this.socketEventSource = new SocketEventSource(){

                public Object getAdapter(Class adapter) {
                    if (adapter == null) {
                        return null;
                    }
                    if (adapter.isInstance((Object)this)) {
                        return this;
                    }
                    if (adapter.isInstance((Object)HttpClientRemoteFileSystemRequest.this)) {
                        return HttpClientRemoteFileSystemRequest.this;
                    }
                    return null;
                }
            };
        }

        public Object getAdapter(Class adapter) {
            if (adapter == null) {
                return null;
            }
            return this.socketEventSource.getAdapter(adapter);
        }

        public void cancel() {
            HttpClientFileSystemBrowser.this.cancel();
        }
    }
}

