/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ResourceNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.ui.IEditorInput;

public class LocalResourceTypedElement
extends ResourceNode
implements IAdaptable {
    private boolean fDirty = false;
    private EditableSharedDocumentAdapter sharedDocumentAdapter;
    private long timestamp;
    private boolean exists;
    private boolean useSharedDocument = true;
    private EditableSharedDocumentAdapter.ISharedDocumentAdapterListener sharedDocumentListener;
    private String author;
    static /* synthetic */ Class class$0;

    public LocalResourceTypedElement(IResource resource) {
        super(resource);
        this.exists = resource.exists();
    }

    public void setContent(byte[] contents) {
        this.fDirty = true;
        super.setContent(contents);
    }

    public void commit(IProgressMonitor monitor) throws CoreException {
        if (this.isDirty()) {
            if (this.isConnected()) {
                this.saveDocument(true, monitor);
            } else {
                IResource resource = this.getResource();
                if (resource instanceof IFile) {
                    ByteArrayInputStream is = new ByteArrayInputStream(this.getContent());
                    try {
                        IFile file = (IFile)resource;
                        if (file.exists()) {
                            file.setContents((InputStream)is, false, true, monitor);
                        } else {
                            file.create((InputStream)is, false, monitor);
                        }
                        this.fDirty = false;
                    }
                    catch (Throwable throwable) {
                        this.fireContentChanged();
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    this.fireContentChanged();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                this.updateTimestamp();
            }
        }
    }

    public InputStream getContents() throws CoreException {
        if (this.exists) {
            return super.getContents();
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.compare.ISharedDocumentAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            if (this.isSharedDocumentsEnable()) {
                return this.getSharedDocumentAdapter();
            }
            return null;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    private synchronized ISharedDocumentAdapter getSharedDocumentAdapter() {
        if (this.sharedDocumentAdapter == null) {
            this.sharedDocumentAdapter = new EditableSharedDocumentAdapter(new EditableSharedDocumentAdapter.ISharedDocumentAdapterListener(){

                public void handleDocumentConnected() {
                    LocalResourceTypedElement.this.updateTimestamp();
                    if (LocalResourceTypedElement.this.sharedDocumentListener != null) {
                        LocalResourceTypedElement.this.sharedDocumentListener.handleDocumentConnected();
                    }
                }

                public void handleDocumentFlushed() {
                    LocalResourceTypedElement.this.fireContentChanged();
                    if (LocalResourceTypedElement.this.sharedDocumentListener != null) {
                        LocalResourceTypedElement.this.sharedDocumentListener.handleDocumentFlushed();
                    }
                }

                public void handleDocumentDeleted() {
                    LocalResourceTypedElement.this.update();
                    if (LocalResourceTypedElement.this.sharedDocumentListener != null) {
                        LocalResourceTypedElement.this.sharedDocumentListener.handleDocumentDeleted();
                    }
                }

                public void handleDocumentSaved() {
                    LocalResourceTypedElement.this.updateTimestamp();
                    if (LocalResourceTypedElement.this.sharedDocumentListener != null) {
                        LocalResourceTypedElement.this.sharedDocumentListener.handleDocumentSaved();
                    }
                }

                public void handleDocumentDisconnected() {
                    if (LocalResourceTypedElement.this.sharedDocumentListener != null) {
                        LocalResourceTypedElement.this.sharedDocumentListener.handleDocumentDisconnected();
                    }
                }
            });
        }
        return this.sharedDocumentAdapter;
    }

    public boolean isEditable() {
        IResource resource = this.getResource();
        return resource.getType() == 1 && this.exists;
    }

    public boolean isConnected() {
        return this.sharedDocumentAdapter != null && this.sharedDocumentAdapter.isConnected();
    }

    public boolean saveDocument(boolean overwrite, IProgressMonitor monitor) throws CoreException {
        if (this.isConnected()) {
            IEditorInput input = this.sharedDocumentAdapter.getDocumentKey((Object)this);
            this.sharedDocumentAdapter.saveDocument(input, overwrite, monitor);
            this.updateTimestamp();
            return true;
        }
        return false;
    }

    protected InputStream createStream() throws CoreException {
        InputStream inputStream = super.createStream();
        this.updateTimestamp();
        return inputStream;
    }

    void updateTimestamp() {
        if (this.getResource().exists()) {
            this.timestamp = this.getResource().getLocalTimeStamp();
        } else {
            this.exists = false;
        }
    }

    private long getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return this.getResource().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LocalResourceTypedElement) {
            LocalResourceTypedElement otherElement = (LocalResourceTypedElement)((Object)obj);
            return otherElement.getResource().equals((Object)this.getResource()) && this.exists == otherElement.exists;
        }
        return false;
    }

    public void update() {
        this.exists = this.getResource().exists();
    }

    public boolean isSynchronized() {
        long current = this.getResource().getLocalTimeStamp();
        return current == this.getTimestamp();
    }

    public boolean exists() {
        return this.exists;
    }

    protected void fireContentChanged() {
        super.fireContentChanged();
    }

    public void discardBuffer() {
        if (this.sharedDocumentAdapter != null) {
            this.sharedDocumentAdapter.releaseBuffer();
        }
        super.discardBuffer();
    }

    public boolean isSharedDocumentsEnable() {
        return this.useSharedDocument && this.getResource().getType() == 1 && this.exists;
    }

    public void enableSharedDocument(boolean enablement) {
        this.useSharedDocument = enablement;
    }

    public boolean isDirty() {
        return this.fDirty || this.sharedDocumentAdapter != null && this.sharedDocumentAdapter.hasBufferedContents();
    }

    public void setSharedDocumentListener(EditableSharedDocumentAdapter.ISharedDocumentAdapterListener sharedDocumentListener) {
        this.sharedDocumentListener = sharedDocumentListener;
    }

    public String getAuthor() {
        return this.author;
    }

    public void fetchAuthor(IProgressMonitor monitor) throws CoreException {
        this.author = null;
        IFileHistoryProvider fileHistoryProvider = Utils.getHistoryProvider(this.getResource());
        if (fileHistoryProvider == null) {
            return;
        }
        IFileRevision revision = fileHistoryProvider.getWorkspaceFileRevision(this.getResource());
        if (revision == null) {
            return;
        }
        this.author = revision.getAuthor();
        if (this.author == null && revision.isPropertyMissing()) {
            IFileRevision other = revision.withAllProperties(monitor);
            this.author = other.getAuthor();
        }
    }

    public void setAuthor(String author) {
        this.author = author;
    }
}

