/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.memory;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.memory.IMemoryRenderingBindingsListener;
import org.eclipse.debug.ui.memory.IMemoryRenderingBindingsProvider;

public abstract class AbstractMemoryRenderingBindingsProvider
implements IMemoryRenderingBindingsProvider {
    private ListenerList fListeners;

    public void addListener(IMemoryRenderingBindingsListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IMemoryRenderingBindingsListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    protected void fireBindingsChanged() {
        if (this.fListeners == null) {
            return;
        }
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof IMemoryRenderingBindingsListener) {
                final IMemoryRenderingBindingsListener listener = (IMemoryRenderingBindingsListener)listeners[i];
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }

                    public void run() throws Exception {
                        listener.memoryRenderingBindingsChanged();
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
            ++i;
        }
    }
}

