/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.ui.internal.launchconfiguration.local.tab;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.debug.ui.interpreters.AbstractInterpreterComboBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.IInterpreterComboBlockContext;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpreterDescriptor;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.koneki.ldt.debug.ui.internal.launchconfiguration.local.tab.Messages;
import org.eclipse.koneki.ldt.ui.SWTUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class LuaInterpreterTabComboBlock
extends AbstractInterpreterComboBlock {
    private static final Status OK = new Status(0, "org.eclipse.koneki.ldt.debug.ui", "It is all good.");
    private Composite control;
    private Button defaultButton;
    private Label defaultInterpreter;
    private List<IInterpreterInstall> interpreters = new ArrayList<IInterpreterInstall>();
    private Button alternateButton;
    private Combo interpretersCombo;
    private InterpreterDescriptor defaultInterpreterDescriptor;
    private IStatus status;
    private ListenerList listeners = new ListenerList();
    private boolean isControlCreated = false;
    private IInterpreterInstall interpreterInstall;

    public LuaInterpreterTabComboBlock(IInterpreterComboBlockContext context) {
        super(context);
    }

    public void createControl(Composite parent) {
        Font parentFont = parent.getFont();
        this.control = new Composite(parent, 0);
        this.control.setFont(parentFont);
        GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)this.control);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(this.control);
        Group group = new Group(this.control, 0);
        group.setFont(parentFont);
        group.setText(Messages.LuaInterpreterTabComboBlockRuntimeInterpreterLabel);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)group);
        GridDataFactory.swtDefaults().span(3, 1).grab(true, false).align(4, 0x1000000).applyTo((Control)group);
        this.defaultButton = new Button((Composite)group, 16);
        this.defaultButton.setFont(parentFont);
        this.defaultButton.setText(Messages.LuaInterpreterTabComboBlockDefaultInterpreterLabel);
        this.defaultInterpreter = new Label((Composite)group, 16);
        this.defaultButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LuaInterpreterTabComboBlock.this.setUseDefaultInterpreter();
            }
        });
        GridDataFactory.swtDefaults().span(2, 1).grab(true, false).align(4, 0x1000000).applyTo((Control)this.defaultInterpreter);
        this.alternateButton = new Button((Composite)group, 16);
        this.alternateButton.setFont(parentFont);
        this.alternateButton.setText(Messages.LuaInterpreterTabComboBlockAlternateInterpreterLabel);
        this.alternateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LuaInterpreterTabComboBlock.this.setUseAlternateInterpreter();
            }
        });
        this.interpretersCombo = new Combo((Composite)group, 12);
        this.interpretersCombo.setFont(parentFont);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.interpretersCombo);
        this.interpretersCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LuaInterpreterTabComboBlock.this.setInterpreterInstall((IInterpreterInstall)LuaInterpreterTabComboBlock.this.interpreters.get(LuaInterpreterTabComboBlock.this.interpretersCombo.getSelectionIndex()));
                LuaInterpreterTabComboBlock.this.refreshInterpreters();
                LuaInterpreterTabComboBlock.this.firePropertyChange();
            }
        });
        Button manageButton = new Button((Composite)group, 0);
        manageButton.setFont(parentFont);
        manageButton.setText(Messages.LuaInterpreterTabComboBlockManageInterpretersButton);
        manageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LuaInterpreterTabComboBlock.this.showInterpreterPreferencePage();
                LuaInterpreterTabComboBlock.this.refreshInterpreters();
            }
        });
        GridDataFactory.swtDefaults().hint(SWTUtil.getButtonWidthHint((Button)manageButton), -1).applyTo((Control)manageButton);
        this.isControlCreated = true;
    }

    private boolean isControlCreated() {
        return this.isControlCreated;
    }

    public Control getControl() {
        return this.control;
    }

    public void setUseDefaultInterpreter() {
        if (this.isControlCreated()) {
            this.defaultInterpreter.setEnabled(true);
            this.defaultButton.setSelection(true);
            this.alternateButton.setSelection(false);
            this.interpretersCombo.setEnabled(false);
            this.firePropertyChange();
        }
    }

    private void setUseAlternateInterpreter() {
        if (this.isControlCreated()) {
            this.defaultButton.setSelection(false);
            this.defaultInterpreter.setEnabled(false);
            this.alternateButton.setSelection(true);
            this.interpretersCombo.setEnabled(true);
            this.firePropertyChange();
        }
    }

    public IInterpreterInstall getInterpreter() {
        if (this.isDefaultInterpreter() && this.getDefaultInterpreterDescriptor() != null) {
            return this.getDefaultInterpreterDescriptor().getInterpreter();
        }
        return this.interpreterInstall;
    }

    protected void setInterpreters(List<IInterpreterInstall> interpreterList) {
        this.interpreters.clear();
        this.interpreters.addAll(interpreterList);
        Collections.sort(this.interpreters, new Comparator<IInterpreterInstall>(){

            @Override
            public int compare(IInterpreterInstall o1, IInterpreterInstall o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        if (this.isControlCreated()) {
            this.interpretersCombo.removeAll();
            for (IInterpreterInstall install : this.interpreters) {
                this.interpretersCombo.add(install.getName());
            }
            if (this.interpretersCombo.getSelectionIndex() == -1 && this.interpreters.size() > 0) {
                IInterpreterInstall interpreter = this.getInterpreter();
                if (interpreter != null) {
                    int indexOfInterpreter = this.interpretersCombo.indexOf(interpreter.getName());
                    this.interpretersCombo.select(indexOfInterpreter);
                } else {
                    this.interpretersCombo.select(0);
                }
            }
        }
        this.firePropertyChange();
    }

    public void refreshInterpreters() {
        this.fillWithWorkspaceInterpreters();
        if (this.isControlCreated()) {
            IInterpreterInstall defaultInterpreterInstall = null;
            if (this.getDefaultInterpreterDescriptor() != null && (defaultInterpreterInstall = this.getDefaultInterpreterDescriptor().getInterpreter()) != null) {
                this.defaultInterpreter.setText(defaultInterpreterInstall.getName());
                this.setStatus((IStatus)OK);
            }
            if (defaultInterpreterInstall == null) {
                this.defaultInterpreter.setText("(undefined)");
                this.setStatus((IStatus)new Status(4, "org.eclipse.koneki.ldt.debug.ui", Messages.LuaInterpreterTabComboBlockNoDefaultInterpreter));
            }
            if (this.interpretersCombo.getItemCount() < 1) {
                this.setStatus((IStatus)new Status(4, "org.eclipse.koneki.ldt.debug.ui", Messages.LuaInterpreterTabComboBlockNoInterpreter));
            } else if (this.isDefaultInterpreter() && this.interpretersCombo.getSelectionIndex() == -1) {
                this.setStatus((IStatus)new Status(4, "org.eclipse.koneki.ldt.debug.ui", Messages.LuaInterpreterTabComboBlockSelectAnInterpreter));
            }
        }
        this.setPath(this.getInterpreterPath());
        this.firePropertyChange();
    }

    public IStatus getStatus() {
        return this.status;
    }

    private void setStatus(IStatus istatus) {
        this.status = istatus;
    }

    public IPath getInterpreterPath() {
        if (!this.isDefaultInterpreter()) {
            IInterpreterInstall interpreter = this.getInterpreter();
            if (interpreter != null) {
                return ScriptRuntime.newInterpreterContainerPath((IInterpreterInstall)interpreter);
            }
            return null;
        }
        return ScriptRuntime.newDefaultInterpreterContainerPath();
    }

    public void setDefaultInterpreterDescriptor(InterpreterDescriptor descriptor) {
        this.defaultInterpreterDescriptor = descriptor;
    }

    protected InterpreterDescriptor getDefaultInterpreterDescriptor() {
        return this.defaultInterpreterDescriptor;
    }

    public boolean isDefaultInterpreter() {
        return this.defaultButton != null && this.defaultButton.getSelection();
    }

    public void refresh() {
        this.setDefaultInterpreterDescriptor(this.getDefaultInterpreterDescriptor());
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void firePropertyChange() {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "PROPERTY_INTERPRETER", null, (Object)this.getInterpreterPath());
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            IPropertyChangeListener propertyChangeListenerlistener = (IPropertyChangeListener)listener;
            propertyChangeListenerlistener.propertyChange(event);
            ++n2;
        }
    }

    public void setPath(IPath containerPath) {
        this.setStatus((IStatus)OK);
        if (this.interpreters.isEmpty()) {
            this.setStatus((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 167, Messages.LuaInterpreterTabComboBlockNoInterpreter, null));
        }
        if (ScriptRuntime.newDefaultInterpreterContainerPath().equals((Object)containerPath)) {
            this.setUseDefaultInterpreter();
        } else if (containerPath != null) {
            IEnvironment environment = this.getContext().getEnvironment();
            IInterpreterInstall install = null;
            if (environment != null) {
                String natureId = this.getContext().getNatureId();
                String environmentId = environment.getId();
                install = ScriptRuntime.getInterpreterInstall((String)natureId, (String)environmentId, (IPath)containerPath);
            }
            if (install != null) {
                this.setInterpreterInstall(install);
                this.selectAlternateInterpreter(install);
            } else {
                this.setStatus((IStatus)new Status(4, "org.eclipse.koneki.ldt.debug.ui", Messages.LuaInterpreterTabComboBlockNoInterpreter));
            }
        }
    }

    private void setInterpreterInstall(IInterpreterInstall install) {
        this.interpreterInstall = install;
    }

    private void selectAlternateInterpreter(IInterpreterInstall iInstall) {
        int index = this.interpretersCombo.indexOf(iInstall.getName());
        if (index >= 0) {
            this.interpretersCombo.select(index);
        }
        this.setUseAlternateInterpreter();
    }
}

