/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.runtime.EOFError;
import org.apache.felix.gogo.runtime.SyntaxError;
import org.apache.felix.gogo.runtime.Token;
import org.apache.felix.gogo.runtime.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private final Tokenizer tz;

    public Parser(CharSequence program) {
        this.tz = new Tokenizer(program);
    }

    public List<List<List<Token>>> program() {
        ArrayList<List<List<Token>>> program = new ArrayList<List<List<Token>>>();
        block3: while (this.tz.next() != Tokenizer.Type.EOT) {
            program.add(this.pipeline());
            switch (this.tz.type()) {
                case SEMICOLON: 
                case NEWLINE: {
                    continue block3;
                }
            }
        }
        if (this.tz.next() != Tokenizer.Type.EOT) {
            throw new RuntimeException("Program has trailing text: " + this.tz.value());
        }
        return program;
    }

    private List<List<Token>> pipeline() {
        ArrayList<List<Token>> pipeline = new ArrayList<List<Token>>();
        block3: while (true) {
            pipeline.add(this.command());
            switch (this.tz.type()) {
                case PIPE: {
                    if (this.tz.next() != Tokenizer.Type.EOT) continue block3;
                    Token t = this.tz.token();
                    throw new EOFError(t.line, t.column, "unexpected EOT after pipe '|'");
                }
            }
            break;
        }
        return pipeline;
    }

    private List<Token> command() {
        ArrayList<Token> command = new ArrayList<Token>();
        while (true) {
            Token t = this.tz.token();
            switch (t.type) {
                case WORD: 
                case CLOSURE: 
                case EXECUTION: 
                case ARRAY: 
                case ASSIGN: {
                    break;
                }
                default: {
                    throw new SyntaxError(t.line, t.column, "unexpected token: " + (Object)((Object)t.type));
                }
            }
            command.add(t);
            switch (this.tz.next()) {
                case SEMICOLON: 
                case NEWLINE: 
                case PIPE: 
                case EOT: {
                    return command;
                }
            }
        }
    }

    public void array(List<Token> list, Map<Token, Token> map) throws Exception {
        Token lt = null;
        boolean isMap = false;
        block4: while (this.tz.next() != Tokenizer.Type.EOT) {
            if (isMap) {
                Token key = lt;
                lt = null;
                if (null == key) {
                    key = this.tz.token();
                    if (this.tz.next() != Tokenizer.Type.ASSIGN) {
                        Token t = this.tz.token();
                        throw new SyntaxError(t.line, t.column, "map expected '=', found: " + t);
                    }
                    this.tz.next();
                }
                Token k = list.isEmpty() ? key : list.remove(0);
                Token v = this.tz.token();
                map.put(k, v);
                continue;
            }
            switch (this.tz.type()) {
                case WORD: 
                case CLOSURE: 
                case EXECUTION: 
                case ARRAY: {
                    lt = this.tz.token();
                    list.add(lt);
                    continue block4;
                }
                case ASSIGN: {
                    if (list.size() != 1) break;
                    isMap = true;
                    continue block4;
                }
            }
            lt = this.tz.token();
            throw new SyntaxError(lt.line, lt.column, "unexpected token in list: " + lt);
        }
    }
}

