/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.commands;

import org.eclipse.dltk.dbgp.DbgpBaseCommands;
import org.eclipse.dltk.dbgp.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.IDbgpStatus;
import org.eclipse.dltk.dbgp.commands.IDbgpContinuationCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlEntityParser;

public class DbgpContinuationCommands
extends DbgpBaseCommands
implements IDbgpContinuationCommands {
    private static final String RUN_COMMAND = "run";
    private static final String STEP_INTO_COMMAND = "step_into";
    private static final String STEP_OVER_COMMAND = "step_over";
    private static final String STEP_OUT_COMMAND = "step_out";
    private static final String STOP_COMMAND = "stop";
    private static final String DETACH_COMMAND = "detach";

    protected IDbgpStatus execCommand(String command) throws DbgpException {
        return DbgpXmlEntityParser.parseStatus(this.communicate(DbgpContinuationCommands.createRequest(command)));
    }

    public DbgpContinuationCommands(IDbgpCommunicator communicator) {
        super(communicator);
    }

    public IDbgpStatus run() throws DbgpException {
        return this.execCommand(RUN_COMMAND);
    }

    public IDbgpStatus stepInto() throws DbgpException {
        return this.execCommand(STEP_INTO_COMMAND);
    }

    public IDbgpStatus stepOut() throws DbgpException {
        return this.execCommand(STEP_OUT_COMMAND);
    }

    public IDbgpStatus stepOver() throws DbgpException {
        return this.execCommand(STEP_OVER_COMMAND);
    }

    public IDbgpStatus stop() throws DbgpException {
        return this.execCommand(STOP_COMMAND);
    }

    public IDbgpStatus detach() throws DbgpException {
        return this.execCommand(DETACH_COMMAND);
    }
}

