/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.internal.contexts.Computation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakGroupedListenerList {
    private Map<String, HashSet<WeakComputationReference>> listeners = new HashMap<String, HashSet<WeakComputationReference>>(10, 0.8f);

    public synchronized void add(String groupName, Computation computation) {
        HashSet<WeakComputationReference> nameListeners = this.listeners.get(groupName);
        if (nameListeners == null) {
            nameListeners = new HashSet(30, 0.75f);
            nameListeners.add(new WeakComputationReference(computation));
            this.listeners.put(groupName, nameListeners);
        }
        nameListeners.add(new WeakComputationReference(computation));
    }

    public synchronized void remove(Computation computation) {
        WeakComputationReference ref = new WeakComputationReference(computation);
        Collection<HashSet<WeakComputationReference>> allListeners = this.listeners.values();
        for (HashSet<WeakComputationReference> group : allListeners) {
            group.remove(ref);
        }
    }

    public synchronized Set<String> getNames() {
        Set<String> tmp = this.listeners.keySet();
        HashSet<String> usedNames = new HashSet<String>(tmp.size());
        usedNames.addAll(tmp);
        return usedNames;
    }

    public synchronized void clear() {
        this.listeners.clear();
    }

    public synchronized Set<Computation> getListeners() {
        Collection<HashSet<WeakComputationReference>> collection = this.listeners.values();
        HashSet<Computation> result = new HashSet<Computation>();
        for (HashSet<WeakComputationReference> set : collection) {
            Iterator<WeakComputationReference> i = set.iterator();
            while (i.hasNext()) {
                WeakComputationReference ref = i.next();
                Computation computation = (Computation)ref.get();
                if (computation == null || !computation.isValid()) {
                    i.remove();
                    continue;
                }
                result.add(computation);
            }
        }
        return result;
    }

    public synchronized Set<Computation> getListeners(String groupName) {
        HashSet<WeakComputationReference> tmp = this.listeners.get(groupName);
        if (tmp == null) {
            return null;
        }
        HashSet<Computation> result = new HashSet<Computation>(tmp.size());
        Iterator<WeakComputationReference> i = tmp.iterator();
        while (i.hasNext()) {
            WeakComputationReference ref = i.next();
            Computation computation = (Computation)ref.get();
            if (computation == null || !computation.isValid()) {
                i.remove();
                continue;
            }
            result.add(computation);
        }
        return result;
    }

    public synchronized void cleanup() {
        boolean cleanGroups = false;
        for (HashSet<WeakComputationReference> set : this.listeners.values()) {
            Iterator<WeakComputationReference> i = set.iterator();
            while (i.hasNext()) {
                WeakComputationReference ref = i.next();
                Computation computation = (Computation)ref.get();
                if (computation != null && computation.isValid()) continue;
                i.remove();
            }
            if (!set.isEmpty()) continue;
            cleanGroups = true;
        }
        if (cleanGroups) {
            Set<Map.Entry<String, HashSet<WeakComputationReference>>> entries = this.listeners.entrySet();
            Iterator<Map.Entry<String, HashSet<WeakComputationReference>>> i = entries.iterator();
            while (i.hasNext()) {
                Map.Entry<String, HashSet<WeakComputationReference>> entry = i.next();
                HashSet<WeakComputationReference> value = entry.getValue();
                if (value != null && !value.isEmpty()) continue;
                i.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WeakComputationReference
    extends WeakReference<Computation> {
        private final int hashCode;

        public WeakComputationReference(Computation computation) {
            super(computation);
            this.hashCode = computation.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!WeakComputationReference.class.equals(obj.getClass())) {
                return super.equals(obj);
            }
            Computation computation = (Computation)this.get();
            Computation otherComputation = (Computation)((WeakComputationReference)obj).get();
            if (computation == null && otherComputation == null) {
                return true;
            }
            if (computation == null || otherComputation == null) {
                return false;
            }
            return computation.equals(otherComputation);
        }
    }
}

