/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.dltk.ui.search.IOccurrencesFinder;
import org.eclipse.dltk.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.dltk.ui.viewsupport.SelectionListenerWithASTManager;
import org.eclipse.dltk.utils.NatureExtensionManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class OccurrencesFinder {
    private boolean fMarkOccurrenceAnnotations;
    private boolean fStickyOccurrenceAnnotations;
    private OccurrencesFinderJob fOccurrencesFinderJob;
    private OccurrencesFinderJobCanceler fOccurrencesFinderJobCanceler;
    private long fMarkOccurrenceModificationStamp = -1L;
    private IRegion fMarkOccurrenceTargetRegion;
    private ISelection fForcedMarkOccurrencesSelection;
    private Annotation[] fOccurrenceAnnotations = null;
    private final ScriptEditor editor;
    private final IOccurrencesFinder[] finders;
    private ActivationListener fActivationListener = new ActivationListener();
    private ISelectionListenerWithAST fPostSelectionListenerWithAST;
    private IPreferenceStore preferenceStore;

    public OccurrencesFinder(ScriptEditor editor) {
        this.editor = editor;
        NatureExtensionManager occurrencesFinderManager = new NatureExtensionManager("org.eclipse.dltk.ui.search", IOccurrencesFinder.class);
        this.finders = (IOccurrencesFinder[])occurrencesFinderManager.getInstances(editor.getLanguageToolkit().getNatureId());
    }

    public void install() {
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.fActivationListener);
        if (this.isMarkingOccurrences()) {
            this.installOccurrencesFinder(false);
        }
    }

    public void dispose() {
        this.fMarkOccurrenceAnnotations = false;
        this.uninstallOccurrencesFinder();
        if (this.fActivationListener != null) {
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
            this.fActivationListener = null;
        }
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.preferenceStore = store;
        this.fMarkOccurrenceAnnotations = store.getBoolean("markOccurrences");
        this.fStickyOccurrenceAnnotations = store.getBoolean("stickyOccurrences");
    }

    public boolean isMarkingOccurrences() {
        return this.preferenceStore != null && this.preferenceStore.getBoolean("markOccurrences");
    }

    protected boolean handlePreferenceStoreChanged(String property, boolean newValue) {
        if ("markOccurrences".equals(property)) {
            if (newValue != this.fMarkOccurrenceAnnotations) {
                this.fMarkOccurrenceAnnotations = newValue;
                if (!newValue) {
                    this.uninstallOccurrencesFinder();
                } else {
                    this.installOccurrencesFinder(true);
                }
            }
            return true;
        }
        if ("stickyOccurrences".equals(property)) {
            this.fStickyOccurrenceAnnotations = newValue;
            return true;
        }
        return false;
    }

    protected void installOccurrencesFinder(boolean forceUpdate) {
        this.fMarkOccurrenceAnnotations = true;
        this.fPostSelectionListenerWithAST = new ISelectionListenerWithAST(){

            public void selectionChanged(IEditorPart part, ITextSelection selection, ISourceModule module, IModuleDeclaration astRoot) {
                OccurrencesFinder.this.updateOccurrenceAnnotations(selection, module, astRoot);
            }
        };
        SelectionListenerWithASTManager.getDefault().addListener((ITextEditor)this.editor, this.fPostSelectionListenerWithAST);
        if (forceUpdate && this.getSelectionProvider() != null) {
            this.fForcedMarkOccurrencesSelection = this.getSelectionProvider().getSelection();
            ISourceModule inputElement = this.getInputElement();
            if (inputElement != null) {
                this.updateOccurrenceAnnotations((ITextSelection)this.fForcedMarkOccurrencesSelection, inputElement, this.getAST((IModelElement)inputElement, this.getProgressMonitor()));
            }
        }
        if (this.fOccurrencesFinderJobCanceler == null) {
            this.fOccurrencesFinderJobCanceler = new OccurrencesFinderJobCanceler();
            this.fOccurrencesFinderJobCanceler.install();
        }
    }

    protected void uninstallOccurrencesFinder() {
        this.fMarkOccurrenceAnnotations = false;
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
            this.fOccurrencesFinderJob = null;
        }
        if (this.fOccurrencesFinderJobCanceler != null) {
            this.fOccurrencesFinderJobCanceler.uninstall();
            this.fOccurrencesFinderJobCanceler = null;
        }
        if (this.fPostSelectionListenerWithAST != null) {
            SelectionListenerWithASTManager.getDefault().removeListener((ITextEditor)this.editor, this.fPostSelectionListenerWithAST);
            this.fPostSelectionListenerWithAST = null;
        }
        this.removeOccurrenceAnnotations();
    }

    public void updateOccurrenceAnnotations() {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection textSelection = selectionProvider.getSelection();
        if (!(textSelection instanceof ITextSelection)) {
            return;
        }
        ISourceModule inputElement = this.getInputElement();
        if (inputElement == null) {
            return;
        }
        IModuleDeclaration ast = this.getAST((IModelElement)inputElement, this.getProgressMonitor());
        if (ast != null) {
            this.fForcedMarkOccurrencesSelection = textSelection;
            this.updateOccurrenceAnnotations((ITextSelection)textSelection, inputElement, ast);
        }
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, ISourceModule module, IModuleDeclaration astRoot) {
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
        }
        if (!this.fMarkOccurrenceAnnotations) {
            return;
        }
        if (astRoot == null || selection == null) {
            return;
        }
        IDocument document = this.getViewer().getDocument();
        if (document == null) {
            return;
        }
        boolean hasChanged = false;
        if (document instanceof IDocumentExtension4) {
            int offset = selection.getOffset();
            long currentModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
            IRegion markOccurrenceTargetRegion = this.fMarkOccurrenceTargetRegion;
            boolean bl = hasChanged = currentModificationStamp != this.fMarkOccurrenceModificationStamp;
            if (markOccurrenceTargetRegion != null && !hasChanged && markOccurrenceTargetRegion.getOffset() <= offset && offset <= markOccurrenceTargetRegion.getOffset() + markOccurrenceTargetRegion.getLength()) {
                return;
            }
            this.fMarkOccurrenceTargetRegion = ScriptWordFinder.findWord(document, offset);
            this.fMarkOccurrenceModificationStamp = currentModificationStamp;
        }
        IOccurrencesFinder.OccurrenceLocation[] locations = null;
        if (this.finders != null) {
            IOccurrencesFinder[] iOccurrencesFinderArray = this.finders;
            int n = this.finders.length;
            int n2 = 0;
            while (n2 < n) {
                IOccurrencesFinder finder = iOccurrencesFinderArray[n2];
                if (finder.initialize(module, astRoot, selection.getOffset(), selection.getLength()) == null && (locations = finder.getOccurrences()) != null) break;
                ++n2;
            }
        }
        if (locations == null) {
            if (!this.fStickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            } else if (hasChanged) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        this.fOccurrencesFinderJob = new OccurrencesFinderJob(document, locations, (ISelection)selection);
        this.fOccurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        this.fMarkOccurrenceModificationStamp = -1L;
        this.fMarkOccurrenceTargetRegion = null;
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = OccurrencesFinder.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOccurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    private static Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    protected boolean isActivePart() {
        return this.editor.isActivePart();
    }

    protected IEditorSite getEditorSite() {
        return this.editor.getEditorSite();
    }

    protected IModuleDeclaration getAST(IModelElement inputElement, IProgressMonitor progressMonitor) {
        return SourceParserUtil.parse((ISourceModule)((ISourceModule)inputElement), null);
    }

    protected ISourceModule getInputElement() {
        return (ISourceModule)this.editor.getInputModelElement();
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.editor.getProgressMonitor();
    }

    protected ISelectionProvider getSelectionProvider() {
        return this.editor.getSelectionProvider();
    }

    protected IDocumentProvider getDocumentProvider() {
        return this.editor.getDocumentProvider();
    }

    protected IEditorInput getEditorInput() {
        return this.editor.getEditorInput();
    }

    protected ISourceViewer getViewer() {
        return this.editor.getViewer();
    }

    public boolean isValid() {
        return this.finders != null;
    }

    private class ActivationListener
    implements IWindowListener {
        private ActivationListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == OccurrencesFinder.this.getEditorSite().getWorkbenchWindow() && OccurrencesFinder.this.fMarkOccurrenceAnnotations && OccurrencesFinder.this.isActivePart()) {
                OccurrencesFinder.this.fForcedMarkOccurrencesSelection = OccurrencesFinder.this.getSelectionProvider().getSelection();
                ISourceModule inputElement = OccurrencesFinder.this.getInputElement();
                if (inputElement != null) {
                    OccurrencesFinder.this.updateOccurrenceAnnotations((ITextSelection)OccurrencesFinder.this.fForcedMarkOccurrencesSelection, inputElement, OccurrencesFinder.this.getAST((IModelElement)inputElement, OccurrencesFinder.this.getProgressMonitor()));
                }
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            if (window == OccurrencesFinder.this.getEditorSite().getWorkbenchWindow() && OccurrencesFinder.this.fMarkOccurrenceAnnotations && OccurrencesFinder.this.isActivePart()) {
                OccurrencesFinder.this.removeOccurrenceAnnotations();
            }
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    class OccurrencesFinderJob
    extends Job {
        private final IDocument fDocument;
        private final ISelection fSelection;
        private final ISelectionValidator fPostSelectionValidator;
        private boolean fCanceled;
        private final IOccurrencesFinder.OccurrenceLocation[] fLocations;

        public OccurrencesFinderJob(IDocument document, IOccurrencesFinder.OccurrenceLocation[] locations, ISelection selection) {
            super(DLTKEditorMessages.ScriptEditor_markOccurrences_job_name);
            this.fCanceled = false;
            this.fDocument = document;
            this.fSelection = selection;
            this.fLocations = locations;
            this.fPostSelectionValidator = OccurrencesFinder.this.getSelectionProvider() instanceof ISelectionValidator ? (ISelectionValidator)OccurrencesFinder.this.getSelectionProvider() : null;
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled(IProgressMonitor progressMonitor) {
            return this.fCanceled || progressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && OccurrencesFinder.this.fForcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            ISourceViewer textViewer = OccurrencesFinder.this.getViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = OccurrencesFinder.this.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)OccurrencesFinder.this.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fLocations.length;
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
            int i = 0;
            while (i < length) {
                if (this.isCanceled(progressMonitor)) {
                    return Status.CANCEL_STATUS;
                }
                IOccurrencesFinder.OccurrenceLocation location = this.fLocations[i];
                Position position = new Position(location.getOffset(), location.getLength());
                String description = location.getDescription();
                String annotationType = "org.eclipse.dltk.ui.occurrences";
                annotationMap.put(new Annotation(annotationType, false, description), position);
                ++i;
            }
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            Object object = OccurrencesFinder.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(OccurrencesFinder.this.fOccurrenceAnnotations, annotationMap);
                } else {
                    OccurrencesFinder.this.removeOccurrenceAnnotations();
                    for (Map.Entry mapEntry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                    }
                }
                OccurrencesFinder.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }

    class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        OccurrencesFinderJobCanceler() {
        }

        public void install() {
            ISourceViewer sourceViewer = OccurrencesFinder.this.getViewer();
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            IDocument document;
            IDocumentProvider documentProvider;
            ISourceViewer sourceViewer = OccurrencesFinder.this.getViewer();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if ((documentProvider = OccurrencesFinder.this.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)OccurrencesFinder.this.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (OccurrencesFinder.this.fOccurrencesFinderJob != null) {
                OccurrencesFinder.this.fOccurrencesFinderJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }
    }
}

