/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.metadata.query.UpdateQuery;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatePlugin;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.PreviousConfigurationFinder;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration.ImportFromInstallationWizard_c;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationSupport {
    private static final String ECLIPSE_P2_SKIP_MIGRATION_WIZARD = "eclipse.p2.skipMigrationWizard";
    private static final String ECLIPSE_P2_SKIP_MOVED_INSTALL_DETECTION = "eclipse.p2.skipMovedInstallDetection";

    public boolean performMigration(IProvisioningAgent agent, IProfileRegistry registry, IProfile currentProfile) {
        boolean skipWizard = Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty(ECLIPSE_P2_SKIP_MIGRATION_WIZARD));
        if (skipWizard) {
            return false;
        }
        IProfile previousProfile = null;
        URI[] reposToMigrate = null;
        if (!this.skipFirstTimeMigration() && !this.configurationSpecifiedManually() && this.isFirstTimeRunningThisSharedInstance(agent, registry, currentProfile)) {
            File searchRoot = this.getSearchLocation();
            if (searchRoot == null) {
                return false;
            }
            IProvisioningAgent otherConfigAgent = new PreviousConfigurationFinder(this.getConfigurationLocation().getParentFile()).findPreviousInstalls(searchRoot, this.getInstallFolder());
            if (otherConfigAgent == null) {
                return false;
            }
            previousProfile = ((IProfileRegistry)otherConfigAgent.getService(IProfileRegistry.SERVICE_NAME)).getProfile("_SELF_");
            if (previousProfile == null) {
                return false;
            }
            reposToMigrate = ((IMetadataRepositoryManager)otherConfigAgent.getService(IMetadataRepositoryManager.SERVICE_NAME)).getKnownRepositories(2);
            reposToMigrate = Arrays.copyOf(reposToMigrate, reposToMigrate.length + 1);
            reposToMigrate[reposToMigrate.length - 1] = this.getURIForProfile(otherConfigAgent, previousProfile);
        }
        if (previousProfile == null && this.baseChangedSinceLastPresentationOfWizard(agent, registry, currentProfile)) {
            previousProfile = this.findMostRecentReset(registry, currentProfile);
        }
        if (previousProfile == null) {
            return false;
        }
        if (this.needsMigration(previousProfile, currentProfile)) {
            this.openMigrationWizard(previousProfile, reposToMigrate);
        } else {
            this.rememberMigrationCompleted();
        }
        return true;
    }

    private URI getURIForProfile(IProvisioningAgent agent, IProfile profile) {
        IAgentLocation agentLocation = (IAgentLocation)agent.getService(IAgentLocation.SERVICE_NAME);
        return URIUtil.append((URI)agentLocation.getRootLocation(), (String)("org.eclipse.equinox.p2.engine/profileRegistry/" + profile.getProfileId() + ".profile"));
    }

    private File getInstallFolder() {
        Location configurationLocation = (Location)ServiceHelper.getService((BundleContext)EngineActivator.getContext(), (String)Location.class.getName(), (String)Location.INSTALL_FILTER);
        return new File(configurationLocation.getURL().getPath());
    }

    private File getSearchLocation() {
        File parent = this.getConfigurationLocation().getParentFile();
        if (parent == null) {
            return null;
        }
        return parent.getParentFile();
    }

    private File getConfigurationLocation() {
        Location configurationLocation = (Location)ServiceHelper.getService((BundleContext)EngineActivator.getContext(), (String)Location.class.getName(), (String)Location.CONFIGURATION_FILTER);
        File configurationFolder = new File(configurationLocation.getURL().getPath());
        return configurationFolder;
    }

    private boolean configurationSpecifiedManually() {
        String commandLine = System.getProperty("eclipse.commands");
        if (commandLine == null) {
            return false;
        }
        return commandLine.contains("-configuration\n");
    }

    private boolean skipFirstTimeMigration() {
        return Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty(ECLIPSE_P2_SKIP_MOVED_INSTALL_DETECTION));
    }

    private boolean isFirstTimeRunningThisSharedInstance(IProvisioningAgent agent, IProfileRegistry registry, IProfile currentProfile) {
        long[] history = registry.listProfileTimestamps(currentProfile.getProfileId());
        boolean isInitial = "initial".equals(registry.getProfileStateProperties(currentProfile.getProfileId(), history[0]).get("org.eclipse.equinox.p2.state.shared"));
        if (isInitial) {
            if (this.getLastMigration() >= history[0]) {
                return false;
            }
            Map sharedRelatedValues = registry.getProfileStateProperties(currentProfile.getProfileId(), "org.eclipse.equinox.p2.state.shared");
            return !sharedRelatedValues.containsValue("new");
        }
        return false;
    }

    protected boolean needsMigration(IProfile previousProfile, IProfile currentProfile) {
        Set<IInstallableUnit> previousProfileUnits = this.getUserRoots(previousProfile);
        Set currentProfileUnits = currentProfile.available((IQuery)new UserVisibleRootQuery(), null).toSet();
        previousProfileUnits.removeAll(currentProfileUnits);
        Iterator<IInstallableUnit> previousProfileIterator = previousProfileUnits.iterator();
        while (previousProfileIterator.hasNext()) {
            if (currentProfile.available(QueryUtil.createIUQuery((IVersionedId)((IVersionedId)previousProfileIterator.next())), null).isEmpty()) continue;
            previousProfileIterator.remove();
        }
        previousProfileIterator = previousProfileUnits.iterator();
        while (previousProfileIterator.hasNext()) {
            if (currentProfile.available((IQuery)new UpdateQuery(previousProfileIterator.next()), null).isEmpty()) continue;
            previousProfileIterator.remove();
        }
        return !previousProfileUnits.isEmpty();
    }

    private Set<IInstallableUnit> getUserRoots(IProfile previousProfile) {
        IQueryResult allRoots = previousProfile.query((IQuery)new UserVisibleRootQuery(), null);
        Set rootsFromTheBase = previousProfile.query((IQuery)new IUProfilePropertyQuery("org.eclipse.equinox.p2.base", "true"), null).toUnmodifiableSet();
        Set userRoots = allRoots.toSet();
        userRoots.removeAll(rootsFromTheBase);
        return userRoots;
    }

    protected void openMigrationWizard(final IProfile inputProfile, final URI[] reposToMigrate) {
        Display d = Display.getDefault();
        d.asyncExec(new Runnable(){

            public void run() {
                WizardDialog migrateWizard = new WizardDialog(MigrationSupport.this.getWorkbenchWindowShell(), (IWizard)new ImportFromInstallationWizard_c(inputProfile, reposToMigrate, reposToMigrate != null));
                migrateWizard.create();
                migrateWizard.open();
            }
        });
    }

    private boolean baseChangedSinceLastPresentationOfWizard(IProvisioningAgent agent, IProfileRegistry registry, IProfile profile) {
        long lastResetTimestamp;
        long lastProfileMigrated = this.getLastMigration();
        return lastProfileMigrated <= (lastResetTimestamp = this.findMostRecentResetTimestamp(registry, profile));
    }

    private long findMostRecentResetTimestamp(IProfileRegistry registry, IProfile profile) {
        long[] history = registry.listProfileTimestamps(profile.getProfileId());
        int index = history.length - 1;
        boolean found = false;
        while (!(found = "beforeFlush".equals(registry.getProfileStateProperties(profile.getProfileId(), history[index]).get("org.eclipse.equinox.p2.state.shared"))) && index > 0) {
            --index;
        }
        if (!found) {
            return -1L;
        }
        return history[index];
    }

    private IProfile findMostRecentReset(IProfileRegistry registry, IProfile profile) {
        long ts = this.findMostRecentResetTimestamp(registry, profile);
        if (ts == -1L) {
            return null;
        }
        return registry.getProfile(profile.getProfileId(), ts);
    }

    Shell getWorkbenchWindowShell() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return activeWindow != null ? activeWindow.getShell() : null;
    }

    public void rememberMigrationCompleted() {
        IProfileRegistry registry = (IProfileRegistry)ProvisioningUI.getDefaultUI().getSession().getProvisioningAgent().getService(IProfileRegistry.SERVICE_NAME);
        long[] history = registry.listProfileTimestamps(ProvisioningUI.getDefaultUI().getProfileId());
        AutomaticUpdatePlugin.getDefault().getPreferenceStore().setValue("migrationDialogShown", history[history.length - 1]);
        AutomaticUpdatePlugin.getDefault().savePreferences();
    }

    public long getLastMigration() {
        return AutomaticUpdatePlugin.getDefault().getPreferenceStore().getLong("migrationDialogShown");
    }
}

