/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.contexts.NestableContextService;
import org.eclipse.ui.internal.expressions.ActivePartExpression;
import org.eclipse.ui.internal.handlers.LegacyHandlerService;
import org.eclipse.ui.internal.part.IPageSiteHolder;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.services.IDisposable;

public class PageSite
implements IPageSite,
INestable {
    private ArrayList menuExtenders;
    private IViewSite parentSite;
    private ISelectionProvider selectionProvider;
    private final ServiceLocator serviceLocator;
    private SubActionBars subActionBars;
    private IEclipseContext e4Context;
    private NestableContextService contextService;
    private boolean active = false;

    public PageSite(IViewSite parentViewSite) {
        Assert.isNotNull((Object)parentViewSite);
        this.parentSite = parentViewSite;
        this.subActionBars = new SubActionBars(parentViewSite.getActionBars(), this);
        IServiceLocatorCreator slc = (IServiceLocatorCreator)this.parentSite.getService(IServiceLocatorCreator.class);
        this.e4Context = ((PartSite)((Object)parentViewSite)).getContext().createChild("PageSite");
        this.serviceLocator = (ServiceLocator)slc.createServiceLocator(parentViewSite, null, new IDisposable(){

            public void dispose() {
            }
        }, this.e4Context);
        this.initializeDefaultServices();
    }

    private void initializeDefaultServices() {
        this.serviceLocator.registerService(IWorkbenchLocationService.class, new WorkbenchLocationService("org.eclipse.ui.part.PageSite", this.getWorkbenchWindow().getWorkbench(), this.getWorkbenchWindow(), this.parentSite, null, this, 3));
        this.serviceLocator.registerService(IPageSiteHolder.class, new IPageSiteHolder(){

            public IPageSite getSite() {
                return PageSite.this;
            }
        });
        LegacyHandlerService handlerService = new LegacyHandlerService(this.e4Context);
        this.e4Context.set(IHandlerService.class, (Object)handlerService);
        this.e4Context.set(IContextService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (PageSite.this.contextService == null) {
                    PageSite.this.contextService = new NestableContextService((IContextService)context.getParent().get(IContextService.class), new ActivePartExpression(PageSite.this.parentSite.getPart()));
                }
                return PageSite.this.contextService;
            }
        });
    }

    protected void dispose() {
        if (this.menuExtenders != null) {
            HashSet<MenuManager> managers = new HashSet<MenuManager>(this.menuExtenders.size());
            int i = 0;
            while (i < this.menuExtenders.size()) {
                PopupMenuExtender ext = (PopupMenuExtender)this.menuExtenders.get(i);
                managers.add(ext.getManager());
                ext.dispose();
                ++i;
            }
            if (managers.size() > 0) {
                for (MenuManager mgr : managers) {
                    mgr.dispose();
                }
            }
            this.menuExtenders = null;
        }
        this.subActionBars.dispose();
        if (this.contextService != null) {
            this.contextService.dispose();
        }
        this.serviceLocator.dispose();
        this.e4Context.dispose();
    }

    public IActionBars getActionBars() {
        return this.subActionBars;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IWorkbenchPage getPage() {
        return this.parentSite.getPage();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public final Object getService(Class key) {
        Object service = this.serviceLocator.getService(key);
        if (this.active && service instanceof INestable) {
            ((INestable)service).activate();
        }
        return service;
    }

    public Shell getShell() {
        return this.parentSite.getShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.parentSite.getWorkbenchWindow();
    }

    public final boolean hasService(Class key) {
        return this.serviceLocator.hasService(key);
    }

    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        PartSite.registerContextMenu(menuID, menuMgr, selProvider, false, this.parentSite.getPart(), this.e4Context, this.menuExtenders);
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public void activate() {
        this.active = true;
        this.e4Context.activate();
        this.serviceLocator.activate();
        if (this.contextService != null) {
            this.contextService.activate();
        }
    }

    public void deactivate() {
        this.active = false;
        if (this.contextService != null) {
            this.contextService.deactivate();
        }
        this.serviceLocator.deactivate();
        this.e4Context.deactivate();
    }
}

