/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.interpreters.InterpretersUpdater;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public abstract class ScriptInterpreterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private InterpretersBlock fInterpretersBlock;

    public ScriptInterpreterPreferencePage() {
        this.setTitle(InterpretersMessages.InterpretersPreferencePage_1);
        this.setDescription(InterpretersMessages.InterpretersPreferencePage_2);
    }

    public void init(IWorkbench workbench) {
    }

    public abstract InterpretersBlock createInterpretersBlock();

    private void initDefaultInterpreter() {
        IEnvironment[] environments = EnvironmentManager.getEnvironments();
        int j = 0;
        while (j < environments.length) {
            IInterpreterInstall realDefault = ScriptRuntime.getDefaultInterpreterInstall((String)this.fInterpretersBlock.getCurrentNature(), (IEnvironment)environments[j]);
            boolean verified = false;
            if (realDefault != null) {
                IInterpreterInstall[] Interpreters = this.fInterpretersBlock.getInterpreters();
                int i = 0;
                while (i < Interpreters.length) {
                    IInterpreterInstall fakeInterpreter = Interpreters[i];
                    if (fakeInterpreter.equals(realDefault)) {
                        verified = true;
                        this.verifyDefaultInterpreter(fakeInterpreter);
                        break;
                    }
                    ++i;
                }
            }
            if (!verified) {
                if (this.fInterpretersBlock.getInterpreters().length > 0) {
                    this.setErrorMessage(InterpretersMessages.InterpreterPreferencePage_pleaseSetDefaultInterpreter);
                } else {
                    this.setErrorMessage(InterpretersMessages.InterpreterPreferencePage_addInterpreter);
                }
            }
            ++j;
        }
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        this.fInterpretersBlock = this.createInterpretersBlock();
        this.fInterpretersBlock.createControl(ancestor);
        Control control = this.fInterpretersBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.fInterpretersBlock.restoreColumnSettings(this.getDialogSettings(false), "org.eclipse.dltk.debug.ui.interpreter_preference_page_context");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)ancestor, "org.eclipse.dltk.debug.ui.interpreter_preference_page_context");
        this.initDefaultInterpreter();
        this.fInterpretersBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IInterpreterInstall[] install = ScriptInterpreterPreferencePage.this.getCurrentDefaultInterpreters();
                ScriptInterpreterPreferencePage.this.setErrorMessage(null);
                if (ScriptInterpreterPreferencePage.this.fInterpretersBlock.getInterpreters().length > 0 && install.length < ScriptInterpreterPreferencePage.this.fInterpretersBlock.getEnvironmentsCount()) {
                    ScriptInterpreterPreferencePage.this.setErrorMessage(InterpretersMessages.InterpreterPreferencePage_pleaseSetDefaultInterpreter);
                } else if (ScriptInterpreterPreferencePage.this.fInterpretersBlock.getInterpreters().length == 0) {
                    ScriptInterpreterPreferencePage.this.setErrorMessage(InterpretersMessages.InterpreterPreferencePage_addInterpreter);
                }
            }
        });
        this.applyDialogFont(ancestor);
        return ancestor;
    }

    public boolean performOk() {
        final boolean[] canceled = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                IInterpreterInstall[] defaultInterpreter = ScriptInterpreterPreferencePage.this.getCurrentDefaultInterpreters();
                IInterpreterInstall[] interpreters = ScriptInterpreterPreferencePage.this.fInterpretersBlock.getInterpreters();
                InterpretersUpdater updater = new InterpretersUpdater();
                if (!updater.updateInterpreterSettings(ScriptInterpreterPreferencePage.this.fInterpretersBlock.getCurrentNature(), interpreters, defaultInterpreter)) {
                    canceled[0] = true;
                }
            }
        });
        if (canceled[0]) {
            return false;
        }
        this.fInterpretersBlock.saveColumnSettings(this.getDialogSettings(true), "org.eclipse.dltk.debug.ui.interpreter_preference_page_context");
        return super.performOk();
    }

    protected IDialogSettings getDialogSettings(boolean isSaving) {
        String nature;
        IDialogSettings settings = DLTKDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(nature = this.fInterpretersBlock.getCurrentNature());
        if (section == null) {
            section = isSaving ? settings.addNewSection(nature) : settings;
        }
        return section;
    }

    @Deprecated
    protected IScriptModel getScriptModel() {
        return DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void verifyDefaultInterpreter(IInterpreterInstall interpreter) {
        if (interpreter == null) {
            this.fInterpretersBlock.setCheckedInterpreter(null);
            return;
        }
        boolean exist = true;
        exist = interpreter.getInstallLocation().exists();
        if (exist) {
            this.fInterpretersBlock.setCheckedInterpreter(interpreter);
            return;
        }
        this.fInterpretersBlock.removeInterpreters(new IInterpreterInstall[]{interpreter});
        IInterpreterInstall def = null;
        def = ScriptRuntime.getDefaultInterpreterInstall((String)this.fInterpretersBlock.getCurrentNature(), (IEnvironment)this.fInterpretersBlock.getCurrentEnvironment());
        if (def == null) {
            this.fInterpretersBlock.setCheckedInterpreter(null);
        } else {
            this.fInterpretersBlock.setCheckedInterpreter(def);
        }
        ErrorDialog.openError((Shell)this.getControl().getShell(), (String)InterpretersMessages.InterpretersPreferencePage_1, (String)InterpretersMessages.InterpretersPreferencePage_10, (IStatus)new Status(4, "org.eclipse.dltk.debug.ui", 0, InterpretersMessages.InterpretersPreferencePage_11, null));
    }

    private IInterpreterInstall[] getCurrentDefaultInterpreters() {
        return this.fInterpretersBlock.getCheckedInterpreters();
    }
}

