/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.completion;

import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaDLTKModelUtils;
import org.eclipse.koneki.ldt.ui.internal.Activator;
import org.eclipse.koneki.ldt.ui.internal.editor.navigation.Messages;

public class LuaCompletionProposalLabelProvide
extends CompletionProposalLabelProvider {
    protected String createMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(methodProposal.getName());
        buffer.append('(');
        this.appendParameterList(buffer, methodProposal);
        buffer.append(')');
        IModelElement element = methodProposal.getModelElement();
        if (element != null && element.getElementType() == 9 && element.exists()) {
            IMethod method = (IMethod)element;
            try {
                if (!method.isConstructor()) {
                    IType declaringType;
                    String type = method.getType();
                    if (type != null) {
                        buffer.append(" : ").append(type);
                    }
                    if ((declaringType = method.getDeclaringType()) != null) {
                        buffer.append(" - ").append(declaringType.getElementName());
                    }
                }
            }
            catch (ModelException modelException) {}
        }
        return buffer.toString();
    }

    protected String createSimpleLabelWithType(CompletionProposal proposal) {
        ILocalVariable var;
        String type;
        IModelElement element = proposal.getModelElement();
        if (element != null && element.getElementType() == 13 && element.exists() && (type = (var = (ILocalVariable)element).getType()) != null) {
            return String.valueOf(proposal.getName()) + " : " + type;
        }
        return proposal.getName();
    }

    protected String createFieldProposalLabel(CompletionProposal proposal) {
        IModelElement element = proposal.getModelElement();
        if (element != null && element.getElementType() == 8 && element.exists()) {
            IField field = (IField)element;
            try {
                String type = field.getType();
                if (type != null) {
                    return String.valueOf(proposal.getName()) + " : " + type;
                }
            }
            catch (ModelException modelException) {}
        }
        return proposal.getName();
    }

    protected ImageDescriptor createFieldImageDescriptor(CompletionProposal proposal) {
        if (proposal.getModelElement() instanceof IMember) {
            IMember member = (IMember)proposal.getModelElement();
            try {
                if (member.exists()) {
                    if (LuaDLTKModelUtils.isModuleFunction((IMember)member)) {
                        return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/module_function.gif");
                    }
                    if (LuaDLTKModelUtils.isModuleField((IMember)member)) {
                        return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/module_field.gif");
                    }
                    if (LuaDLTKModelUtils.isModuleTable((IMember)member)) {
                        return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/module_table.gif");
                    }
                    if (LuaDLTKModelUtils.isPrivateFunction((IMember)member)) {
                        return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/private_function.gif");
                    }
                    if (LuaDLTKModelUtils.isPrivateField((IMember)member)) {
                        return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/private_field.gif");
                    }
                    if (LuaDLTKModelUtils.isPrivateTable((IMember)member)) {
                        return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/private_table2.png");
                    }
                    if (LuaDLTKModelUtils.isPublicFunction((IMember)member)) {
                        return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/public_function.gif");
                    }
                    if (LuaDLTKModelUtils.isPublicField((IMember)member)) {
                        return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/public_field.gif");
                    }
                    if (LuaDLTKModelUtils.isPublicTable((IMember)member)) {
                        return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/public_table.png");
                    }
                }
            }
            catch (ModelException e) {
                Activator.logError(Messages.LuaCompletionProvidersFlags, e);
                return super.createImageDescriptor(proposal);
            }
        }
        return super.createImageDescriptor(proposal);
    }

    public ImageDescriptor createTypeImageDescriptor(CompletionProposal proposal) {
        if (proposal.getModelElement() instanceof IMember) {
            IMember member = (IMember)proposal.getModelElement();
            try {
                if (member.exists()) {
                    if (LuaDLTKModelUtils.isModule((IMember)member)) {
                        return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/module.gif");
                    }
                    if (LuaDLTKModelUtils.isType((IMember)member)) {
                        return Activator.getDefault().getImageRegistry().getDescriptor("icons/obj16/type.gif");
                    }
                }
            }
            catch (ModelException e) {
                Activator.logError(Messages.LuaCompletionProvidersFlags, e);
                return super.createImageDescriptor(proposal);
            }
        }
        return super.createImageDescriptor(proposal);
    }
}

