/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.ui.wizards.ILocationGroup;
import org.eclipse.dltk.ui.wizards.IProjectWizard;
import org.eclipse.dltk.ui.wizards.ProjectCreator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.koneki.ldt.core.internal.buildpath.LuaExecutionEnvironment;
import org.eclipse.koneki.ldt.core.internal.buildpath.LuaExecutionEnvironmentBuildpathUtil;
import org.eclipse.koneki.ldt.ui.internal.Activator;
import org.eclipse.koneki.ldt.ui.wizards.Messages;
import org.eclipse.koneki.ldt.ui.wizards.pages.LuaProjectSettingsPage;

public class LuaProjectCreator
extends ProjectCreator {
    private LuaProjectSettingsPage luaProjectSettingPage;

    public LuaProjectCreator(IProjectWizard owner, LuaProjectSettingsPage locationGroup) {
        super(owner, (ILocationGroup)locationGroup);
        this.luaProjectSettingPage = locationGroup;
        ProjectCreator.ProjectCreateStep createSourceFolderStep = this.createSourceFolderStep();
        if (createSourceFolderStep != null) {
            this.addStep("finish", 0, (ProjectCreator.IProjectCreateStep)createSourceFolderStep, (IWizardPage)locationGroup);
        }
    }

    protected List<IBuildpathEntry> getDefaultBuildpathEntries() {
        ArrayList<IBuildpathEntry> buildPath = new ArrayList<IBuildpathEntry>();
        if (!this.luaProjectSettingPage.isExistingLocation()) {
            boolean useTemplateBuildpath = false;
            LuaExecutionEnvironment luaExecutionEnvironment = this.luaProjectSettingPage.getExecutionEnvironment();
            if (luaExecutionEnvironment != null) {
                Map defaultTemplateInfo;
                IPath path = LuaExecutionEnvironmentBuildpathUtil.getLuaExecutionEnvironmentContainerPath((LuaExecutionEnvironment)luaExecutionEnvironment);
                IBuildpathEntry newContainerEntry = DLTKCore.newContainerEntry((IPath)path);
                buildPath.add(newContainerEntry);
                if (this.luaProjectSettingPage.hasToCreateTemplate() && (defaultTemplateInfo = luaExecutionEnvironment.getDefaultTemplateInfo()) != null && defaultTemplateInfo.get("buildpath") instanceof Map && luaExecutionEnvironment.getTemplatesPath() != null) {
                    useTemplateBuildpath = true;
                    Map templateBuildPathEntries = (Map)defaultTemplateInfo.get("buildpath");
                    for (Object entry : templateBuildPathEntries.values()) {
                        IBuildpathEntry newSourceEntry;
                        if (!(entry instanceof String)) continue;
                        if ("/".equals(entry) || ".".equals(entry) || "./".equals(entry) || "/.".equals(entry)) {
                            newSourceEntry = DLTKCore.newSourceEntry((IPath)this.getProject().getFullPath());
                        } else {
                            IFolder sourcefolder = this.getProject().getFolder((String)entry);
                            newSourceEntry = DLTKCore.newSourceEntry((IPath)sourcefolder.getFullPath());
                        }
                        buildPath.add(newSourceEntry);
                    }
                }
            }
            if (!useTemplateBuildpath) {
                IFolder sourcefolder = this.getProject().getFolder("src");
                IBuildpathEntry newSourceEntry = DLTKCore.newSourceEntry((IPath)sourcefolder.getFullPath());
                buildPath.add(newSourceEntry);
            }
        }
        return buildPath;
    }

    protected IBuildpathEntry[] initBuildpath(IProgressMonitor monitor) throws CoreException {
        ArrayList<IBuildpathEntry> entries = new ArrayList<IBuildpathEntry>(this.getDefaultBuildpathEntries());
        monitor.done();
        return entries.toArray(new IBuildpathEntry[entries.size()]);
    }

    public ILocationGroup getLocationGroup() {
        return this.luaProjectSettingPage;
    }

    protected ProjectCreator.ProjectCreateStep createSourceFolderStep() {
        return new CreateDefaultSourceFolderProjectCreateStep();
    }

    private class CreateDefaultSourceFolderProjectCreateStep
    extends ProjectCreator.ProjectCreateStep {
        private CreateDefaultSourceFolderProjectCreateStep() {
        }

        public void execute(IProject project, IProgressMonitor monitor) throws CoreException, InterruptedException {
            monitor.beginTask(Messages.LuaProjectCreatorInitializingSourceFolder, 1);
            if (!LuaProjectCreator.this.luaProjectSettingPage.isExistingLocation() && LuaProjectCreator.this.luaProjectSettingPage.hasToCreateTemplate()) {
                IFolder srcFolder;
                boolean foundTemplate = false;
                LuaExecutionEnvironment ee = LuaProjectCreator.this.luaProjectSettingPage.getExecutionEnvironment();
                if (ee != null) {
                    IFolder srcFolder2;
                    IPath templatesPath = ee.getTemplatesPath();
                    if (templatesPath != null) {
                        File templateFile = templatesPath.append("default").toFile();
                        if (templateFile != null && templateFile.exists() && templateFile.listFiles().length > 0) {
                            foundTemplate = true;
                            try {
                                FileUtils.copyDirectory((File)templateFile, (File)project.getLocation().toFile());
                            }
                            catch (IOException e) {
                                Activator.logError(MessageFormat.format("Unable to copy {0} from EE {1}.", templateFile.toString(), ee), e);
                            }
                        }
                    } else if (ee.getOldTemplatePath() != null && (srcFolder2 = project.getFolder("src")) != null) {
                        IPath mainPath = ee.getOldTemplatePath().append("main.lua");
                        foundTemplate = true;
                        try {
                            FileUtils.copyFileToDirectory((File)mainPath.toFile(), (File)srcFolder2.getLocation().toFile());
                        }
                        catch (IOException e) {
                            Activator.logError(MessageFormat.format("Unable to copy 'main.lua' from EE {0}.", ee), e);
                        }
                    }
                }
                if (!foundTemplate && (srcFolder = project.getFolder("src")) != null) {
                    IFile mainFile = srcFolder.getFile("main.lua");
                    ByteArrayInputStream mainContent = null;
                    mainContent = new ByteArrayInputStream("local function main()\n\nend\nmain()\n".getBytes());
                    mainFile.create((InputStream)mainContent, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.done();
        }
    }
}

