/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.wizards;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.ui.wizards.GenericDLTKProjectWizard;
import org.eclipse.dltk.ui.wizards.IProjectWizard;
import org.eclipse.dltk.ui.wizards.ProjectCreator;
import org.eclipse.dltk.ui.wizards.ProjectWizardSecondPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.koneki.ldt.core.internal.buildpath.LuaExecutionEnvironment;
import org.eclipse.koneki.ldt.ui.internal.Activator;
import org.eclipse.koneki.ldt.ui.wizards.LuaProjectCreator;
import org.eclipse.koneki.ldt.ui.wizards.Messages;
import org.eclipse.koneki.ldt.ui.wizards.pages.LuaProjectSettingsPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class LuaProjectWizard
extends GenericDLTKProjectWizard {
    private final LuaProjectSettingsPage firstPage = new LuaProjectSettingsPage();

    public LuaProjectWizard() {
        this.setWindowTitle(Messages.LuaProjectWizardProjectWindowTitle);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.getFirstPage());
        this.addPage((IWizardPage)new ProjectWizardSecondPage(this.getFirstPage()){

            protected void updateStatus(IStatus status) {
                super.updateStatus(status);
                IBuildpathEntry[] rawBuildPath = this.getRawBuildPath();
                boolean sourcepathfound = false;
                IBuildpathEntry[] iBuildpathEntryArray = rawBuildPath;
                int n = rawBuildPath.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildpathEntry buildpathEntry = iBuildpathEntryArray[n2];
                    if (buildpathEntry.getEntryKind() == 3) {
                        sourcepathfound = true;
                        break;
                    }
                    ++n2;
                }
                if (!sourcepathfound) {
                    this.setMessage(Messages.LuaProjectWizard_warning_noSourceFolder, 2);
                }
            }
        });
    }

    public String getScriptNature() {
        return "org.eclipse.koneki.ldt.nature";
    }

    protected ProjectCreator createProjectCreator() {
        return new LuaProjectCreator((IProjectWizard)this, this.getFirstPage());
    }

    protected LuaProjectSettingsPage getFirstPage() {
        return this.firstPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setDefaultPageImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("icons/wizban/lua_newprj_wiz.png"));
    }

    public boolean performFinish() {
        boolean superResult = super.performFinish();
        if (this.firstPage.hasToCreateTemplate()) {
            IFile fileToOpen;
            Object openfile;
            IPath filePathToOpen = null;
            LuaExecutionEnvironment ee = this.firstPage.getExecutionEnvironment();
            if (ee != null && ee.getDefaultTemplateInfo() != null && (openfile = ee.getDefaultTemplateInfo().get(LuaExecutionEnvironment.OPEN_FILE)) instanceof String) {
                filePathToOpen = new Path((String)openfile);
            }
            if (filePathToOpen == null) {
                filePathToOpen = new Path("src").append("main.lua");
            }
            if ((fileToOpen = this.getProject().getFile(filePathToOpen)).exists()) {
                try {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)fileToOpen, (boolean)true);
                }
                catch (PartInitException e) {
                    String message = MessageFormat.format("Unable to open lua editor for %s", fileToOpen.getFullPath());
                    Activator.logError(message, e);
                }
            }
        }
        return superResult;
    }
}

